/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.file;

import com.bc.ceres.swing.TableLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductIOPlugInManager;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.file.Bundle;
import org.esa.snap.rcp.actions.file.OpenProductAction;
import org.esa.snap.rcp.actions.file.ProductFileChooser;
import org.esa.snap.rcp.actions.file.ReadProductOperation;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.vfs.NioPaths;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.RequestProcessor;

public class ProductOpener {
    public static final String PREFERENCES_KEY_LAST_PRODUCT_DIR = "last_product_open_dir";
    private static final String PREFERENCES_KEY_PREFIX_ALTERNATIVE_READER = "open_alternative_reader.";
    private static final String PREFERENCES_KEY_DONT_SHOW_DIALOG = "multipleReadersDialog.dontShow";
    private static final int IMMEDIATELY = 0;
    private String fileFormat;
    private boolean useAllFileFilter;
    private boolean subsetImportEnabled;
    private File[] files;
    private boolean multiSelectionEnabled;
    private ProductSubsetDef productSubsetDef = null;
    private ProductReaderPlugIn plugin = null;

    public void setFiles(File ... files) {
        this.files = files;
    }

    public File[] getFiles() {
        return this.files;
    }

    void setFileFormat(String format) {
        this.fileFormat = format;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    void setUseAllFileFilter(boolean useAllFileFilter) {
        this.useAllFileFilter = useAllFileFilter;
    }

    public boolean isUseAllFileFilter() {
        return this.useAllFileFilter;
    }

    void setSubsetImportEnabled(boolean subsetImportEnabled) {
        this.subsetImportEnabled = subsetImportEnabled;
    }

    public boolean isSubsetImportEnabled() {
        return this.subsetImportEnabled;
    }

    public void setMultiSelectionEnabled(boolean multiSelectionEnabled) {
        this.multiSelectionEnabled = multiSelectionEnabled;
    }

    public boolean isMultiSelectionEnabled() {
        return this.multiSelectionEnabled;
    }

    public Boolean openProduct() {
        Iterator readerPlugIns;
        File[] configuredFiles = this.getFiles();
        if (configuredFiles != null) {
            return this.openProductFilesCheckOpened(this.getFileFormat(), configuredFiles);
        }
        if (this.getFileFormat() != null) {
            readerPlugIns = ProductIOPlugInManager.getInstance().getReaderPlugIns(this.getFileFormat());
            if (!readerPlugIns.hasNext()) {
                Dialogs.showError(Bundle.LBL_NoReaderFoundText() + String.format("%nCan't find reader for the given format '%s'.", this.getFileFormat()));
                return false;
            }
        } else {
            readerPlugIns = ProductIOPlugInManager.getInstance().getAllReaderPlugIns();
        }
        ArrayList<SnapFileFilter> filters = new ArrayList<SnapFileFilter>();
        while (readerPlugIns.hasNext()) {
            ProductReaderPlugIn readerPlugIn = (ProductReaderPlugIn)readerPlugIns.next();
            SnapFileFilter snapFileFilter = readerPlugIn.getProductFileFilter();
            if (snapFileFilter == null) continue;
            filters.add(snapFileFilter);
        }
        Collections.sort(filters, (f1, f2) -> {
            String d1 = f1.getDescription();
            String d2 = f2.getDescription();
            return d1 != null ? d1.compareTo(d2) : (d2 == null ? 0 : 1);
        });
        if (filters.isEmpty()) {
            Dialogs.showError(Bundle.LBL_NoReaderFoundText());
            return false;
        }
        Preferences preferences = SnapApp.getDefault().getPreferences();
        String userHomePath = SystemUtils.getUserHomeDir().getAbsolutePath();
        Path recentPath = NioPaths.get((String)preferences.get(PREFERENCES_KEY_LAST_PRODUCT_DIR, userHomePath), (String[])new String[0]);
        ProductFileChooser fc = new ProductFileChooser(recentPath.toFile());
        fc.setSubsetEnabled(this.isSubsetImportEnabled());
        fc.setAdvancedEnabled(true);
        fc.setDialogTitle(SnapApp.getDefault().getInstanceName() + " - " + Bundle.CTL_OpenProductActionName());
        fc.setAcceptAllFileFilterUsed(this.isUseAllFileFilter());
        filters.forEach(filter -> {
            fc.addChoosableFileFilter((FileFilter)filter);
            if (this.getFileFormat() != null && this.getFileFormat().equals(filter.getFormatName())) {
                fc.setFileFilter((FileFilter)filter);
            }
        });
        fc.setMultiSelectionEnabled(this.isMultiSelectionEnabled());
        if (filters.size() == 1) {
            fc.setFileSelectionMode(((SnapFileFilter)filters.get(0)).getFileSelectionMode().getValue());
        } else {
            fc.setFileSelectionMode(0);
        }
        int returnVal = fc.showOpenDialog(SnapApp.getDefault().getMainFrame());
        if (returnVal != 0) {
            return null;
        }
        File[] files = this.getSelectedFiles(fc);
        if (files == null || files.length == 0) {
            return null;
        }
        File currentDirectory = fc.getCurrentDirectory();
        if (currentDirectory != null) {
            preferences.put(PREFERENCES_KEY_LAST_PRODUCT_DIR, currentDirectory.toString());
        }
        if (fc.getSubsetProduct() != null) {
            SnapApp.getDefault().getProductManager().addProduct(fc.getSubsetProduct());
            return true;
        }
        if (fc.getProductSubsetDef() != null || fc.getProductReaderPlugin() != null) {
            this.productSubsetDef = fc.getProductSubsetDef();
            this.plugin = fc.getProductReaderPlugin();
        }
        String formatName = fc.getFileFilter() instanceof SnapFileFilter ? ((SnapFileFilter)fc.getFileFilter()).getFormatName() : null;
        return this.openProductFilesCheckOpened(formatName, files);
    }

    private File[] getSelectedFiles(ProductFileChooser fc) {
        File[] files = new File[]{};
        if (this.isMultiSelectionEnabled()) {
            files = fc.getSelectedFiles();
        } else {
            File file = fc.getSelectedFile();
            if (file != null) {
                files = new File[]{file};
            }
        }
        return files;
    }

    private Boolean openProductFilesCheckOpened(String formatName, File ... files) {
        List<File> openedFiles = OpenProductAction.getOpenedProductFiles();
        ArrayList<File> fileList = new ArrayList<File>(Arrays.asList(files));
        for (File file : files) {
            if (!file.exists()) {
                fileList.remove(file);
                continue;
            }
            if (!openedFiles.contains(file)) continue;
            Dialogs.Answer answer = Dialogs.requestDecision(Bundle.CTL_OpenProductActionName(), MessageFormat.format("Product\n{0}\nis already opened.\nDo you want to open another instance?", file), true, null);
            if (answer == Dialogs.Answer.NO) {
                fileList.remove(file);
                continue;
            }
            if (answer != Dialogs.Answer.CANCELLED) continue;
            return null;
        }
        RequestProcessor rp = new RequestProcessor("Opening Products", 4, true, true);
        for (File file : fileList) {
            String fileFormatName;
            if (formatName == null && this.plugin == null) {
                PluginEntry entry;
                Map<DecodeQualification, List<PluginEntry>> plugins = ProductOpener.getPluginsForFile(file);
                if (plugins.isEmpty() || plugins.get(DecodeQualification.INTENDED).size() == 0 && plugins.get(DecodeQualification.SUITABLE).size() == 0) {
                    Dialogs.showError(Bundle.LBL_NoReaderFoundText() + String.format("%nFile '%s' can not be opened.", file));
                    continue;
                }
                if (plugins.get(DecodeQualification.INTENDED).size() == 1) {
                    entry = plugins.get(DecodeQualification.INTENDED).get(0);
                    fileFormatName = entry.plugin.getFormatNames()[0];
                } else if (plugins.get(DecodeQualification.INTENDED).size() == 0 && plugins.get(DecodeQualification.SUITABLE).size() == 1) {
                    entry = plugins.get(DecodeQualification.SUITABLE).get(0);
                    fileFormatName = entry.plugin.getFormatNames()[0];
                } else {
                    List<PluginEntry> intendedPlugIns = plugins.get(DecodeQualification.INTENDED);
                    List<PluginEntry> suitablePlugIns = plugins.get(DecodeQualification.SUITABLE);
                    Collections.sort(intendedPlugIns);
                    Collections.sort(suitablePlugIns);
                    fileFormatName = ProductOpener.getUserSelection(intendedPlugIns, suitablePlugIns);
                    if (fileFormatName == null) {
                        return null;
                    }
                }
            } else {
                fileFormatName = formatName == null && this.plugin != null ? this.plugin.getFormatNames()[0] : formatName;
            }
            ReadProductOperation operation = new ReadProductOperation(file, fileFormatName);
            operation.setProductSubsetDef(this.productSubsetDef);
            operation.setProductReaderPlugIn(this.plugin);
            RequestProcessor.Task task = rp.create((Runnable)operation);
            ProgressHandle handle = ProgressHandleFactory.createHandle((String)("Reading " + file.getName()));
            operation.attacheProgressHandle(handle);
            task.schedule(0);
        }
        return true;
    }

    static Map<DecodeQualification, List<PluginEntry>> getPluginsForFile(File file) {
        Iterator allReaderPlugIns = ProductIOPlugInManager.getInstance().getAllReaderPlugIns();
        HashMap<DecodeQualification, List<PluginEntry>> possiblePlugIns = new HashMap<DecodeQualification, List<PluginEntry>>();
        possiblePlugIns.put(DecodeQualification.INTENDED, new ArrayList());
        possiblePlugIns.put(DecodeQualification.SUITABLE, new ArrayList());
        allReaderPlugIns.forEachRemaining(plugIn -> {
            DecodeQualification qualification = plugIn.getDecodeQualification((Object)file);
            if (qualification != DecodeQualification.UNABLE) {
                ((List)possiblePlugIns.get(qualification)).add(new PluginEntry((ProductReaderPlugIn)plugIn, qualification));
            }
        });
        return possiblePlugIns;
    }

    static String getUserSelection(List<PluginEntry> intendedPlugins, List<PluginEntry> suitablePlugIns) {
        PluginEntry leadPlugin = !intendedPlugins.isEmpty() ? intendedPlugins.get(0) : suitablePlugIns.get(0);
        boolean dontShowDialog = SnapApp.getDefault().getPreferences().getBoolean(PREFERENCES_KEY_DONT_SHOW_DIALOG, false);
        String prefKeyFormat = PREFERENCES_KEY_PREFIX_ALTERNATIVE_READER + leadPlugin.plugin.getClass().getSimpleName();
        String storedSelection = SnapApp.getDefault().getPreferences().get(prefKeyFormat, null);
        if (dontShowDialog && storedSelection != null) {
            return storedSelection;
        }
        TableLayout layout = new TableLayout(1);
        layout.setTableAnchor(TableLayout.Anchor.WEST);
        layout.setTableFill(TableLayout.Fill.HORIZONTAL);
        layout.setTablePadding(4, 4);
        JPanel readerSelectionPanel = new JPanel((LayoutManager)layout);
        readerSelectionPanel.add(new JLabel("<html>Multiple readers are available for the selected file.<br>The readers might interpret the data differently.<br>Please select one of the following:"));
        JComboBox<Object> pluginsCombobox = new JComboBox<Object>();
        DefaultListCellRenderer cellRenderer = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                this.setText(((ProductReaderPlugIn)value).getDescription(Locale.getDefault()));
                return this;
            }
        };
        pluginsCombobox.setRenderer(cellRenderer);
        for (PluginEntry plugin : intendedPlugins) {
            pluginsCombobox.addItem(plugin.plugin);
        }
        for (PluginEntry plugin : suitablePlugIns) {
            pluginsCombobox.addItem(plugin.plugin);
        }
        readerSelectionPanel.add(pluginsCombobox);
        JCheckBox decisionCheckBox = new JCheckBox("Remember my decision and don't ask again.", false);
        decisionCheckBox.setHorizontalAlignment(4);
        readerSelectionPanel.add(decisionCheckBox);
        NotifyDescriptor d = new NotifyDescriptor((Object)readerSelectionPanel, Dialogs.getDialogTitle("Multiple Readers Available"), 2, 3, null, NotifyDescriptor.OK_OPTION);
        Object answer = DialogDisplayer.getDefault().notify(d);
        if (NotifyDescriptor.OK_OPTION.equals(answer)) {
            boolean storeResult = decisionCheckBox.isSelected();
            String selectedFormatName = ((ProductReaderPlugIn)pluginsCombobox.getSelectedItem()).getFormatNames()[0];
            if (storeResult) {
                SnapApp.getDefault().getPreferences().put(prefKeyFormat, selectedFormatName);
                SnapApp.getDefault().getPreferences().put(PREFERENCES_KEY_DONT_SHOW_DIALOG, "true");
            }
            return selectedFormatName;
        }
        return null;
    }

    static class PluginEntry
    implements Comparable<PluginEntry> {
        ProductReaderPlugIn plugin;
        DecodeQualification qualification;

        public PluginEntry(ProductReaderPlugIn plugin, DecodeQualification qualification) {
            this.plugin = plugin;
            this.qualification = qualification;
        }

        @Override
        public int compareTo(PluginEntry other) {
            int qualificationComparison = this.qualification.compareTo((Enum)other.qualification);
            if (qualificationComparison == 0) {
                String description1 = this.plugin.getDescription(Locale.getDefault());
                String description2 = other.plugin.getDescription(Locale.getDefault());
                return description1.compareTo(description2);
            }
            return qualificationComparison;
        }
    }
}

