/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.file;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.math3.util.Pair;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.metadata.MetadataInspector;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.file.Bundle;
import org.esa.snap.rcp.actions.file.ProductAdvancedDialog;
import org.esa.snap.rcp.actions.file.ProductOpener;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.GridBagUtils;
import org.esa.snap.ui.SnapFileChooser;
import org.esa.snap.ui.product.ProductSubsetDialog;

public class ProductFileChooser
extends SnapFileChooser {
    private static final Logger logger = Logger.getLogger(ProductFileChooser.class.getName());
    private static int numSubsetProducts = 0;
    private JButton subsetButton;
    private JButton advancedButton;
    private Product subsetProduct;
    private transient ProductSubsetDef productSubsetDef;
    private ProductReaderPlugIn plugin;
    private JLabel sizeLabel;
    private boolean useSubset;
    private boolean useAdvanced;
    private Product productToExport;

    public ProductFileChooser(File currentDirectory) {
        super(currentDirectory);
        this.setDialogType(0);
    }

    public void setProductToExport(Product product) {
        this.productToExport = product;
        if (this.productToExport != null) {
            String fileName = this.productToExport.getName();
            if (StringUtils.isNullOrEmpty((String)fileName) && this.productToExport.getFileLocation() != null) {
                fileName = this.productToExport.getFileLocation().getName();
            }
            this.setCurrentFilename(fileName);
        }
    }

    public Product getSubsetProduct() {
        return this.subsetProduct;
    }

    public boolean isSubsetEnabled() {
        return this.useSubset;
    }

    public void setSubsetEnabled(boolean useSubset) {
        this.useSubset = useSubset;
    }

    public boolean isAdvancedEnabled() {
        return this.useAdvanced;
    }

    public void setAdvancedEnabled(boolean useAdvanced) {
        this.useAdvanced = useAdvanced;
    }

    public int showDialog(Component parent, String approveButtonText) {
        this.initUI();
        this.clearCurrentSubsetProduct();
        this.clearCurrentAdvancedProductOptions();
        this.updateState();
        return super.showDialog(parent, approveButtonText);
    }

    private void initUI() {
        if (this.getDialogType() == 0) {
            this.setDialogTitle(SnapApp.getDefault().getInstanceName() + " - Open Product");
            if (this.isSubsetEnabled()) {
                this.setDialogTitle(SnapApp.getDefault().getInstanceName() + " - Import Product");
                this.setApproveButtonText("Import Product");
                this.setApproveButtonMnemonic('I');
                this.setApproveButtonToolTipText("Imports the product.");
            }
        } else {
            this.setDialogTitle(SnapApp.getDefault().getInstanceName() + " - Save Product");
            if (this.isSubsetEnabled()) {
                this.setDialogTitle(SnapApp.getDefault().getInstanceName() + " - Export Product");
                this.setApproveButtonText("Export Product");
                this.setApproveButtonMnemonic('E');
                this.setApproveButtonToolTipText("Exports the product.");
            }
        }
        if (this.isSubsetEnabled()) {
            this.addSubsetAcessory();
        } else if (this.isAdvancedEnabled()) {
            this.addAdvancedAcessory();
        }
    }

    private void addSubsetAcessory() {
        this.subsetButton = new JButton("Subset...");
        this.subsetButton.setMnemonic('S');
        this.subsetButton.addActionListener(e -> this.openProductSubsetDialog());
        this.subsetButton.setEnabled(this.getSelectedFile() != null || this.productToExport != null);
        this.sizeLabel = new JLabel("0 M");
        this.sizeLabel.setHorizontalAlignment(4);
        JPanel panel = GridBagUtils.createPanel();
        GridBagConstraints gbc = GridBagUtils.createConstraints((String)"fill=HORIZONTAL,weightx=1,anchor=NORTHWEST,insets.left=7,insets.right=7,insets.bottom=4");
        GridBagUtils.addToPanel((JPanel)panel, (Component)this.subsetButton, (GridBagConstraints)gbc, (String)"gridy=0");
        GridBagUtils.addToPanel((JPanel)panel, (Component)this.sizeLabel, (GridBagConstraints)gbc, (String)"gridy=1");
        GridBagUtils.addVerticalFiller((JPanel)panel, (GridBagConstraints)gbc);
        this.setAccessory(panel);
        this.addPropertyChangeListener(e -> this.updateState());
    }

    private void addAdvancedAcessory() {
        this.advancedButton = new JButton("Advanced");
        this.advancedButton.setMnemonic('A');
        this.advancedButton.addActionListener(e -> this.openAdvancedDialog());
        this.advancedButton.setEnabled(this.getSelectedFile() != null);
        JPanel panel = GridBagUtils.createPanel();
        GridBagConstraints gbc = GridBagUtils.createConstraints((String)"fill=HORIZONTAL,weightx=1,anchor=NORTHWEST,insets.left=7,insets.right=7,insets.bottom=4");
        GridBagUtils.addToPanel((JPanel)panel, (Component)this.advancedButton, (GridBagConstraints)gbc, (String)"gridy=0");
        GridBagUtils.addVerticalFiller((JPanel)panel, (GridBagConstraints)gbc);
        this.setAccessory(panel);
        this.addPropertyChangeListener(e -> this.updateState());
    }

    private void updateState() {
        if (this.isSubsetEnabled()) {
            this.subsetButton.setEnabled(this.getSelectedFile() != null || this.productToExport != null);
            File file = this.getSelectedFile();
            if (file != null && file.isFile()) {
                long fileSize = Math.round((double)file.length() / 1048576.0);
                if (fileSize >= 1L) {
                    this.sizeLabel.setText("File size: " + fileSize + " M");
                } else {
                    this.sizeLabel.setText("File size: < 1 M");
                }
            } else {
                this.sizeLabel.setText("");
            }
        } else if (this.isAdvancedEnabled()) {
            this.advancedButton.setEnabled(this.getSelectedFile() != null);
        }
    }

    private void clearCurrentSubsetProduct() {
        this.subsetProduct = null;
    }

    private void clearCurrentAdvancedProductOptions() {
        this.productSubsetDef = null;
        this.plugin = null;
    }

    public ProductSubsetDef getProductSubsetDef() {
        return this.productSubsetDef;
    }

    public ProductReaderPlugIn getProductReaderPlugin() {
        return this.plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openProductSubsetDialog() {
        boolean approve;
        Product product = null;
        String newProductName = null;
        if (this.getDialogType() == 0) {
            File file = this.getSelectedFile();
            if (file == null) {
                return;
            }
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                FileFilter fileFilter = this.getFileFilter();
                String formatName = fileFilter instanceof SnapFileFilter ? ((SnapFileFilter)fileFilter).getFormatName() : null;
                product = ProductIO.readProduct((File)file, (String[])new String[]{formatName});
                if (product == null) {
                    String msg = "The product could not be read.";
                    String optionalMsg = file.isDirectory() ? "\nSelection points to a directory." : "";
                    Dialogs.showError(msg + optionalMsg);
                    return;
                }
                newProductName = this.createNewProductName(product.getName(), numSubsetProducts++);
            }
            catch (IOException e) {
                Dialogs.showError("The product could not be read:\n" + e.getMessage());
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        } else {
            product = this.productToExport;
            newProductName = StringUtils.isNotNullAndNotEmpty((String)this.getCurrentFilename()) ? this.getCurrentFilename() : this.createNewProductName(product.getName(), numSubsetProducts++);
        }
        if (product != null && (approve = this.openProductSubsetDialog(product, newProductName)) && this.getDialogType() == 0) {
            this.approveSelection();
        }
        this.updateState();
    }

    private boolean openProductSubsetDialog(Product product, String newProductName) {
        this.clearCurrentSubsetProduct();
        if (product != null) {
            if (product.isMultiSize()) {
                Dialogs.showError("No subset can be created of a multi-size products.");
                return false;
            }
            ProductSubsetDialog productSubsetDialog = new ProductSubsetDialog((Window)SnapApp.getDefault().getMainFrame(), product);
            if (productSubsetDialog.show() == 1) {
                try {
                    this.subsetProduct = product.createSubset(productSubsetDialog.getProductSubsetDef(), newProductName, null);
                    if (this.getCurrentFilename() != null && !this.getCurrentFilename().startsWith("subset_")) {
                        this.setCurrentFilename("subset_" + this.getCurrentFilename());
                    }
                    return true;
                }
                catch (IOException e) {
                    Dialogs.showError("Could not create subset:\n" + e.getMessage());
                }
            }
        }
        return false;
    }

    private void openAdvancedDialog() {
        this.clearCurrentAdvancedProductOptions();
        File inputFile = this.getSelectedFile();
        boolean canceled = false;
        Pair<ProductReaderPlugIn, Boolean> foundPlugin = this.findPlugins(inputFile);
        if (foundPlugin != null) {
            if (foundPlugin.getKey() == null) {
                canceled = (Boolean)foundPlugin.getValue();
            } else {
                this.plugin = (ProductReaderPlugIn)foundPlugin.getKey();
            }
        }
        boolean addUIComponents = true;
        MetadataInspector metadataInspector = null;
        if (this.plugin != null) {
            metadataInspector = this.plugin.getMetadataInspector();
        } else {
            addUIComponents = false;
        }
        if (addUIComponents && metadataInspector == null) {
            int confirm = JOptionPane.showConfirmDialog(null, "The reader does not support the advanced options!\nDo you want to open the product normally?", null, 0);
            if (confirm == 0) {
                addUIComponents = false;
                this.approveSelection();
            } else {
                addUIComponents = false;
            }
        }
        if (addUIComponents) {
            boolean approve = this.openAdvancedProduct(metadataInspector, inputFile);
            if (approve && this.getDialogType() == 0) {
                this.approveSelection();
            }
            this.updateState();
        } else if (this.plugin == null && !canceled) {
            Dialogs.showError(Bundle.LBL_NoReaderFoundText() + String.format("%nFile '%s' can not be opened.", inputFile));
        }
    }

    private boolean openAdvancedProduct(MetadataInspector metadataInspector, File file) {
        try {
            ProductAdvancedDialog advancedDialog = new ProductAdvancedDialog(SnapApp.getDefault().getMainFrame(), "Advanced Options", metadataInspector, file);
            advancedDialog.show();
            this.productSubsetDef = advancedDialog.getProductSubsetDef();
            if (this.productSubsetDef != null) {
                return true;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to open the advanced option dialog.", e);
            Dialogs.showError("The file " + this.getSelectedFile() + " could not be opened with advanced options!");
        }
        return false;
    }

    private String createNewProductName(String sourceProductName, int productIndex) {
        String newNameBase = "";
        if (sourceProductName != null && sourceProductName.length() > 0) {
            newNameBase = FileUtils.exchangeExtension((String)sourceProductName, (String)"");
        }
        String newNamePrefix = "subset";
        String newProductName = newNameBase.length() > 0 ? newNamePrefix + "_" + productIndex + "_" + newNameBase : newNamePrefix + "_" + productIndex;
        return newProductName;
    }

    public static Path convertInputToPath(Object input) {
        if (input == null) {
            throw new NullPointerException();
        }
        if (input instanceof File) {
            return ((File)input).toPath();
        }
        if (input instanceof Path) {
            return (Path)input;
        }
        if (input instanceof String) {
            return Paths.get((String)input, new String[0]);
        }
        throw new IllegalArgumentException("Unknown input '" + input + "'.");
    }

    private Pair<ProductReaderPlugIn, Boolean> findPlugins(File file) {
        Pair result = null;
        Map<DecodeQualification, List<ProductOpener.PluginEntry>> plugins = ProductOpener.getPluginsForFile(file);
        List<ProductOpener.PluginEntry> intendedPlugIns = plugins.get(DecodeQualification.INTENDED);
        List<ProductOpener.PluginEntry> suitablePlugIns = plugins.get(DecodeQualification.SUITABLE);
        if (intendedPlugIns.size() == 1) {
            ProductOpener.PluginEntry entry2 = intendedPlugIns.get(0);
            result = new Pair((Object)entry2.plugin, null);
        } else if (intendedPlugIns.isEmpty() && suitablePlugIns.size() == 1) {
            ProductOpener.PluginEntry entry3 = suitablePlugIns.get(0);
            result = new Pair((Object)entry3.plugin, null);
        } else if (!intendedPlugIns.isEmpty() || !suitablePlugIns.isEmpty()) {
            Collections.sort(intendedPlugIns);
            Collections.sort(suitablePlugIns);
            String fileFormatName = ProductOpener.getUserSelection(intendedPlugIns, suitablePlugIns);
            if (fileFormatName == null) {
                result = new Pair(null, (Object)true);
            } else if (!suitablePlugIns.isEmpty() && suitablePlugIns.stream().anyMatch(entry -> entry.plugin.getFormatNames()[0].equals(fileFormatName))) {
                ProductOpener.PluginEntry entry4 = suitablePlugIns.stream().filter(entry1 -> entry1.plugin.getFormatNames()[0].equals(fileFormatName)).findAny().orElse(null);
                result = new Pair((Object)entry4.plugin, (Object)false);
            } else {
                ProductOpener.PluginEntry entry5 = intendedPlugIns.stream().filter(entry1 -> entry1.plugin.getFormatNames()[0].equals(fileFormatName)).findAny().orElse(null);
                result = new Pair((Object)entry5.plugin, (Object)false);
            }
        }
        return result;
    }
}

