/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.file;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.metadata.MetadataInspector;
import org.esa.snap.core.subset.AbstractSubsetRegion;
import org.esa.snap.core.subset.GeometrySubsetRegion;
import org.esa.snap.core.subset.PixelSubsetRegion;
import org.esa.snap.core.util.GeoUtils;
import org.esa.snap.core.util.math.MathUtils;
import org.esa.snap.rcp.actions.file.ReadProductInspectorTimerRunnable;
import org.esa.snap.ui.loading.AbstractModalDialog;
import org.esa.snap.ui.loading.LoadingIndicator;
import org.esa.snap.ui.loading.SwingUtils;
import org.locationtech.jts.geom.Geometry;

public class ProductAdvancedDialog
extends AbstractModalDialog {
    private static final int MIN_SCENE_VALUE = 0;
    private final JList bandList;
    private final JList maskList;
    private JCheckBox copyMetadata;
    private final JCheckBox copyMasks;
    private final JRadioButton pixelCoordRadio;
    private final JRadioButton geoCoordRadio;
    private final JPanel pixelPanel;
    private final JPanel geoPanel;
    private JScrollPane scrollPaneMask;
    private MetadataInspector.Metadata readerInspectorExposeParameters;
    private AtomicBoolean updatingUI = new AtomicBoolean(false);
    private int productWidth;
    private int productHeight;
    private JSpinner pixelCoordXSpinner;
    private JSpinner pixelCoordYSpinner;
    private JSpinner pixelCoordWidthSpinner;
    private JSpinner pixelCoordHeightSpinner;
    private JSpinner geoCoordWestLongSpinner;
    private JSpinner geoCoordEastLongSpinner;
    private JSpinner geoCoordNorthLatSpinner;
    private JSpinner geoCoordSouthLatSpinner;
    private MetadataInspector metadataInspector;
    private File file;
    private ProductSubsetDef productSubsetDef;

    public ProductAdvancedDialog(Window parent, String title, MetadataInspector metadataInspector, File file) {
        super(parent, title, true, null);
        this.metadataInspector = metadataInspector;
        this.file = file;
        this.bandList = new JList();
        this.maskList = new JList();
        this.copyMetadata = new JCheckBox("Copy Metadata", true);
        this.copyMasks = new JCheckBox("Copy Masks", true);
        this.pixelCoordRadio = new JRadioButton("Pixel Coordinates");
        this.geoCoordRadio = new JRadioButton("Geographic Coordinates");
        this.pixelPanel = new JPanel(new GridBagLayout());
        this.geoPanel = new JPanel(new GridBagLayout());
    }

    protected void onAboutToShow() {
        this.readProductMetadataAsync();
    }

    protected JPanel buildButtonsPanel(ActionListener cancelActionListener) {
        ActionListener okActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ProductAdvancedDialog.this.okButtonPressed();
            }
        };
        return this.buildButtonsPanel("Ok", okActionListener, "Cancel", cancelActionListener);
    }

    protected JPanel buildContentPanel(int gapBetweenColumns, int gapBetweenRows) {
        this.initPixelCoordUIComponents();
        this.initGeoCoordUIComponents();
        this.copyMasks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ProductAdvancedDialog.this.copyMasks.isSelected()) {
                    if (!ProductAdvancedDialog.this.scrollPaneMask.isVisible()) {
                        ProductAdvancedDialog.this.scrollPaneMask.setVisible(true);
                    }
                } else if (ProductAdvancedDialog.this.scrollPaneMask.isVisible()) {
                    ProductAdvancedDialog.this.maskList.clearSelection();
                    ProductAdvancedDialog.this.scrollPaneMask.setVisible(false);
                }
            }
        });
        this.scrollPaneMask = new JScrollPane(this.maskList);
        this.createPixelPanel(gapBetweenColumns, gapBetweenRows);
        this.createGeoCodingPanel(gapBetweenColumns, gapBetweenRows);
        this.pixelCoordRadio.setSelected(true);
        this.pixelCoordRadio.setActionCommand("pixelCoordRadio");
        this.geoCoordRadio.setActionCommand("geoCoordRadio");
        ButtonGroup group = new ButtonGroup();
        group.add(this.pixelCoordRadio);
        group.add(this.geoCoordRadio);
        this.pixelCoordRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductAdvancedDialog.this.pixelPanel.setVisible(true);
                ProductAdvancedDialog.this.geoPanel.setVisible(false);
            }
        });
        this.geoCoordRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductAdvancedDialog.this.pixelPanel.setVisible(false);
                ProductAdvancedDialog.this.geoPanel.setVisible(true);
            }
        });
        JPanel contentPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = SwingUtils.buildConstraints((int)0, (int)0, (int)0, (int)18, (int)1, (int)1, (int)0, (int)0);
        contentPanel.add((Component)new JLabel("Source Bands:"), gbc);
        gbc = SwingUtils.buildConstraints((int)1, (int)0, (int)1, (int)18, (int)1, (int)1, (int)0, (int)gapBetweenColumns);
        contentPanel.add((Component)new JScrollPane(this.bandList), gbc);
        gbc = SwingUtils.buildConstraints((int)0, (int)1, (int)0, (int)18, (int)1, (int)1, (int)gapBetweenRows, (int)0);
        contentPanel.add((Component)this.copyMetadata, gbc);
        gbc = SwingUtils.buildConstraints((int)0, (int)2, (int)0, (int)18, (int)1, (int)1, (int)gapBetweenRows, (int)0);
        contentPanel.add((Component)this.copyMasks, gbc);
        gbc = SwingUtils.buildConstraints((int)1, (int)2, (int)1, (int)18, (int)1, (int)1, (int)gapBetweenRows, (int)gapBetweenColumns);
        contentPanel.add((Component)this.scrollPaneMask, gbc);
        JPanel regionTypePanel = new JPanel(new GridLayout(1, 2));
        regionTypePanel.add(this.pixelCoordRadio);
        regionTypePanel.add(this.geoCoordRadio);
        gbc = SwingUtils.buildConstraints((int)0, (int)3, (int)2, (int)18, (int)2, (int)1, (int)gapBetweenRows, (int)0);
        contentPanel.add((Component)regionTypePanel, gbc);
        gbc = SwingUtils.buildConstraints((int)0, (int)4, (int)2, (int)18, (int)2, (int)1, (int)gapBetweenRows, (int)0);
        contentPanel.add((Component)this.pixelPanel, gbc);
        gbc = SwingUtils.buildConstraints((int)0, (int)5, (int)2, (int)18, (int)2, (int)1, (int)gapBetweenRows, (int)0);
        contentPanel.add((Component)this.geoPanel, gbc);
        this.geoPanel.setVisible(false);
        return contentPanel;
    }

    private void createPixelPanel(int gapBetweenColumns, int gapBetweenRows) {
        GridBagConstraints pixgbc = SwingUtils.buildConstraints((int)0, (int)0, (int)1, (int)10, (int)1, (int)1, (int)0, (int)0);
        this.pixelPanel.add((Component)new JLabel("SceneX:"), pixgbc);
        pixgbc = SwingUtils.buildConstraints((int)1, (int)0, (int)2, (int)10, (int)1, (int)1, (int)0, (int)gapBetweenColumns);
        this.pixelPanel.add((Component)this.pixelCoordXSpinner, pixgbc);
        pixgbc = SwingUtils.buildConstraints((int)0, (int)1, (int)2, (int)10, (int)1, (int)1, (int)gapBetweenRows, (int)0);
        this.pixelPanel.add((Component)new JLabel("SceneY:"), pixgbc);
        pixgbc = SwingUtils.buildConstraints((int)1, (int)1, (int)2, (int)10, (int)1, (int)1, (int)gapBetweenRows, (int)gapBetweenColumns);
        this.pixelPanel.add((Component)this.pixelCoordYSpinner, pixgbc);
        pixgbc = SwingUtils.buildConstraints((int)0, (int)2, (int)2, (int)10, (int)1, (int)1, (int)gapBetweenRows, (int)0);
        this.pixelPanel.add((Component)new JLabel("Scene width:"), pixgbc);
        pixgbc = SwingUtils.buildConstraints((int)1, (int)2, (int)2, (int)10, (int)1, (int)1, (int)gapBetweenRows, (int)gapBetweenColumns);
        this.pixelPanel.add((Component)this.pixelCoordWidthSpinner, pixgbc);
        pixgbc = SwingUtils.buildConstraints((int)0, (int)3, (int)2, (int)10, (int)1, (int)1, (int)gapBetweenRows, (int)0);
        this.pixelPanel.add((Component)new JLabel("Scene height:"), pixgbc);
        pixgbc = SwingUtils.buildConstraints((int)1, (int)3, (int)2, (int)10, (int)1, (int)1, (int)gapBetweenRows, (int)gapBetweenColumns);
        this.pixelPanel.add((Component)this.pixelCoordHeightSpinner, pixgbc);
    }

    private void createGeoCodingPanel(int gapBetweenColumns, int gapBetweenRows) {
        GridBagConstraints geobc = SwingUtils.buildConstraints((int)0, (int)0, (int)1, (int)10, (int)1, (int)1, (int)0, (int)0);
        this.geoPanel.add((Component)new JLabel("North latitude bound:"), geobc);
        geobc = SwingUtils.buildConstraints((int)1, (int)0, (int)2, (int)10, (int)1, (int)1, (int)0, (int)gapBetweenColumns);
        this.geoPanel.add((Component)this.geoCoordNorthLatSpinner, geobc);
        geobc = SwingUtils.buildConstraints((int)0, (int)1, (int)2, (int)10, (int)1, (int)1, (int)gapBetweenRows, (int)0);
        this.geoPanel.add((Component)new JLabel("West longitude bound:"), geobc);
        geobc = SwingUtils.buildConstraints((int)1, (int)1, (int)2, (int)10, (int)1, (int)1, (int)gapBetweenRows, (int)gapBetweenColumns);
        this.geoPanel.add((Component)this.geoCoordWestLongSpinner, geobc);
        geobc = SwingUtils.buildConstraints((int)0, (int)2, (int)2, (int)10, (int)1, (int)1, (int)gapBetweenRows, (int)0);
        this.geoPanel.add((Component)new JLabel("South latitude bound:"), geobc);
        geobc = SwingUtils.buildConstraints((int)1, (int)2, (int)2, (int)10, (int)1, (int)1, (int)gapBetweenRows, (int)gapBetweenColumns);
        this.geoPanel.add((Component)this.geoCoordSouthLatSpinner, geobc);
        geobc = SwingUtils.buildConstraints((int)0, (int)3, (int)2, (int)10, (int)1, (int)1, (int)gapBetweenRows, (int)0);
        this.geoPanel.add((Component)new JLabel("East longitude bound:"), geobc);
        geobc = SwingUtils.buildConstraints((int)1, (int)3, (int)2, (int)10, (int)1, (int)1, (int)gapBetweenRows, (int)gapBetweenColumns);
        this.geoPanel.add((Component)this.geoCoordEastLongSpinner, geobc);
    }

    private void initPixelCoordUIComponents() {
        this.pixelCoordXSpinner = new JSpinner(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 25));
        this.pixelCoordXSpinner.getModel().setValue(0);
        this.pixelCoordXSpinner.setToolTipText("Start X co-ordinate given in pixels");
        this.pixelCoordXSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                ProductAdvancedDialog.this.updateUIStatePixelCoordsChanged(event);
            }
        });
        this.pixelCoordYSpinner = new JSpinner(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 25));
        this.pixelCoordYSpinner.getModel().setValue(0);
        this.pixelCoordYSpinner.setToolTipText("Start Y co-ordinate given in pixels");
        this.pixelCoordYSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                ProductAdvancedDialog.this.updateUIStatePixelCoordsChanged(event);
            }
        });
        this.pixelCoordWidthSpinner = new JSpinner(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 25));
        this.pixelCoordWidthSpinner.getModel().setValue(Integer.MAX_VALUE);
        this.pixelCoordWidthSpinner.setToolTipText("Product width");
        this.pixelCoordWidthSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                ProductAdvancedDialog.this.updateUIStatePixelCoordsChanged(event);
            }
        });
        this.pixelCoordHeightSpinner = new JSpinner(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 25));
        this.pixelCoordHeightSpinner.getModel().setValue(Integer.MAX_VALUE);
        this.pixelCoordHeightSpinner.setToolTipText("Product height");
        this.pixelCoordHeightSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                ProductAdvancedDialog.this.updateUIStatePixelCoordsChanged(event);
            }
        });
    }

    private void initGeoCoordUIComponents() {
        this.geoCoordNorthLatSpinner = new JSpinner(new SpinnerNumberModel(0.0, -90.0, 90.0, 1.0));
        this.geoCoordNorthLatSpinner.getModel().setValue(90.0);
        this.geoCoordNorthLatSpinner.setToolTipText("North bound latitude (\u00b0)");
        this.geoCoordNorthLatSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                ProductAdvancedDialog.this.updateUIStateGeoCoordsChanged(event);
            }
        });
        this.geoCoordWestLongSpinner = new JSpinner(new SpinnerNumberModel(0.0, -180.0, 180.0, 1.0));
        this.geoCoordWestLongSpinner.getModel().setValue(-180.0);
        this.geoCoordWestLongSpinner.setToolTipText("West bound longitude (\u00b0)");
        this.geoCoordWestLongSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                ProductAdvancedDialog.this.updateUIStateGeoCoordsChanged(event);
            }
        });
        this.geoCoordSouthLatSpinner = new JSpinner(new SpinnerNumberModel(0.0, -90.0, 90.0, 1.0));
        this.geoCoordSouthLatSpinner.getModel().setValue(-90.0);
        this.geoCoordSouthLatSpinner.setToolTipText("South bound latitude (\u00b0)");
        this.geoCoordSouthLatSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                ProductAdvancedDialog.this.updateUIStateGeoCoordsChanged(event);
            }
        });
        this.geoCoordEastLongSpinner = new JSpinner(new SpinnerNumberModel(0.0, -180.0, 180.0, 1.0));
        this.geoCoordEastLongSpinner.getModel().setValue(180.0);
        this.geoCoordEastLongSpinner.setToolTipText("East bound longitude (\u00b0)");
        this.geoCoordEastLongSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                ProductAdvancedDialog.this.updateUIStateGeoCoordsChanged(event);
            }
        });
    }

    private void okButtonPressed() {
        this.createSubsetDef();
        this.getJDialog().dispose();
    }

    private void readProductMetadataAsync() {
        LoadingIndicator loadingIndicator = this.getLoadingIndicator();
        int threadId = this.getNewCurrentThreadId();
        ReadProductInspectorTimerRunnable runnable = new ReadProductInspectorTimerRunnable(loadingIndicator, threadId, this.metadataInspector, this.file.toPath()){

            protected void onSuccessfullyFinish(MetadataInspector.Metadata result) {
                ProductAdvancedDialog.this.onSuccessfullyLoadingProductMetadata(result);
            }

            protected void onFailed(Exception exception) {
                ProductAdvancedDialog.this.onFailedLoadingProductMetadata(exception);
            }
        };
        runnable.executeAsync();
    }

    private void onSuccessfullyLoadingProductMetadata(MetadataInspector.Metadata result) {
        this.readerInspectorExposeParameters = result;
        this.productWidth = result.getProductWidth();
        this.productHeight = result.getProductHeight();
        ((SpinnerNumberModel)this.pixelCoordXSpinner.getModel()).setMaximum(Integer.valueOf(result.getProductWidth() - 1 > 0 ? result.getProductWidth() - 1 : 0));
        ((SpinnerNumberModel)this.pixelCoordYSpinner.getModel()).setMaximum(Integer.valueOf(result.getProductHeight() - 1 > 0 ? result.getProductHeight() - 1 : 0));
        ((SpinnerNumberModel)this.pixelCoordWidthSpinner.getModel()).setMinimum((Integer)this.pixelCoordXSpinner.getValue());
        ((SpinnerNumberModel)this.pixelCoordWidthSpinner.getModel()).setMaximum(Integer.valueOf(result.getProductWidth()));
        this.pixelCoordWidthSpinner.setValue(result.getProductWidth());
        ((SpinnerNumberModel)this.pixelCoordHeightSpinner.getModel()).setMinimum((Integer)this.pixelCoordYSpinner.getValue());
        ((SpinnerNumberModel)this.pixelCoordHeightSpinner.getModel()).setMaximum(Integer.valueOf(result.getProductHeight()));
        this.pixelCoordHeightSpinner.setValue(result.getProductHeight());
        if (this.readerInspectorExposeParameters != null && this.readerInspectorExposeParameters.isHasGeoCoding()) {
            this.syncLatLonWithXYParams();
        } else {
            this.geoCoordRadio.setEnabled(false);
            this.geoPanel.setEnabled(false);
        }
        this.bandList.setListData(result.getBandList().toArray());
        this.maskList.setListData(result.getMaskList().toArray());
        if (!result.isHasMasks()) {
            this.copyMasks.setSelected(false);
            this.copyMasks.setEnabled(false);
            this.scrollPaneMask.setEnabled(false);
        }
    }

    private void onFailedLoadingProductMetadata(Exception exception) {
        this.showErrorDialog("Failed to load the product metadata", "Loading metadata");
        this.getJDialog().dispose();
    }

    private void updateUIStatePixelCoordsChanged(ChangeEvent event) {
        if (this.updatingUI.compareAndSet(false, true)) {
            try {
                if (event != null && this.pixelCoordRadio.isEnabled()) {
                    this.pixelPanelChanged();
                    this.syncLatLonWithXYParams();
                }
            }
            finally {
                this.updatingUI.set(false);
            }
        }
    }

    private void updateUIStateGeoCoordsChanged(ChangeEvent event) {
        if (this.updatingUI.compareAndSet(false, true)) {
            try {
                if (event != null && this.geoCoordRadio.isEnabled()) {
                    this.geoCodingChange();
                }
            }
            finally {
                this.updatingUI.set(false);
            }
        }
    }

    public void pixelPanelChanged() {
        int x1 = ((Number)this.pixelCoordXSpinner.getValue()).intValue();
        int y1 = ((Number)this.pixelCoordYSpinner.getValue()).intValue();
        int w = ((Number)this.pixelCoordWidthSpinner.getValue()).intValue();
        int h = ((Number)this.pixelCoordHeightSpinner.getValue()).intValue();
        if (x1 < 0) {
            x1 = 0;
        }
        if (x1 > this.productWidth - 2) {
            x1 = this.productWidth - 2;
        }
        if (y1 < 0) {
            y1 = 0;
        }
        if (y1 > this.productHeight - 2) {
            y1 = this.productHeight - 2;
        }
        if (this.readerInspectorExposeParameters != null) {
            if (w > this.productWidth) {
                w = this.productWidth;
            }
            if (x1 + w > this.productWidth) {
                w = w - x1 >= 2 ? (w -= x1) : this.productWidth - x1;
            }
        }
        if (this.readerInspectorExposeParameters != null) {
            if (h > this.productHeight) {
                h = this.productHeight;
            }
            if (y1 + h > this.productHeight) {
                h = h - y1 >= 2 ? (h -= y1) : this.productHeight - y1;
            }
        }
        this.pixelCoordXSpinner.setValue(0);
        this.pixelCoordYSpinner.setValue(0);
        this.pixelCoordWidthSpinner.setValue(w);
        this.pixelCoordHeightSpinner.setValue(h);
        this.pixelCoordXSpinner.setValue(x1);
        this.pixelCoordYSpinner.setValue(y1);
        this.pixelCoordWidthSpinner.setValue(w);
        this.pixelCoordHeightSpinner.setValue(h);
    }

    private void geoCodingChange() {
        GeoPos geoPos1 = new GeoPos(((Double)this.geoCoordNorthLatSpinner.getValue()).doubleValue(), ((Double)this.geoCoordWestLongSpinner.getValue()).doubleValue());
        GeoPos geoPos2 = new GeoPos(((Double)this.geoCoordSouthLatSpinner.getValue()).doubleValue(), ((Double)this.geoCoordEastLongSpinner.getValue()).doubleValue());
        this.updateXYParams(geoPos1, geoPos2);
    }

    private void updateXYParams(GeoPos geoPos1, GeoPos geoPos2) {
        if (this.readerInspectorExposeParameters != null && this.readerInspectorExposeParameters.getGeoCoding() != null) {
            PixelPos pixelPos2;
            GeoCoding geoCoding = this.readerInspectorExposeParameters.getGeoCoding();
            PixelPos pixelPos1 = geoCoding.getPixelPos(geoPos1, null);
            if (!pixelPos1.isValid()) {
                pixelPos1.setLocation(0.0, 0.0);
            }
            if (!(pixelPos2 = geoCoding.getPixelPos(geoPos2, null)).isValid()) {
                pixelPos2.setLocation((double)this.readerInspectorExposeParameters.getProductWidth(), (double)this.readerInspectorExposeParameters.getProductHeight());
            }
            Rectangle2D.Float region = new Rectangle2D.Float();
            region.setFrameFromDiagonal(pixelPos1.x, pixelPos1.y, pixelPos2.x, pixelPos2.y);
            Rectangle2D.Float productBounds = new Rectangle2D.Float(0.0f, 0.0f, this.readerInspectorExposeParameters.getProductWidth(), this.readerInspectorExposeParameters.getProductHeight());
            Rectangle2D finalRegion = productBounds.createIntersection(region);
            if (this.isValueInNumericSpinnerRange(this.pixelCoordXSpinner, (int)finalRegion.getMinX())) {
                this.pixelCoordXSpinner.setValue((int)finalRegion.getMinX());
            }
            if (this.isValueInNumericSpinnerRange(this.pixelCoordYSpinner, (int)finalRegion.getMinY())) {
                this.pixelCoordYSpinner.setValue((int)finalRegion.getMinY());
            }
            int width = (int)(finalRegion.getMaxX() - finalRegion.getMinX()) + 1;
            int height = (int)(finalRegion.getMaxY() - finalRegion.getMinY()) + 1;
            if (this.isValueInNumericSpinnerRange(this.pixelCoordWidthSpinner, width)) {
                this.pixelCoordWidthSpinner.setValue(width);
            }
            if (this.isValueInNumericSpinnerRange(this.pixelCoordHeightSpinner, height)) {
                this.pixelCoordHeightSpinner.setValue(height);
            }
        }
    }

    private void syncLatLonWithXYParams() {
        if (this.readerInspectorExposeParameters != null && this.readerInspectorExposeParameters.getGeoCoding() != null) {
            double lon;
            double lat;
            PixelPos pixelPos1 = new PixelPos((double)((Integer)this.pixelCoordXSpinner.getValue()).intValue(), (double)((Integer)this.pixelCoordYSpinner.getValue()).intValue());
            int paramX2 = (Integer)this.pixelCoordWidthSpinner.getValue() + (Integer)this.pixelCoordXSpinner.getValue() - 1;
            int paramY2 = (Integer)this.pixelCoordHeightSpinner.getValue() + (Integer)this.pixelCoordYSpinner.getValue() - 1;
            PixelPos pixelPos2 = new PixelPos((double)paramX2, (double)paramY2);
            GeoCoding geoCoding = this.readerInspectorExposeParameters.getGeoCoding();
            GeoPos geoPos1 = geoCoding.getGeoPos(pixelPos1, null);
            GeoPos geoPos2 = geoCoding.getGeoPos(pixelPos2, null);
            if (geoPos1.isValid()) {
                lat = geoPos1.getLat();
                lat = MathUtils.crop((double)lat, (double)-90.0, (double)90.0);
                this.geoCoordNorthLatSpinner.setValue(lat);
                lon = geoPos1.getLon();
                lon = MathUtils.crop((double)lon, (double)-180.0, (double)180.0);
                this.geoCoordWestLongSpinner.setValue(lon);
            }
            if (geoPos2.isValid()) {
                lat = geoPos2.getLat();
                lat = MathUtils.crop((double)lat, (double)-90.0, (double)90.0);
                this.geoCoordSouthLatSpinner.setValue(lat);
                lon = geoPos2.getLon();
                lon = MathUtils.crop((double)lon, (double)-180.0, (double)180.0);
                this.geoCoordEastLongSpinner.setValue(lon);
            }
        }
    }

    private boolean isValueInNumericSpinnerRange(JSpinner spinner, Integer value) {
        Integer min = (Integer)((SpinnerNumberModel)spinner.getModel()).getMinimum();
        Integer max = (Integer)((SpinnerNumberModel)spinner.getModel()).getMaximum();
        return value >= min && value <= max;
    }

    public static JLabel addComponent(JPanel contentPane, GridBagConstraints gbc, String text, JComponent component, int pos) {
        gbc.gridx = pos;
        gbc.weightx = 0.5;
        JLabel label = new JLabel(text);
        contentPane.add((Component)label, gbc);
        gbc.gridx = pos + 1;
        gbc.weightx = 2.0;
        contentPane.add((Component)component, gbc);
        gbc.gridx = pos;
        gbc.weightx = 1.0;
        return label;
    }

    private void createSubsetDef() {
        if (this.pixelPanel.isVisible()) {
            this.updateSubsetDefNodeNameList(false);
        } else if (this.geoPanel.isVisible() && this.geoCoordRadio.isEnabled()) {
            this.updateSubsetDefNodeNameList(true);
        }
    }

    private void updateSubsetDefNodeNameList(boolean geoRegion) {
        this.productSubsetDef = new ProductSubsetDef();
        if (!this.bandList.isSelectionEmpty()) {
            this.productSubsetDef.addNodeNames((String[])this.bandList.getSelectedValuesList().stream().toArray(String[]::new));
        } else if (this.readerInspectorExposeParameters != null && this.readerInspectorExposeParameters.getBandList() != null) {
            this.productSubsetDef.addNodeNames((String[])this.readerInspectorExposeParameters.getBandList().stream().toArray(String[]::new));
        }
        if (!this.maskList.isSelectionEmpty()) {
            this.productSubsetDef.addNodeNames((String[])this.maskList.getSelectedValuesList().stream().toArray(String[]::new));
        } else if (this.copyMasks.isSelected() && this.readerInspectorExposeParameters != null && this.readerInspectorExposeParameters.getMaskList() != null) {
            this.productSubsetDef.addNodeNames((String[])this.readerInspectorExposeParameters.getMaskList().stream().toArray(String[]::new));
        }
        if (!this.copyMetadata.isSelected()) {
            this.productSubsetDef.setIgnoreMetadata(true);
        }
        AbstractSubsetRegion subsetRegion = null;
        if (geoRegion) {
            subsetRegion = this.setGeometry();
        } else if (this.pixelCoordXSpinner.getValue() != null && this.pixelCoordYSpinner.getValue() != null && this.pixelCoordWidthSpinner.getValue() != null && this.pixelCoordHeightSpinner.getValue() != null) {
            subsetRegion = new PixelSubsetRegion(((Integer)this.pixelCoordXSpinner.getValue()).intValue(), ((Integer)this.pixelCoordYSpinner.getValue()).intValue(), ((Integer)this.pixelCoordWidthSpinner.getValue()).intValue(), ((Integer)this.pixelCoordHeightSpinner.getValue()).intValue(), 0);
        }
        this.productSubsetDef.setSubsetRegion(subsetRegion);
    }

    private AbstractSubsetRegion setGeometry() {
        if (this.readerInspectorExposeParameters != null && this.readerInspectorExposeParameters.isHasGeoCoding()) {
            GeoPos geoPos1 = new GeoPos(((Double)this.geoCoordNorthLatSpinner.getValue()).doubleValue(), ((Double)this.geoCoordWestLongSpinner.getValue()).doubleValue());
            GeoPos geoPos2 = new GeoPos(((Double)this.geoCoordSouthLatSpinner.getValue()).doubleValue(), ((Double)this.geoCoordEastLongSpinner.getValue()).doubleValue());
            GeoCoding geoCoding = this.readerInspectorExposeParameters.getGeoCoding();
            PixelPos pixelPos1 = geoCoding.getPixelPos(geoPos1, null);
            PixelPos pixelPos2 = geoCoding.getPixelPos(geoPos2, null);
            Rectangle2D.Float region = new Rectangle2D.Float();
            region.setFrameFromDiagonal(pixelPos1.x, pixelPos1.y, pixelPos2.x, pixelPos2.y);
            Rectangle2D.Float productBounds = new Rectangle2D.Float(0.0f, 0.0f, this.productWidth, this.productHeight);
            Rectangle2D finalRegion = productBounds.createIntersection(region);
            Rectangle bounds = new Rectangle((int)finalRegion.getMinX(), (int)finalRegion.getMinY(), (int)(finalRegion.getMaxX() - finalRegion.getMinX()) + 1, (int)(finalRegion.getMaxY() - finalRegion.getMinY()) + 1);
            Geometry geometry = GeoUtils.computeGeometryUsingPixelRegion((GeoCoding)geoCoding, (Rectangle)bounds);
            return new GeometrySubsetRegion(geometry, 0);
        }
        return null;
    }

    public ProductSubsetDef getProductSubsetDef() {
        return this.productSubsetDef;
    }
}

