/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.file;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.file.ProductOpener;
import org.esa.snap.rcp.actions.file.RecentPaths;

public final class OpenProductAction
extends AbstractAction {
    public static final String PREFERENCES_KEY_RECENTLY_OPENED_PRODUCTS = "recently_opened_products";
    public static final String PREFERENCES_KEY_LAST_PRODUCT_DIR = "last_product_open_dir";

    static RecentPaths getRecentProductPaths() {
        return new RecentPaths(SnapApp.getDefault().getPreferences(), PREFERENCES_KEY_RECENTLY_OPENED_PRODUCTS, true);
    }

    static List<File> getOpenedProductFiles() {
        return Arrays.stream(SnapApp.getDefault().getProductManager().getProducts()).map(Product::getFileLocation).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public File[] getFiles() {
        Object value = this.getValue("files");
        if (value instanceof File[]) {
            return (File[])value;
        }
        return null;
    }

    public void setFile(File file) {
        this.setFiles(file);
    }

    public void setFiles(File ... files) {
        this.putValue("files", files);
    }

    public String getFileFormat() {
        Object value = this.getValue("fileFormat");
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public void setFileFormat(String fileFormat) {
        this.putValue("fileFormat", fileFormat);
    }

    public void setUseAllFileFilter(boolean useAllFileFilter) {
        this.putValue("useAllFileFilter", useAllFileFilter);
    }

    public boolean getUseAllFileFilter() {
        return this.getBooleanProperty("useAllFileFilter", true);
    }

    private boolean getBooleanProperty(String propertyName, Boolean defaultValue) {
        Object propValue = this.getValue(propertyName);
        if (propValue == null) {
            return defaultValue;
        }
        return Boolean.TRUE.equals(propValue);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.execute();
    }

    public Boolean execute() {
        ProductOpener opener = new ProductOpener();
        opener.setFiles(this.getFiles());
        opener.setFileFormat(this.getFileFormat());
        opener.setUseAllFileFilter(this.getUseAllFileFilter());
        opener.setMultiSelectionEnabled(true);
        opener.setSubsetImportEnabled(false);
        return opener.openProduct();
    }
}

