/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.file;

import java.awt.event.ActionEvent;
import java.io.File;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.filechooser.FileFilter;
import org.esa.snap.core.dataio.EncodeQualification;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.dataio.ProductIOPlugInManager;
import org.esa.snap.core.dataio.ProductWriter;
import org.esa.snap.core.dataio.ProductWriterPlugIn;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.file.ProductFileChooser;
import org.esa.snap.rcp.actions.file.WriteProductOperation;
import org.esa.snap.rcp.util.Dialogs;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public class ExportProductAction
extends AbstractAction
implements HelpCtx.Provider,
ContextAwareAction {
    private static final String PROPERTY_FORMAT_NAME = "formatName";
    private static final String PROPERTY_HELP_CTX = "helpCtx";
    private static final String PROPERTY_USE_ALL_FILE_FILTER = "useAllFileFilter";
    private WeakReference<Product> productRef;

    public static ExportProductAction create(Map<String, Object> configuration) {
        ExportProductAction exportProductAction = new ExportProductAction();
        exportProductAction.setFormatName((String)configuration.get(PROPERTY_FORMAT_NAME));
        exportProductAction.setHelpCtx((String)configuration.get("helpId"));
        exportProductAction.setUseAllFileFilter((Boolean)configuration.get(PROPERTY_USE_ALL_FILE_FILTER));
        return exportProductAction;
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        ProductNode productNode = (ProductNode)actionContext.lookup(ProductNode.class);
        this.setProduct(productNode.getProduct());
        return this;
    }

    public HelpCtx getHelpCtx() {
        return (HelpCtx)this.getValue(PROPERTY_HELP_CTX);
    }

    public void setHelpCtx(String helpId) {
        this.putValue(PROPERTY_HELP_CTX, helpId != null ? new HelpCtx(helpId) : null);
    }

    public String getDisplayName() {
        return (String)this.getValue("displayName");
    }

    public void setFormatName(String formatName) {
        this.putValue(PROPERTY_FORMAT_NAME, formatName);
    }

    public void setUseAllFileFilter(Boolean useAllFileFilter) {
        this.putValue(PROPERTY_USE_ALL_FILE_FILTER, useAllFileFilter);
    }

    public void setProduct(Product p) {
        this.productRef = new WeakReference<Product>(p);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.execute();
    }

    public Boolean execute() {
        Product product = (Product)this.productRef.get();
        if (product != null) {
            return this.exportProduct(product, (String)this.getValue(PROPERTY_FORMAT_NAME));
        }
        return true;
    }

    private Boolean exportProduct(Product product, String formatName) {
        ProductWriter productWriter = ProductIO.getProductWriter((String)formatName);
        if (productWriter == null) {
            Dialogs.showError(this.getDisplayName(), MessageFormat.format("No writer found for format {0}.", formatName));
            return null;
        }
        EncodeQualification encodeQualification = productWriter.getWriterPlugIn().getEncodeQualification(product);
        if (encodeQualification.getPreservation() == EncodeQualification.Preservation.UNABLE) {
            Dialogs.showError(this.getDisplayName(), MessageFormat.format("Writing this product as {0} is not possible:\n" + encodeQualification.getInfoString(), formatName));
            return null;
        }
        Preferences preferences = SnapApp.getDefault().getPreferences();
        ProductFileChooser fc = new ProductFileChooser(new File(preferences.get("last_product_open_dir", ".")));
        fc.setDialogType(1);
        fc.setSubsetEnabled(true);
        fc.setAdvancedEnabled(false);
        fc.addChoosableFileFilter(this.getFileFilter(formatName));
        fc.setProductToExport(product);
        int returnVal = fc.showSaveDialog(SnapApp.getDefault().getMainFrame());
        if (returnVal != 0) {
            return null;
        }
        File newFile = fc.getSelectedFile();
        if (newFile == null) {
            return null;
        }
        if (newFile.isFile() && !newFile.canWrite()) {
            Dialogs.showWarning(this.getDisplayName(), MessageFormat.format("The product\n''{0}''\nexists and cannot be overwritten, because it is read only.\nPlease choose another file or remove the write protection.", newFile.getPath()), null);
            return false;
        }
        Product exportProduct = fc.getSubsetProduct() != null ? fc.getSubsetProduct() : product;
        SnapApp.getDefault().setStatusBarMessage(MessageFormat.format("Exporting product ''{0}'' to {1}...", exportProduct.getDisplayName(), newFile));
        WriteProductOperation operation = new WriteProductOperation(exportProduct, newFile, formatName, false);
        BaseProgressUtils.runOffEventThreadWithProgressDialog((Runnable)operation, (String)this.getDisplayName(), (ProgressHandle)operation.getProgressHandle(), (boolean)true, (int)50, (int)1000);
        SnapApp.getDefault().setStatusBarMessage("");
        return operation.getStatus();
    }

    private FileFilter getFileFilter(String formatName) {
        Iterator writerPlugIns = ProductIOPlugInManager.getInstance().getWriterPlugIns(formatName);
        if (writerPlugIns.hasNext()) {
            return ((ProductWriterPlugIn)writerPlugIns.next()).getProductFileFilter();
        }
        return null;
    }

    private String getFileExtension(String formatName) {
        SnapFileFilter fileFilter;
        Iterator writerPlugIns = ProductIOPlugInManager.getInstance().getWriterPlugIns(formatName);
        String fileExtension = null;
        if (writerPlugIns.hasNext() && (fileFilter = ((ProductWriterPlugIn)writerPlugIns.next()).getProductFileFilter()) != null) {
            fileExtension = fileFilter.getDefaultExtension();
        }
        return fileExtension;
    }
}

