/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.file;

import java.awt.event.ActionEvent;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.file.Bundle;
import org.esa.snap.rcp.actions.file.CloseProductAction;

public final class CloseAllProductsAction
extends AbstractAction {
    public CloseAllProductsAction() {
        super(Bundle.CTL_CloseAllProductsActionName());
        ProductManager productManager = SnapApp.getDefault().getProductManager();
        productManager.addListener((ProductManager.Listener)new CloseAllProductListener());
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.execute();
    }

    public Boolean execute() {
        Set<Product> collect = Stream.of(SnapApp.getDefault().getProductManager().getProducts()).collect(Collectors.toSet());
        return CloseProductAction.closeProducts(collect);
    }

    private class CloseAllProductListener
    implements ProductManager.Listener {
        private CloseAllProductListener() {
        }

        public void productAdded(ProductManager.Event event) {
            this.updateEnableState();
        }

        public void productRemoved(ProductManager.Event event) {
            this.updateEnableState();
        }

        private void updateEnableState() {
            CloseAllProductsAction.this.setEnabled(SnapApp.getDefault().getProductManager().getProductCount() > 0);
        }
    }
}

