/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.about;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.esa.snap.core.gpf.OperatorException;

public class ThirdPartyLicensesCsvTable {
    private List<String> name;
    private List<String> descrUse;
    private List<String> iprOwner;
    private List<String> iprOwnerUrl;
    private List<String> license;
    private List<String> licenseUrl;
    private BufferedReader bufferedReader;

    ThirdPartyLicensesCsvTable(Reader licensesReader) {
        this.bufferedReader = new BufferedReader(licensesReader);
        this.loadTable();
    }

    private void loadTable() {
        this.name = new ArrayList<String>();
        this.descrUse = new ArrayList<String>();
        this.iprOwner = new ArrayList<String>();
        this.license = new ArrayList<String>();
        this.iprOwnerUrl = new ArrayList<String>();
        this.licenseUrl = new ArrayList<String>();
        this.readTable();
    }

    private void readTable() {
        try {
            String line;
            int i = 0;
            this.bufferedReader.readLine();
            while ((line = this.bufferedReader.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line = line.trim(), ";", false);
                if (st.hasMoreTokens()) {
                    this.setName(i, st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    this.setDescrUse(i, st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    this.setIprOwner(i, st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    this.setLicense(i, st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    this.setIprOwnerUrl(i, st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    this.setLicenseUrl(i, st.nextToken());
                }
                ++i;
            }
        }
        catch (IOException | NumberFormatException e) {
            throw new OperatorException("Failed to load 3rd-party license table: \n" + e.getMessage(), (Throwable)e);
        }
    }

    public List<String> getName() {
        return this.name;
    }

    private void setName(int index, String name) {
        this.name.add(index, name);
    }

    public String getName(int index) {
        return this.name.get(index);
    }

    private void setDescrUse(int index, String descrUse) {
        this.descrUse.add(index, descrUse);
    }

    String getDescrUse(int index) {
        return this.descrUse.get(index);
    }

    private void setIprOwner(int index, String iprOwner) {
        this.iprOwner.add(index, iprOwner);
    }

    String getIprOwner(int index) {
        return this.iprOwner.get(index);
    }

    private void setLicense(int index, String license) {
        this.license.add(index, license);
    }

    String getLicense(int index) {
        return this.license.get(index);
    }

    private void setIprOwnerUrl(int index, String iprOwnerUrl) {
        this.iprOwnerUrl.add(index, iprOwnerUrl);
    }

    String getIprOwnerUrl(int index) {
        return this.iprOwnerUrl.get(index);
    }

    private void setLicenseUrl(int index, String licenseUrl) {
        this.licenseUrl.add(index, licenseUrl);
    }

    String getLicenseUrl(int index) {
        return this.licenseUrl.get(index);
    }
}

