/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.about;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.border.EmptyBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.rcp.about.ThirdPartyLicense;
import org.esa.snap.rcp.about.ThirdPartyLicensesCsvTable;
import org.esa.snap.rcp.about.ThirdPartyLicensesTableModel;

class LicensesAboutBox
extends JPanel {
    private static final String THIRD_PARTY_LICENSE_DEFAULT_FILE_NAME = "THIRDPARTY_LICENSES.txt";
    private ThirdPartyLicense[] licenses;

    LicensesAboutBox() {
        super(new BorderLayout(4, 4));
        this.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.createLicensesPanel();
    }

    private void createLicensesPanel() {
        JComponent licensesComponent;
        JLabel infoText = new JLabel("<html><b>The table below gives an overview of all 3rd-party licenses used by SNAP and the ESA Toolboxes.<br>The dependencies of other plugins are not considered in this list.</b>");
        Path licensesFile = SystemUtils.getApplicationHomeDir().toPath().resolve(THIRD_PARTY_LICENSE_DEFAULT_FILE_NAME);
        try {
            JTable table = this.createLicensesTable(licensesFile);
            licensesComponent = this.createScrollPane(table);
        }
        catch (IOException e) {
            String msg = "Error: Cloud not read licenses from " + licensesFile.toAbsolutePath().toString();
            SystemUtils.LOG.log(Level.WARNING, msg, e);
            JLabel msgLabel = new JLabel(msg);
            msgLabel.setVerticalAlignment(1);
            licensesComponent = msgLabel;
        }
        this.add((Component)infoText, "North");
        this.add((Component)licensesComponent, "Center");
        this.setVisible(true);
    }

    private JScrollPane createScrollPane(JTable table) {
        JScrollPane scrollPane = new JScrollPane(table, 20, 30);
        Dimension d = table.getPreferredSize();
        scrollPane.setPreferredSize(new Dimension(d.width, table.getRowHeight() * 10));
        return scrollPane;
    }

    private JTable createLicensesTable(Path licensesFile) throws IOException {
        this.licenses = this.getThirdPartyLicensesFromCsvTable(licensesFile);
        final ThirdPartyLicensesTableModel licensesTableModel = new ThirdPartyLicensesTableModel(this.licenses);
        final JTable licensesTable = new JTable(licensesTableModel);
        JTableHeader tableHeader = licensesTable.getTableHeader();
        int fontSize = tableHeader.getFont().getSize();
        tableHeader.setFont(new Font(null, 1, fontSize));
        tableHeader.setOpaque(false);
        tableHeader.setBackground(Color.lightGray);
        for (int i = 0; i < licensesTable.getColumnCount(); ++i) {
            licensesTable.getColumnModel().getColumn(i).setCellRenderer(new LineWrapCellRenderer());
        }
        TableColumnModel tableColumnModel = licensesTable.getColumnModel();
        TableColumn nameColumn = tableColumnModel.getColumn(0);
        TableColumn descrUseColumn = tableColumnModel.getColumn(1);
        TableColumn iprOwnerColumn = tableColumnModel.getColumn(2);
        TableColumn licenseColumn = tableColumnModel.getColumn(3);
        nameColumn.setMinWidth(10);
        nameColumn.setPreferredWidth(150);
        descrUseColumn.setMinWidth(10);
        descrUseColumn.setPreferredWidth(160);
        iprOwnerColumn.setMinWidth(10);
        iprOwnerColumn.setPreferredWidth(110);
        licenseColumn.setMinWidth(10);
        licenseColumn.setPreferredWidth(110);
        licensesTable.setAutoCreateRowSorter(true);
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(licensesTable.getModel());
        licensesTable.setRowSorter(sorter);
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
        sorter.setSortKeys(sortKeys);
        sorter.setSortable(1, false);
        sorter.sort();
        MouseMotionListener motionListener = new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                String columnName;
                int column = licensesTable.columnAtPoint(e.getPoint());
                int row = licensesTable.rowAtPoint(e.getPoint());
                if (LicensesAboutBox.this.licenses[row].getUrlByTableColumnName(columnName = licensesTableModel.getColumnName(column)) != null) {
                    LicensesAboutBox.this.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    LicensesAboutBox.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        };
        licensesTable.addMouseMotionListener(motionListener);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String columnName;
                String urlString;
                int row = licensesTable.rowAtPoint(e.getPoint());
                int column = licensesTable.columnAtPoint(e.getPoint());
                if (licensesTableModel.containsURLs(column) && (urlString = LicensesAboutBox.this.licenses[row].getUrlByTableColumnName(columnName = licensesTableModel.getColumnName(column))) != null) {
                    try {
                        URI uri = new URI(urlString);
                        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                            try {
                                Desktop.getDesktop().browse(uri);
                            }
                            catch (Throwable e2) {
                                JOptionPane.showMessageDialog(licensesTable.getParent(), "Failed to open URL:\n" + uri + ":\n" + e2.getMessage(), "Error", 0);
                            }
                        } else {
                            JOptionPane.showMessageDialog(licensesTable.getParent(), "The desktop command 'browse' is not supported.", "Error", 0);
                        }
                    }
                    catch (URISyntaxException e1) {
                        JOptionPane.showMessageDialog(licensesTable.getParent(), "Cannot create URL from given String:\n" + urlString + ":\n" + e1.getMessage(), "Error", 0);
                    }
                }
            }
        };
        licensesTable.addMouseListener(mouseAdapter);
        licensesTable.setAutoResizeMode(2);
        return licensesTable;
    }

    private ThirdPartyLicense[] getThirdPartyLicensesFromCsvTable(Path licensesFile) throws IOException {
        try (BufferedReader licensesReader = Files.newBufferedReader(licensesFile);){
            ThirdPartyLicensesCsvTable licensesCsvTable = new ThirdPartyLicensesCsvTable(licensesReader);
            int numLicenses = licensesCsvTable.getName().size();
            ThirdPartyLicense[] thirdPartyLicenses = new ThirdPartyLicense[numLicenses];
            for (int i = 0; i < numLicenses; ++i) {
                if (licensesCsvTable.getName(i) == null) continue;
                String name = licensesCsvTable.getName(i);
                String descriptionUse = licensesCsvTable.getDescrUse(i);
                String iprOwner = licensesCsvTable.getIprOwner(i);
                String license = licensesCsvTable.getLicense(i).toUpperCase().equals("NONE") ? null : licensesCsvTable.getLicense(i);
                String iprOwnerUrl = licensesCsvTable.getIprOwnerUrl(i).toUpperCase().equals("NONE") ? null : licensesCsvTable.getIprOwnerUrl(i);
                String licenseUrl = licensesCsvTable.getLicenseUrl(i).toUpperCase().equals("NONE") ? null : licensesCsvTable.getLicenseUrl(i);
                thirdPartyLicenses[i] = new ThirdPartyLicense(name, descriptionUse, iprOwner, license, iprOwnerUrl, licenseUrl);
            }
            ThirdPartyLicense[] thirdPartyLicenseArray = thirdPartyLicenses;
            return thirdPartyLicenseArray;
        }
    }

    private class LineWrapCellRenderer
    extends JTextArea
    implements TableCellRenderer {
        private LineWrapCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int height;
            this.setText((String)value);
            this.setWrapStyleWord(true);
            this.setLineWrap(true);
            Font boldFont = new Font(null, 1, this.getFont().getSize());
            String columnName = table.getModel().getColumnName(column);
            if (LicensesAboutBox.this.licenses[row].getUrlByTableColumnName(columnName) != null) {
                this.setFont(boldFont);
                this.setForeground(Color.blue);
                this.setCursor(Cursor.getPredefinedCursor(12));
            } else if (column == 0) {
                this.setFont(boldFont);
                this.setForeground(table.getForeground());
            } else {
                this.setFont(table.getFont());
                this.setForeground(table.getForeground());
            }
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int fontHeight = fontMetrics.getHeight();
            int textLength = fontMetrics.stringWidth(this.getText());
            int columnWidth = table.getColumnModel().getColumn(column).getWidth();
            int lines = textLength / columnWidth + 1;
            if (lines == 0) {
                lines = 1;
            }
            if ((height = fontHeight * lines + 5) > table.getRowHeight(row)) {
                table.setRowHeight(row, height);
            }
            return this;
        }
    }
}

