/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.temporal.object;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.measure.Unit;
import org.geotools.measure.Units;
import org.geotools.temporal.object.DefaultCalendarDate;
import org.geotools.temporal.object.DefaultDateAndTime;
import org.geotools.temporal.object.DefaultDuration;
import org.geotools.temporal.object.DefaultTemporalCoordinate;
import org.geotools.temporal.reference.DefaultTemporalCoordinateSystem;
import org.opengis.temporal.CalendarDate;
import org.opengis.temporal.DateAndTime;
import org.opengis.temporal.Duration;
import org.opengis.temporal.JulianDate;
import org.opengis.temporal.OrdinalPosition;
import org.opengis.temporal.TemporalCoordinate;
import org.opengis.temporal.TemporalCoordinateSystem;
import si.uom.SI;

public class Utils {
    Logger logger = Logger.getLogger("org.geotools.temporal");
    private static final long yearMS = 31536000000L;
    private static final long monthMS = 2628000000L;
    private static final long weekMS = 604800000L;
    private static final long dayMS = 86400000L;
    private static final long hourMS = 3600000L;
    private static final long minMS = 60000L;
    private static final long secondMS = 1000L;

    public static Date getDateFromString(String dateString) throws ParseException {
        String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
        String DATE_FORMAT2 = "yyyy-MM-dd";
        String DATE_FORMAT3 = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf3 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        if (dateString.contains("T")) {
            int index = dateString.lastIndexOf("+");
            if (index == -1) {
                index = dateString.lastIndexOf("-");
            }
            if (index > dateString.indexOf("T")) {
                String timezoneStr = dateString.substring(index + 1);
                if (timezoneStr.contains(":")) {
                    timezoneStr = timezoneStr.replace(":", "");
                    dateString = dateString.substring(0, index + 1).concat(timezoneStr);
                } else if (timezoneStr.length() == 2) {
                    dateString = dateString.concat("00");
                }
            } else {
                dateString = dateString.endsWith("Z") ? dateString.substring(0, dateString.length() - 1).concat("+0000") : dateString + "+0000";
            }
            String timezone = Utils.getTimeZone(dateString);
            sdf.setTimeZone(TimeZone.getTimeZone(timezone));
            if (dateString.contains(".")) {
                return sdf3.parse(dateString);
            }
            return sdf.parse(dateString);
        }
        if (dateString.contains("-")) {
            return sdf2.parse(dateString);
        }
        return null;
    }

    public static String getTimeZone(String dateString) {
        if (dateString.endsWith("Z")) {
            return "GMT+0";
        }
        int index = dateString.lastIndexOf("+");
        if (index == -1) {
            index = dateString.lastIndexOf("-");
        }
        if (index > dateString.indexOf("T")) {
            return "GMT" + dateString.substring(index);
        }
        return TimeZone.getDefault().getID();
    }

    public static long getTimeInMillis(String periodDuration) {
        long time = 0L;
        if ((periodDuration = periodDuration.substring(1)).indexOf(89) != -1) {
            int nbYear = Integer.parseInt(periodDuration.substring(0, periodDuration.indexOf(89)));
            time += (long)nbYear * 31536000000L;
            periodDuration = periodDuration.substring(periodDuration.indexOf(89) + 1);
        }
        if (periodDuration.indexOf(77) != -1 && (periodDuration.indexOf("T") == -1 || periodDuration.indexOf("T") > periodDuration.indexOf(77))) {
            int nbMonth = Integer.parseInt(periodDuration.substring(0, periodDuration.indexOf(77)));
            time += (long)nbMonth * 2628000000L;
            periodDuration = periodDuration.substring(periodDuration.indexOf(77) + 1);
        }
        if (periodDuration.indexOf(87) != -1) {
            int nbWeek = Integer.parseInt(periodDuration.substring(0, periodDuration.indexOf(87)));
            time += (long)nbWeek * 604800000L;
            periodDuration = periodDuration.substring(periodDuration.indexOf(87) + 1);
        }
        if (periodDuration.indexOf(68) != -1) {
            int nbDay = Integer.parseInt(periodDuration.substring(0, periodDuration.indexOf(68)));
            time += (long)nbDay * 86400000L;
            periodDuration = periodDuration.substring(periodDuration.indexOf(68) + 1);
        }
        if (periodDuration.indexOf(84) != -1) {
            periodDuration = periodDuration.substring(1);
        }
        if (periodDuration.indexOf(72) != -1) {
            int nbHour = Integer.parseInt(periodDuration.substring(0, periodDuration.indexOf(72)));
            time += (long)nbHour * 3600000L;
            periodDuration = periodDuration.substring(periodDuration.indexOf(72) + 1);
        }
        if (periodDuration.indexOf(77) != -1) {
            int nbMin = Integer.parseInt(periodDuration.substring(0, periodDuration.indexOf(77)));
            time += (long)nbMin * 60000L;
            periodDuration = periodDuration.substring(periodDuration.indexOf(77) + 1);
        }
        if (periodDuration.indexOf(83) != -1) {
            int nbSec = Integer.parseInt(periodDuration.substring(0, periodDuration.indexOf(83)));
            time += (long)nbSec * 1000L;
            periodDuration = periodDuration.substring(periodDuration.indexOf(83) + 1);
        }
        if (periodDuration.length() != 0) {
            throw new IllegalArgumentException("The period descritpion is malformed");
        }
        return time;
    }

    public static Date JulianToDate(JulianDate jdt) {
        if (jdt == null) {
            return null;
        }
        int JGREG = 588829;
        int ja = jdt.getCoordinateValue().intValue();
        if (ja >= JGREG) {
            int jalpha = (int)(((double)(ja - 1867216) - 0.25) / 36524.25);
            ja = ja + 1 + jalpha - jalpha / 4;
        }
        int jb = ja + 1524;
        int jc = (int)(6680.0 + ((double)(jb - 2439870) - 122.1) / 365.25);
        int jd = 365 * jc + jc / 4;
        int je = (int)((double)(jb - jd) / 30.6001);
        int day = jb - jd - (int)(30.6001 * (double)je);
        int month = je - 1;
        if (month > 12) {
            month -= 12;
        }
        int year = jc - 4715;
        if (month > 2) {
            --year;
        }
        if (year <= 0) {
            --year;
        }
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, day);
        Date response = cal.getTime();
        return response;
    }

    public static Date calendarDateToDate(CalendarDate calDate) {
        if (calDate == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        DefaultCalendarDate caldate = (DefaultCalendarDate)calDate;
        if (caldate != null) {
            int[] cal = calDate.getCalendarDate();
            int year = 0;
            int month = 0;
            int day = 0;
            if (cal.length > 3) {
                throw new IllegalArgumentException("The CalendarDate integer array is malformed ! see ISO 8601 format.");
            }
            year = cal[0];
            if (cal.length > 0) {
                month = cal[1];
            }
            if (cal.length > 1) {
                day = cal[2];
            }
            calendar.set(year, month, day);
            return calendar.getTime();
        }
        return null;
    }

    public static Date dateAndTimeToDate(DateAndTime dateAndTime) {
        if (dateAndTime == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        DefaultDateAndTime dateTime = (DefaultDateAndTime)dateAndTime;
        if (dateTime != null) {
            int[] cal = dateTime.getCalendarDate();
            int year = 0;
            int month = 0;
            int day = 0;
            if (cal.length > 3) {
                throw new IllegalArgumentException("The CalendarDate integer array is malformed ! see ISO 8601 format.");
            }
            year = cal[0];
            if (cal.length > 0) {
                month = cal[1];
            }
            if (cal.length > 1) {
                day = cal[2];
            }
            Number[] clock = dateTime.getClockTime();
            Number hour = 0;
            Number minute = 0;
            Number second = 0;
            if (clock.length > 3) {
                throw new IllegalArgumentException("The ClockTime Number array is malformed ! see ISO 8601 format.");
            }
            hour = clock[0];
            if (clock.length > 0) {
                minute = clock[1];
            }
            if (clock.length > 1) {
                second = clock[2];
            }
            calendar.set(year, month, day, hour.intValue(), minute.intValue(), second.intValue());
            return calendar.getTime();
        }
        return null;
    }

    public static Date temporalCoordToDate(TemporalCoordinate temporalCoord) {
        if (temporalCoord == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        DefaultTemporalCoordinate timeCoord = (DefaultTemporalCoordinate)temporalCoord;
        Number value = timeCoord.getCoordinateValue();
        if (timeCoord.getFrame() instanceof TemporalCoordinateSystem) {
            DefaultTemporalCoordinateSystem coordSystem = (DefaultTemporalCoordinateSystem)timeCoord.getFrame();
            Date origin = coordSystem.getOrigin();
            String interval = coordSystem.getInterval().toString();
            Long timeInMS = 0L;
            if (interval.equals("year")) {
                timeInMS = value.longValue() * 31536000000L;
            } else if (interval.equals("month")) {
                timeInMS = value.longValue() * 2628000000L;
            } else if (interval.equals("week")) {
                timeInMS = value.longValue() * 604800000L;
            } else if (interval.equals("day")) {
                timeInMS = value.longValue() * 86400000L;
            } else if (interval.equals("hour")) {
                timeInMS = value.longValue() * 3600000L;
            } else if (interval.equals("minute")) {
                timeInMS = value.longValue() * 60000L;
            } else if (interval.equals("second")) {
                timeInMS = value.longValue() * 1000L;
            } else {
                throw new IllegalArgumentException(" The interval of TemporalCoordinateSystem for this TemporalCoordinate object is unknown ! ");
            }
            timeInMS = timeInMS + origin.getTime();
            calendar.setTimeInMillis(timeInMS);
            return calendar.getTime();
        }
        throw new IllegalArgumentException("The frame of this TemporalCoordinate object must be an instance of TemporalCoordinateSystem");
    }

    public static Date ordinalToDate(OrdinalPosition ordinalPosition) {
        if (ordinalPosition == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        if (ordinalPosition.getOrdinalPosition() != null) {
            Date beginEra = ordinalPosition.getOrdinalPosition().getBeginning();
            Date endEra = ordinalPosition.getOrdinalPosition().getEnd();
            Long middle = (endEra.getTime() - beginEra.getTime()) / 2L + beginEra.getTime();
            calendar.setTimeInMillis(middle);
            return calendar.getTime();
        }
        return null;
    }

    public static Unit getUnitFromDuration(Duration duration) {
        if (duration == null) {
            return null;
        }
        DefaultDuration duration_ = (DefaultDuration)duration;
        long mills = duration_.getTimeInMillis();
        long temp = mills / 31536000000L;
        if (temp >= 1L) {
            return SI.YEAR;
        }
        temp = mills / 2628000000L;
        if (temp >= 1L) {
            return Units.MONTH;
        }
        temp = mills / 604800000L;
        if (temp >= 1L) {
            return SI.WEEK;
        }
        temp = mills / 86400000L;
        if (temp >= 1L) {
            return SI.DAY;
        }
        temp = mills / 3600000L;
        if (temp >= 1L) {
            return SI.HOUR;
        }
        temp = mills / 60000L;
        if (temp >= 1L) {
            return SI.MINUTE;
        }
        temp = mills / 1000L;
        if (temp >= 1L) {
            return SI.SECOND;
        }
        return null;
    }
}

