/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geotools.data.Parameter;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.filter.expression.ExpressionAbstract;
import org.locationtech.jts.geom.Geometry;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;

public class FunctionImpl
extends ExpressionAbstract
implements Function {
    String name;
    List<Expression> params = Collections.emptyList();
    Literal fallbackValue;
    protected FunctionName functionName;
    static FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
    static Pattern PARAM = Pattern.compile("(\\w+)(?::([\\.\\w]*)(?::(\\d*),(\\d*))?+)?+");

    public String getName() {
        if (this.name == null && this.functionName != null) {
            return this.functionName.getName();
        }
        return this.name;
    }

    public synchronized FunctionName getFunctionName() {
        if (this.functionName == null) {
            this.functionName = new FunctionNameImpl(this.name, this.getParameters().size());
        }
        return this.functionName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Expression> getParameters() {
        return new ArrayList<Expression>(this.params);
    }

    @Override
    public Object evaluate(Object object) {
        if (this.fallbackValue != null) {
            return this.fallbackValue.evaluate(object);
        }
        throw new UnsupportedOperationException("Function " + this.name + "(" + this.getClass() + ") not implemented");
    }

    public void setParameters(List<Expression> params) {
        this.params = params == null ? Collections.emptyList() : new ArrayList<Expression>(params);
    }

    public void setFallbackValue(Literal fallbackValue) {
        this.fallbackValue = fallbackValue;
    }

    public Literal getFallbackValue() {
        return this.fallbackValue;
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((Function)this, extraData);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append("(");
        List<Expression> params = this.getParameters();
        if (params != null) {
            Iterator<Expression> it = params.iterator();
            while (it.hasNext()) {
                Expression exp = it.next();
                sb.append("[");
                sb.append(exp);
                sb.append("]");
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
        }
        sb.append(")");
        return sb.toString();
    }

    protected Object getParameterValue(Object object, int argumentIndex) {
        org.opengis.parameter.Parameter parameter = (org.opengis.parameter.Parameter)this.getFunctionName().getArguments().get(argumentIndex);
        if (this.params.size() <= argumentIndex) {
            if (parameter.getMinOccurs() == 0) {
                return null;
            }
            throw new IllegalArgumentException(String.format("No arguments specified for arg %s, minOccurs = %d", parameter.getName().toString(), parameter.getMinOccurs()));
        }
        Expression expression = this.params.get(argumentIndex);
        Object value = expression.evaluate(object, parameter.getType());
        if (value == null && expression.evaluate(object) != null) {
            throw new IllegalArgumentException(String.format("Failure converting value for argument %s. %s could not be converted to %s", parameter.getName(), expression.toString(), parameter.getType().getName()));
        }
        return value;
    }

    protected Object getParameterValue(Object object, int argumentIndex, Object defaultValue) {
        Object value = this.getParameterValue(object, argumentIndex);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    protected LinkedHashMap<String, Object> dispatchArguments(Object obj) {
        LinkedHashMap<String, Object> prepped = new LinkedHashMap<String, Object>();
        List args = this.getFunctionName().getArguments();
        List<Expression> expr = this.getParameters();
        if (expr.size() < args.size()) {
            org.opengis.parameter.Parameter last = (org.opengis.parameter.Parameter)args.get(args.size() - 1);
            if (((org.opengis.parameter.Parameter)args.get(0)).getMinOccurs() != 0) {
                throw new IllegalArgumentException(String.format("No arguments specified for arg %s, minOccurs = %d", last.getName().toString(), last.getMinOccurs()));
            }
        }
        for (int i = 0; i < expr.size(); ++i) {
            List<Object> l;
            org.opengis.parameter.Parameter arg = (org.opengis.parameter.Parameter)args.get(Math.min(i, args.size() - 1));
            String argName = arg.getName().toString();
            Object o = expr.get(i).evaluate(obj, arg.getType());
            if (o == null && expr.get(i).evaluate(obj) != null) {
                throw new IllegalArgumentException(String.format("Failure converting value for argument %s. %s could not be converted to %s", arg.getName(), obj.toString(), arg.getType().getName()));
            }
            if (prepped.containsKey(argName)) {
                if (arg.getMaxOccurs() == 1) {
                    throw new IllegalArgumentException(String.format("Multiple values specified for argument %s  but maxOccurs = 1", argName));
                }
                l = (List)prepped.get(argName);
                l.add(o);
                continue;
            }
            if (arg.getMaxOccurs() < 0 || arg.getMaxOccurs() > 1) {
                l = new ArrayList<Object>();
                l.add(o);
                prepped.put(argName, l);
                continue;
            }
            prepped.put(argName, o);
        }
        return prepped;
    }

    protected static FunctionName functionName(String name, String ret, String ... args) {
        ArrayList list = new ArrayList();
        for (String arg : args) {
            list.add(FunctionImpl.toParameter(arg));
        }
        return ff.functionName(name, list, FunctionImpl.toParameter(ret));
    }

    static org.opengis.parameter.Parameter<?> toParameter(String param) throws IllegalArgumentException {
        Matcher m = PARAM.matcher(param);
        if (!m.matches()) {
            throw new IllegalArgumentException("Illegal parameter syntax: " + param);
        }
        String name = m.group(1);
        Class<Object> type = null;
        int min = 1;
        int max = 1;
        String grp = m.group(2);
        if ("".equals(grp)) {
            grp = null;
        }
        if (grp != null) {
            try {
                type = Class.forName(grp);
            }
            catch (ClassNotFoundException e) {
                try {
                    type = Class.forName("java.lang." + grp);
                }
                catch (ClassNotFoundException e1) {
                    try {
                        type = Class.forName("org.locationtech.jts.geom." + grp);
                    }
                    catch (ClassNotFoundException e2) {
                        throw (IllegalArgumentException)new IllegalArgumentException("Unknown type: " + grp).initCause(e);
                    }
                }
            }
        }
        if (type == null && "geom".equals(name)) {
            type = Geometry.class;
        }
        if (type == null) {
            type = Object.class;
        }
        if ((grp = m.group(3)) != null) {
            int n = min = !"".equals(grp) ? Integer.parseInt(grp) : -1;
        }
        if ((grp = m.group(4)) != null) {
            max = !"".equals(grp) ? Integer.parseInt(grp) : -1;
        }
        return new Parameter(name, type, min, max);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fallbackValue == null ? 0 : this.fallbackValue.hashCode());
        result = 31 * result + (this.functionName == null ? 0 : this.functionName.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.params == null ? 0 : this.params.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionImpl other = (FunctionImpl)obj;
        if (this.fallbackValue == null ? other.fallbackValue != null : !this.fallbackValue.equals(other.fallbackValue)) {
            return false;
        }
        if (this.functionName == null ? other.functionName != null : !this.functionName.equals(other.functionName)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.params == null ? other.params != null : !this.params.equals(other.params));
    }
}

