/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.io.Serializable;

public class Parameter
implements Serializable {
    private String name;
    private String valueS;
    private double[] valueD;
    private boolean isString;
    private volatile int hashCode;

    public String getName() {
        return this.name;
    }

    public boolean isString() {
        return this.isString;
    }

    public String getStringValue() {
        if (this.valueS == null) {
            StringBuilder sbuff = new StringBuilder();
            for (double v : this.valueD) {
                sbuff.append(v).append(" ");
            }
            this.valueS = sbuff.toString();
        }
        return this.valueS;
    }

    public double getNumericValue() {
        return this.valueD[0];
    }

    public double getNumericValue(int i) {
        return this.valueD[i];
    }

    public int getLength() {
        return this.valueD.length;
    }

    public double[] getNumericValues() {
        return this.valueD;
    }

    public boolean equals(Object oo) {
        if (this == oo) {
            return true;
        }
        if (!(oo instanceof Parameter)) {
            return false;
        }
        return this.hashCode() == oo.hashCode();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.getName().hashCode();
            if (this.valueS != null) {
                result = 37 * result + this.getStringValue().hashCode();
            }
            if (this.valueD != null) {
                for (double v : this.valueD) {
                    result = (int)((double)result + 1000.0 * v);
                }
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.getName());
        if (this.isString()) {
            buff.append(" = ");
            buff.append(this.valueS);
        } else {
            buff.append(" = ");
            for (int i = 0; i < this.getLength(); ++i) {
                if (i != 0) {
                    buff.append(", ");
                }
                buff.append(this.getNumericValue(i));
            }
        }
        return buff.toString();
    }

    public Parameter(String name, Parameter from) {
        this.name = name;
        this.valueS = from.valueS;
        this.valueD = from.valueD;
        this.isString = from.isString;
    }

    public Parameter(String name, String val) {
        this.name = name;
        this.valueS = val;
        this.isString = true;
    }

    public Parameter(String name, double value) {
        this.name = name;
        this.valueD = new double[1];
        this.valueD[0] = value;
    }

    public Parameter(String name, double[] value) {
        this.name = name;
        this.valueD = (double[])value.clone();
    }
}

