/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.io.IOException;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructureW;
import ucar.ma2.DataType;
import ucar.ma2.ForbiddenConversionException;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.util.Indent;

public abstract class ArrayStructure
extends Array
implements Iterable<StructureData> {
    protected StructureMembers members;
    protected int nelems;
    protected StructureData[] sdata;

    protected ArrayStructure(StructureMembers members, int[] shape) {
        super(DataType.STRUCTURE, shape);
        this.members = members;
        this.nelems = (int)this.indexCalc.getSize();
    }

    protected ArrayStructure(StructureMembers members, Index ima) {
        super(DataType.STRUCTURE, ima);
        this.members = members;
        this.nelems = (int)this.indexCalc.getSize();
    }

    @Override
    protected void copyFrom1DJavaArray(IndexIterator iter, Object javaArray) {
        Object[] ja;
        for (Object aJa : ja = (Object[])javaArray) {
            iter.setObjectNext(aJa);
        }
    }

    @Override
    protected void copyTo1DJavaArray(IndexIterator iter, Object javaArray) {
        Object[] ja = (Object[])javaArray;
        for (int i = 0; i < ja.length; ++i) {
            ja[i] = iter.getObjectNext();
        }
    }

    @Override
    public Class getElementType() {
        return StructureData.class;
    }

    public StructureMembers getStructureMembers() {
        return this.members;
    }

    public List<StructureMembers.Member> getMembers() {
        return this.members.getMembers();
    }

    public List<String> getStructureMemberNames() {
        return this.members.getMemberNames();
    }

    public StructureMembers.Member findMember(String memberName) {
        return this.members.findMember(memberName);
    }

    @Override
    public long getSizeBytes() {
        return this.indexCalc.getSize() * (long)this.members.getStructureSize();
    }

    @Override
    public Object getObject(Index i) {
        return this.getObject(i.currentElement());
    }

    @Override
    public void setObject(Index i, Object value) {
        this.setObject(i.currentElement(), value);
    }

    @Override
    public Object getObject(int index) {
        return this.getStructureData(index);
    }

    @Override
    public void setObject(int index, Object value) {
        if (this.sdata == null) {
            this.sdata = new StructureData[this.nelems];
        }
        this.sdata[index] = (StructureData)value;
    }

    public StructureData getStructureData(Index i) {
        return this.getStructureData(i.currentElement());
    }

    public StructureData getStructureData(int index) {
        if (this.sdata == null) {
            this.sdata = new StructureData[this.nelems];
        }
        if (index >= this.sdata.length) {
            throw new IllegalArgumentException(index + " > " + this.sdata.length);
        }
        if (this.sdata[index] == null) {
            this.sdata[index] = this.makeStructureData(this, index);
        }
        return this.sdata[index];
    }

    @Override
    public Object getStorage() {
        for (int i = 0; i < this.nelems; ++i) {
            this.getStructureData(i);
        }
        return this.sdata;
    }

    protected abstract StructureData makeStructureData(ArrayStructure var1, int var2);

    public int getStructureSize() {
        return this.members.getStructureSize();
    }

    @Override
    public Iterator<StructureData> iterator() {
        return new ArrayStructureIterator();
    }

    public StructureDataIterator getStructureDataIterator() {
        return new ArrayStructureIterator();
    }

    public Array getArray(int recno, StructureMembers.Member m3) {
        DataType dataType = m3.getDataType();
        switch (dataType) {
            case DOUBLE: {
                double[] da = this.getJavaArrayDouble(recno, m3);
                return Array.factory(dataType, m3.getShape(), (Object)da);
            }
            case FLOAT: {
                float[] fa = this.getJavaArrayFloat(recno, m3);
                return Array.factory(dataType, m3.getShape(), (Object)fa);
            }
            case BYTE: 
            case UBYTE: 
            case ENUM1: {
                byte[] ba = this.getJavaArrayByte(recno, m3);
                return Array.factory(dataType, m3.getShape(), (Object)ba);
            }
            case SHORT: 
            case USHORT: 
            case ENUM2: {
                short[] sa = this.getJavaArrayShort(recno, m3);
                return Array.factory(dataType, m3.getShape(), (Object)sa);
            }
            case INT: 
            case UINT: 
            case ENUM4: {
                int[] ia = this.getJavaArrayInt(recno, m3);
                return Array.factory(dataType, m3.getShape(), (Object)ia);
            }
            case ULONG: 
            case LONG: {
                long[] la = this.getJavaArrayLong(recno, m3);
                return Array.factory(dataType, m3.getShape(), (Object)la);
            }
            case CHAR: {
                char[] ca = this.getJavaArrayChar(recno, m3);
                return Array.factory(dataType, m3.getShape(), (Object)ca);
            }
            case STRING: {
                String[] str = this.getJavaArrayString(recno, m3);
                return Array.factory(dataType, m3.getShape(), (Object)str);
            }
            case STRUCTURE: {
                return this.getArrayStructure(recno, m3);
            }
            case SEQUENCE: {
                return this.getArraySequence(recno, m3);
            }
            case OPAQUE: {
                return this.getArrayObject(recno, m3);
            }
        }
        throw new RuntimeException("Dont have implemenation for " + (Object)((Object)dataType));
    }

    public void setMemberArray(StructureMembers.Member m3, Array memberArray) {
        m3.setDataArray(memberArray);
        if (memberArray instanceof ArrayStructure) {
            ArrayStructure as = (ArrayStructure)memberArray;
            m3.setStructureMembers(as.getStructureMembers());
        }
    }

    public Array extractMemberArray(StructureMembers.Member m3) throws IOException {
        Array result;
        block14: {
            IndexIterator resultIter;
            DataType dataType;
            block22: {
                block21: {
                    block20: {
                        block19: {
                            block18: {
                                block17: {
                                    block16: {
                                        block15: {
                                            block13: {
                                                if (m3.getDataArray() != null) {
                                                    return m3.getDataArray();
                                                }
                                                dataType = m3.getDataType();
                                                int[] mshape = m3.getShape();
                                                int rrank = this.rank + mshape.length;
                                                int[] rshape = new int[rrank];
                                                System.arraycopy(this.getShape(), 0, rshape, 0, this.rank);
                                                System.arraycopy(mshape, 0, rshape, this.rank, mshape.length);
                                                if (dataType == DataType.STRUCTURE) {
                                                    StructureMembers membersw = new StructureMembers(m3.getStructureMembers());
                                                    result = new ArrayStructureW(membersw, rshape);
                                                } else {
                                                    result = dataType == DataType.OPAQUE ? Array.factory(DataType.OPAQUE, rshape) : Array.factory(dataType, rshape);
                                                }
                                                resultIter = result.getIndexIterator();
                                                if (dataType != DataType.DOUBLE) break block13;
                                                int recno = 0;
                                                while ((long)recno < this.getSize()) {
                                                    this.copyDoubles(recno, m3, resultIter);
                                                    ++recno;
                                                }
                                                break block14;
                                            }
                                            if (dataType != DataType.FLOAT) break block15;
                                            int recno = 0;
                                            while ((long)recno < this.getSize()) {
                                                this.copyFloats(recno, m3, resultIter);
                                                ++recno;
                                            }
                                            break block14;
                                        }
                                        if (dataType.getPrimitiveClassType() != Byte.TYPE) break block16;
                                        int recno = 0;
                                        while ((long)recno < this.getSize()) {
                                            this.copyBytes(recno, m3, resultIter);
                                            ++recno;
                                        }
                                        break block14;
                                    }
                                    if (dataType.getPrimitiveClassType() != Short.TYPE) break block17;
                                    int recno = 0;
                                    while ((long)recno < this.getSize()) {
                                        this.copyShorts(recno, m3, resultIter);
                                        ++recno;
                                    }
                                    break block14;
                                }
                                if (dataType.getPrimitiveClassType() != Integer.TYPE) break block18;
                                int recno = 0;
                                while ((long)recno < this.getSize()) {
                                    this.copyInts(recno, m3, resultIter);
                                    ++recno;
                                }
                                break block14;
                            }
                            if (dataType.getPrimitiveClassType() != Long.TYPE) break block19;
                            int recno = 0;
                            while ((long)recno < this.getSize()) {
                                this.copyLongs(recno, m3, resultIter);
                                ++recno;
                            }
                            break block14;
                        }
                        if (dataType != DataType.CHAR) break block20;
                        int recno = 0;
                        while ((long)recno < this.getSize()) {
                            this.copyChars(recno, m3, resultIter);
                            ++recno;
                        }
                        break block14;
                    }
                    if (dataType != DataType.STRING && dataType != DataType.OPAQUE) break block21;
                    int recno = 0;
                    while ((long)recno < this.getSize()) {
                        this.copyObjects(recno, m3, resultIter);
                        ++recno;
                    }
                    break block14;
                }
                if (dataType != DataType.STRUCTURE) break block22;
                int recno = 0;
                while ((long)recno < this.getSize()) {
                    this.copyStructures(recno, m3, resultIter);
                    ++recno;
                }
                break block14;
            }
            if (dataType != DataType.SEQUENCE) break block14;
            int recno = 0;
            while ((long)recno < this.getSize()) {
                this.copySequences(recno, m3, resultIter);
                ++recno;
            }
        }
        return result;
    }

    protected void copyChars(int recnum, StructureMembers.Member m3, IndexIterator result) {
        IndexIterator dataIter = this.getArray(recnum, m3).getIndexIterator();
        while (dataIter.hasNext()) {
            result.setCharNext(dataIter.getCharNext());
        }
    }

    protected void copyDoubles(int recnum, StructureMembers.Member m3, IndexIterator result) {
        IndexIterator dataIter = this.getArray(recnum, m3).getIndexIterator();
        while (dataIter.hasNext()) {
            result.setDoubleNext(dataIter.getDoubleNext());
        }
    }

    protected void copyFloats(int recnum, StructureMembers.Member m3, IndexIterator result) {
        IndexIterator dataIter = this.getArray(recnum, m3).getIndexIterator();
        while (dataIter.hasNext()) {
            result.setFloatNext(dataIter.getFloatNext());
        }
    }

    protected void copyBytes(int recnum, StructureMembers.Member m3, IndexIterator result) {
        IndexIterator dataIter = this.getArray(recnum, m3).getIndexIterator();
        while (dataIter.hasNext()) {
            result.setByteNext(dataIter.getByteNext());
        }
    }

    protected void copyShorts(int recnum, StructureMembers.Member m3, IndexIterator result) {
        IndexIterator dataIter = this.getArray(recnum, m3).getIndexIterator();
        while (dataIter.hasNext()) {
            result.setShortNext(dataIter.getShortNext());
        }
    }

    protected void copyInts(int recnum, StructureMembers.Member m3, IndexIterator result) {
        IndexIterator dataIter = this.getArray(recnum, m3).getIndexIterator();
        while (dataIter.hasNext()) {
            result.setIntNext(dataIter.getIntNext());
        }
    }

    protected void copyLongs(int recnum, StructureMembers.Member m3, IndexIterator result) {
        IndexIterator dataIter = this.getArray(recnum, m3).getIndexIterator();
        while (dataIter.hasNext()) {
            result.setLongNext(dataIter.getLongNext());
        }
    }

    protected void copyObjects(int recnum, StructureMembers.Member m3, IndexIterator result) {
        IndexIterator dataIter = this.getArray(recnum, m3).getIndexIterator();
        while (dataIter.hasNext()) {
            result.setObjectNext(dataIter.getObjectNext());
        }
    }

    protected void copyStructures(int recnum, StructureMembers.Member m3, IndexIterator result) {
        Array data = this.getArray(recnum, m3);
        IndexIterator dataIter = data.getIndexIterator();
        while (dataIter.hasNext()) {
            result.setObjectNext(dataIter.getObjectNext());
        }
    }

    protected void copySequences(int recnum, StructureMembers.Member m3, IndexIterator result) {
        Array data = this.getArray(recnum, m3);
        result.setObjectNext(data);
    }

    public Object getScalarObject(int recno, StructureMembers.Member m3) {
        DataType dataType = m3.getDataType();
        if (dataType == DataType.DOUBLE) {
            return this.getScalarDouble(recno, m3);
        }
        if (dataType == DataType.FLOAT) {
            return Float.valueOf(this.getScalarFloat(recno, m3));
        }
        if (dataType.getPrimitiveClassType() == Byte.TYPE) {
            return this.getScalarByte(recno, m3);
        }
        if (dataType.getPrimitiveClassType() == Short.TYPE) {
            return this.getScalarShort(recno, m3);
        }
        if (dataType.getPrimitiveClassType() == Integer.TYPE) {
            return this.getScalarInt(recno, m3);
        }
        if (dataType.getPrimitiveClassType() == Long.TYPE) {
            return this.getScalarLong(recno, m3);
        }
        if (dataType == DataType.CHAR) {
            return this.getScalarString(recno, m3);
        }
        if (dataType == DataType.STRING) {
            return this.getScalarString(recno, m3);
        }
        if (dataType == DataType.STRUCTURE) {
            return this.getScalarStructure(recno, m3);
        }
        if (dataType == DataType.OPAQUE) {
            ArrayObject data = (ArrayObject)m3.getDataArray();
            return data.getObject(recno * m3.getSize());
        }
        throw new RuntimeException("Dont have implementation for " + (Object)((Object)dataType));
    }

    public float convertScalarFloat(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() == DataType.FLOAT) {
            return this.getScalarFloat(recnum, m3);
        }
        if (m3.getDataType() == DataType.DOUBLE) {
            return (float)this.getScalarDouble(recnum, m3);
        }
        Object o = this.getScalarObject(recnum, m3);
        if (o instanceof Number) {
            return ((Number)o).floatValue();
        }
        throw new ForbiddenConversionException("Type is " + (Object)((Object)m3.getDataType()) + ", not convertible to float");
    }

    public double convertScalarDouble(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() == DataType.DOUBLE) {
            return this.getScalarDouble(recnum, m3);
        }
        if (m3.getDataType() == DataType.FLOAT) {
            return this.getScalarFloat(recnum, m3);
        }
        Object o = this.getScalarObject(recnum, m3);
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        throw new ForbiddenConversionException("Type is " + (Object)((Object)m3.getDataType()) + ", not convertible to double");
    }

    public int convertScalarInt(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() == DataType.INT || m3.getDataType() == DataType.UINT) {
            return this.getScalarInt(recnum, m3);
        }
        if (m3.getDataType() == DataType.SHORT) {
            return this.getScalarShort(recnum, m3);
        }
        if (m3.getDataType() == DataType.USHORT) {
            return DataType.unsignedShortToInt(this.getScalarShort(recnum, m3));
        }
        if (m3.getDataType() == DataType.BYTE) {
            return this.getScalarByte(recnum, m3);
        }
        if (m3.getDataType() == DataType.UBYTE) {
            return DataType.unsignedByteToShort(this.getScalarByte(recnum, m3));
        }
        if (m3.getDataType() == DataType.LONG || m3.getDataType() == DataType.ULONG) {
            return (int)this.getScalarLong(recnum, m3);
        }
        Object o = this.getScalarObject(recnum, m3);
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        throw new ForbiddenConversionException("Type is " + (Object)((Object)m3.getDataType()) + ", not convertible to int");
    }

    public long convertScalarLong(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() == DataType.LONG || m3.getDataType() == DataType.ULONG) {
            return this.getScalarLong(recnum, m3);
        }
        if (m3.getDataType() == DataType.INT) {
            return this.getScalarInt(recnum, m3);
        }
        if (m3.getDataType() == DataType.UINT) {
            return DataType.unsignedIntToLong(this.getScalarInt(recnum, m3));
        }
        if (m3.getDataType() == DataType.SHORT) {
            return this.getScalarShort(recnum, m3);
        }
        if (m3.getDataType() == DataType.USHORT) {
            return DataType.unsignedShortToInt(this.getScalarShort(recnum, m3));
        }
        if (m3.getDataType() == DataType.BYTE) {
            return this.getScalarByte(recnum, m3);
        }
        if (m3.getDataType() == DataType.UBYTE) {
            return DataType.unsignedByteToShort(this.getScalarByte(recnum, m3));
        }
        Object o = this.getScalarObject(recnum, m3);
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        throw new ForbiddenConversionException("Type is " + (Object)((Object)m3.getDataType()) + ", not convertible to int");
    }

    public double getScalarDouble(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() != DataType.DOUBLE) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be double");
        }
        Array data = m3.getDataArray();
        return data.getDouble(recnum * m3.getSize());
    }

    public double[] getJavaArrayDouble(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() != DataType.DOUBLE) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be double");
        }
        int count = m3.getSize();
        Array data = m3.getDataArray();
        double[] pa = new double[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = data.getDouble(recnum * count + i);
        }
        return pa;
    }

    public float getScalarFloat(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() != DataType.FLOAT) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be float");
        }
        Array data = m3.getDataArray();
        return data.getFloat(recnum * m3.getSize());
    }

    public float[] getJavaArrayFloat(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() != DataType.FLOAT) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be float");
        }
        int count = m3.getSize();
        Array data = m3.getDataArray();
        float[] pa = new float[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = data.getFloat(recnum * count + i);
        }
        return pa;
    }

    public byte getScalarByte(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType().getPrimitiveClassType() != Byte.TYPE) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be byte");
        }
        Array data = m3.getDataArray();
        return data.getByte(recnum * m3.getSize());
    }

    public byte[] getJavaArrayByte(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType().getPrimitiveClassType() != Byte.TYPE) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be byte");
        }
        int count = m3.getSize();
        Array data = m3.getDataArray();
        byte[] pa = new byte[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = data.getByte(recnum * count + i);
        }
        return pa;
    }

    public short getScalarShort(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType().getPrimitiveClassType() != Short.TYPE) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be short");
        }
        Array data = m3.getDataArray();
        return data.getShort(recnum * m3.getSize());
    }

    public short[] getJavaArrayShort(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType().getPrimitiveClassType() != Short.TYPE) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be short");
        }
        int count = m3.getSize();
        Array data = m3.getDataArray();
        short[] pa = new short[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = data.getShort(recnum * count + i);
        }
        return pa;
    }

    public int getScalarInt(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType().getPrimitiveClassType() != Integer.TYPE) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be int");
        }
        Array data = m3.getDataArray();
        return data.getInt(recnum * m3.getSize());
    }

    public int[] getJavaArrayInt(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType().getPrimitiveClassType() != Integer.TYPE) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be int");
        }
        int count = m3.getSize();
        Array data = m3.getDataArray();
        int[] pa = new int[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = data.getInt(recnum * count + i);
        }
        return pa;
    }

    public long getScalarLong(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType().getPrimitiveClassType() != Long.TYPE) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be long");
        }
        Array data = m3.getDataArray();
        return data.getLong(recnum * m3.getSize());
    }

    public long[] getJavaArrayLong(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType().getPrimitiveClassType() != Long.TYPE) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be long");
        }
        int count = m3.getSize();
        Array data = m3.getDataArray();
        long[] pa = new long[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = data.getLong(recnum * count + i);
        }
        return pa;
    }

    public char getScalarChar(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() != DataType.CHAR) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be char");
        }
        Array data = m3.getDataArray();
        return data.getChar(recnum * m3.getSize());
    }

    public char[] getJavaArrayChar(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() != DataType.CHAR) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be char");
        }
        int count = m3.getSize();
        Array data = m3.getDataArray();
        char[] pa = new char[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = data.getChar(recnum * count + i);
        }
        return pa;
    }

    public String getScalarString(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() == DataType.CHAR) {
            ArrayChar data = (ArrayChar)m3.getDataArray();
            return data.getString(recnum);
        }
        if (m3.getDataType() == DataType.STRING) {
            Array data = m3.getDataArray();
            return (String)data.getObject(recnum);
        }
        throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be String or char");
    }

    public String[] getJavaArrayString(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() == DataType.STRING) {
            int n = m3.getSize();
            String[] result = new String[n];
            Array data = m3.getDataArray();
            for (int i = 0; i < n; ++i) {
                result[i] = (String)data.getObject(recnum * n + i);
            }
            return result;
        }
        if (m3.getDataType() == DataType.CHAR) {
            int strlen = this.indexCalc.getShape(this.rank - 1);
            int n = m3.getSize() / strlen;
            String[] result = new String[n];
            ArrayChar data = (ArrayChar)m3.getDataArray();
            for (int i = 0; i < n; ++i) {
                result[i] = data.getString((recnum * n + i) * strlen);
            }
            return result;
        }
        throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be String or char");
    }

    public StructureData getScalarStructure(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() != DataType.STRUCTURE) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be Structure");
        }
        ArrayStructure data = (ArrayStructure)m3.getDataArray();
        return data.getStructureData(recnum * m3.getSize());
    }

    public ArrayStructure getArrayStructure(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() != DataType.STRUCTURE && m3.getDataType() != DataType.SEQUENCE) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be Structure or Sequence");
        }
        if (m3.getDataType() == DataType.SEQUENCE) {
            return this.getArraySequence(recnum, m3);
        }
        ArrayStructure array = (ArrayStructure)m3.getDataArray();
        int count = m3.getSize();
        StructureData[] this_sdata = new StructureData[count];
        for (int i = 0; i < count; ++i) {
            this_sdata[i] = array.getStructureData(recnum * count + i);
        }
        StructureMembers membersw = new StructureMembers(array.getStructureMembers());
        return new ArrayStructureW(membersw, m3.getShape(), this_sdata);
    }

    public ArraySequence getArraySequence(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() != DataType.SEQUENCE) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be Sequence");
        }
        ArrayObject array = (ArrayObject)m3.getDataArray();
        return (ArraySequence)array.getObject(recnum);
    }

    public ArrayObject getArrayObject(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() != DataType.OPAQUE) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be Sequence");
        }
        ArrayObject array = (ArrayObject)m3.getDataArray();
        return (ArrayObject)array.getObject(recnum);
    }

    public void showInternal(Formatter f, Indent indent) {
        f.format("%sArrayStructure %s size=%d class=%s hash=0x%x%n", indent, this.members.getName(), this.getSize(), this.getClass().getName(), this.hashCode());
    }

    public void showInternalMembers(Formatter f, Indent indent) {
        f.format("%sArrayStructure %s class=%s hash=0x%x%n", indent, this.members.getName(), this.getClass().getName(), this.hashCode());
        indent.incr();
        for (StructureMembers.Member m3 : this.getMembers()) {
            m3.showInternal(f, indent);
        }
        indent.incr();
    }

    @Override
    public Array createView(Index index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Array sectionNoReduce(List<Range> ranges) {
        Section viewSection = new Section(ranges);
        ArrayStructureW result = new ArrayStructureW(this.members, viewSection.getShape());
        int count = 0;
        Section.Iterator iter = viewSection.getIterator(this.getShape());
        while (iter.hasNext()) {
            int recno = iter.next(null);
            StructureData sd = this.getStructureData(recno);
            result.setStructureData(sd, count++);
        }
        return result;
    }

    @Override
    public Array copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDouble(Index i) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setDouble(Index i, double value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public float getFloat(Index i) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setFloat(Index i, float value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public long getLong(Index i) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setLong(Index i, long value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public int getInt(Index i) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setInt(Index i, int value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public short getShort(Index i) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setShort(Index i, short value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public byte getByte(Index i) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setByte(Index i, byte value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public boolean getBoolean(Index i) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setBoolean(Index i, boolean value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public char getChar(Index i) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setChar(Index i, char value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public double getDouble(int index) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setDouble(int index, double value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public float getFloat(int index) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setFloat(int index, float value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public long getLong(int index) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setLong(int index, long value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public int getInt(int index) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setInt(int index, int value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public short getShort(int index) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setShort(int index, short value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public byte getByte(int index) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setByte(int index, byte value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public char getChar(int index) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setChar(int index, char value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public boolean getBoolean(int index) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setBoolean(int index, boolean value) {
        throw new ForbiddenConversionException();
    }

    public class ArrayStructureIterator
    implements StructureDataIterator,
    Iterator<StructureData> {
        private int count;
        private int size;

        public ArrayStructureIterator() {
            this.size = (int)ArrayStructure.this.getSize();
        }

        @Override
        public boolean hasNext() {
            return this.count < this.size;
        }

        @Override
        public StructureData next() {
            return ArrayStructure.this.getStructureData(this.count++);
        }

        @Override
        public StructureDataIterator reset() {
            this.count = 0;
            return this;
        }

        @Override
        public int getCurrentRecno() {
            return this.count - 1;
        }

        public ArrayStructure getArrayStructure() {
            return ArrayStructure.this;
        }
    }
}

