/*
 * Decompiled with CFR 0.152.
 */
package ucar.jpeg.icc.lut;

import ucar.jpeg.icc.lut.LookUpTable;
import ucar.jpeg.icc.lut.LookUpTable16Gamma;
import ucar.jpeg.icc.lut.LookUpTable16Interp;
import ucar.jpeg.icc.tags.ICCCurveType;

public abstract class LookUpTable16
extends LookUpTable {
    protected final int dwMaxOutput;
    protected final short[] lut;

    public String toString() {
        StringBuffer rep = new StringBuffer("[LookUpTable16 ");
        rep.append("max= " + this.dwMaxOutput);
        rep.append(", nentries= " + this.dwMaxOutput);
        return rep.append("]").toString();
    }

    public String toStringWholeLut() {
        int col;
        int row;
        StringBuffer rep = new StringBuffer("[LookUpTable16" + eol);
        rep.append("max output = " + this.dwMaxOutput + eol);
        for (row = 0; row < this.dwNumInput / 10; ++row) {
            rep.append("lut[" + 10 * row + "] : ");
            for (col = 0; col < 10; ++col) {
                rep.append(this.lut[10 * row + col]).append(" ");
            }
            rep.append(eol);
        }
        rep.append("lut[" + 10 * row + "] : ");
        for (col = 0; col < this.dwNumInput % 10; ++col) {
            rep.append(this.lut[10 * row + col] + " ");
        }
        rep.append(eol + eol);
        return rep.toString();
    }

    public static LookUpTable16 createInstance(ICCCurveType curve, int dwNumInput, int dwMaxOutput) {
        if (curve.count == 1) {
            return new LookUpTable16Gamma(curve, dwNumInput, dwMaxOutput);
        }
        return new LookUpTable16Interp(curve, dwNumInput, dwMaxOutput);
    }

    protected LookUpTable16(int dwNumInput, int dwMaxOutput) {
        super(null, dwNumInput);
        this.lut = new short[dwNumInput];
        this.dwMaxOutput = dwMaxOutput;
    }

    protected LookUpTable16(ICCCurveType curve, int dwNumInput, int dwMaxOutput) {
        super(curve, dwNumInput);
        this.dwMaxOutput = dwMaxOutput;
        this.lut = new short[dwNumInput];
    }

    public final short elementAt(int index) {
        return this.lut[index];
    }
}

