/*
 * Decompiled with CFR 0.152.
 */
package ucar.atd.dorade;

import java.io.RandomAccessFile;
import java.util.Calendar;
import java.util.Date;
import ucar.atd.dorade.DoradeDescriptor;
import ucar.atd.dorade.DoradeVOLD;

class DoradeRYIB
extends DoradeDescriptor {
    private int sweepNumber;
    private Date rayTime;
    private float azimuth;
    private float elevation;
    private float lastPeakPower;
    private float scanRate;
    private int rayStatus;

    public DoradeRYIB(RandomAccessFile file, boolean littleEndianData, DoradeVOLD vold) throws DoradeDescriptor.DescriptorException {
        byte[] data = this.readDescriptor(file, littleEndianData, "RYIB");
        this.sweepNumber = this.grabInt(data, 8);
        int julianDay = this.grabInt(data, 12);
        short hour = this.grabShort(data, 16);
        short minute = this.grabShort(data, 18);
        short second = this.grabShort(data, 20);
        short milliSecond = this.grabShort(data, 22);
        this.azimuth = this.grabFloat(data, 24);
        this.elevation = this.grabFloat(data, 28);
        this.lastPeakPower = this.grabFloat(data, 32);
        this.scanRate = this.grabFloat(data, 36);
        this.rayStatus = this.grabInt(data, 40);
        Date volumeTime = vold.getVolumeTime();
        Calendar volumeCalendar = Calendar.getInstance(TZ_UTC);
        volumeCalendar.setTime(volumeTime);
        Calendar rayTimeCalendar = (Calendar)volumeCalendar.clone();
        rayTimeCalendar.set(11, hour);
        rayTimeCalendar.set(12, minute);
        rayTimeCalendar.set(13, second);
        rayTimeCalendar.set(14, milliSecond);
        if (rayTimeCalendar.before(volumeCalendar)) {
            rayTimeCalendar.add(5, 1);
        }
        this.rayTime = rayTimeCalendar.getTime();
    }

    public String toString() {
        String s2 = "RYIB\n";
        s2 = s2 + "  sweep number: " + this.sweepNumber + "\n";
        s2 = s2 + "  ray time: " + DoradeRYIB.formatDate(this.rayTime) + "\n";
        s2 = s2 + "  azimuth: " + this.azimuth + "\n";
        s2 = s2 + "  elevation: " + this.elevation + "\n";
        s2 = s2 + "  last peak transmitted power: " + this.lastPeakPower + "\n";
        s2 = s2 + "  scan rate: " + this.scanRate + "\n";
        s2 = s2 + "  ray status: " + this.rayStatus;
        return s2;
    }

    public float getAzimuth() {
        return this.azimuth;
    }

    public float getElevation() {
        return this.elevation;
    }

    public Date getRayTime() {
        return this.rayTime;
    }
}

