/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.pointop;

import com.bc.ceres.core.Assert;
import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.AbstractMultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ConvolutionFilterBand;
import org.esa.snap.core.datamodel.GeneralFilterBand;
import org.esa.snap.core.datamodel.Kernel;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeFilter;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.pointop.ProductConfigurer;
import org.esa.snap.core.gpf.pointop.Sample;
import org.esa.snap.core.gpf.pointop.SourceSampleConfigurer;
import org.esa.snap.core.gpf.pointop.TargetSampleConfigurer;
import org.esa.snap.core.gpf.pointop.WritableSample;
import org.esa.snap.core.image.ResolutionLevel;
import org.esa.snap.core.image.VirtualBandOpImage;
import org.esa.snap.core.jexp.Term;
import org.esa.snap.core.util.ProductUtils;

public abstract class PointOperator
extends Operator {
    private transient RasterDataNode[] sourceRasters;
    private transient RasterDataNode[] computedRasters;
    private transient Mask validPixelMask;
    private transient Band[] targetBands;

    @Override
    public final void initialize() throws OperatorException {
        this.prepareInputs();
        Product targetProduct = this.createTargetProduct();
        this.setTargetProduct(targetProduct);
        this.configureTargetProduct(new ProductConfigurerImpl(this.getSourceProduct(), targetProduct));
        SourceSampleConfigurerImpl sc = new SourceSampleConfigurerImpl();
        TargetSampleConfigurerImpl tc = new TargetSampleConfigurerImpl();
        this.configureSourceSamples(sc);
        this.configureTargetSamples(tc);
        this.sourceRasters = sc.getRasters();
        this.computedRasters = sc.getComputeNodes();
        this.targetBands = tc.getRasters();
    }

    protected void prepareInputs() throws OperatorException {
        this.checkRasterSize();
    }

    @Override
    public void dispose() {
        super.dispose();
        for (RasterDataNode node : this.computedRasters) {
            node.dispose();
        }
        this.sourceRasters = null;
        this.computedRasters = null;
        this.targetBands = null;
    }

    protected Product createTargetProduct() throws OperatorException {
        Product sourceProduct = this.getSourceProduct();
        Assert.state((sourceProduct != null ? 1 : 0) != 0, (String)"source product not set");
        return new Product(this.getId(), this.getClass().getName(), sourceProduct.getSceneRasterWidth(), sourceProduct.getSceneRasterHeight());
    }

    protected void configureTargetProduct(ProductConfigurer productConfigurer) {
        productConfigurer.copyTimeCoding();
        productConfigurer.copyTiePointGrids(new String[0]);
        productConfigurer.copyGeoCoding();
    }

    protected abstract void configureSourceSamples(SourceSampleConfigurer var1) throws OperatorException;

    protected abstract void configureTargetSamples(TargetSampleConfigurer var1) throws OperatorException;

    protected final void checkRasterSize() throws OperatorException {
        Product[] sourceProducts = this.getSourceProducts();
        this.ensureSingleRasterSize(sourceProducts);
    }

    Sample[] createSourceSamples(Rectangle targetRectangle, Point location) {
        Tile[] sourceTiles = this.getSourceTiles(targetRectangle);
        return PointOperator.createDefaultSamples(this.sourceRasters, sourceTiles, location);
    }

    Sample createSourceMaskSamples(Rectangle targetRectangle, Point location) {
        Tile sourceMaskTile = this.getSourceMaskTile(targetRectangle);
        return sourceMaskTile != null ? new WritableSampleImpl(-1, sourceMaskTile, location) : null;
    }

    WritableSample[] createTargetSamples(Map<Band, Tile> targetTileStack, Point location) {
        Tile[] targetTiles = this.getTargetTiles(targetTileStack);
        return PointOperator.createDefaultSamples((RasterDataNode[])this.targetBands, targetTiles, location);
    }

    WritableSample createTargetSample(Tile targetTile, Point location) {
        RasterDataNode targetRaster = targetTile.getRasterDataNode();
        for (int i = 0; i < this.targetBands.length; ++i) {
            if (targetRaster != this.targetBands[i]) continue;
            return new WritableSampleImpl(i, targetTile, location);
        }
        String msgPattern = "Could not create target sample for band '%s'.";
        throw new IllegalStateException(String.format("Could not create target sample for band '%s'.", targetRaster.getName()));
    }

    private Tile[] getSourceTiles(Rectangle region) {
        Tile[] sourceTiles = new Tile[this.sourceRasters.length];
        for (int i = 0; i < sourceTiles.length; ++i) {
            if (this.sourceRasters[i] == null) continue;
            sourceTiles[i] = this.getSourceTile(this.sourceRasters[i], region);
        }
        return sourceTiles;
    }

    private Tile getSourceMaskTile(Rectangle region) {
        if (this.validPixelMask != null) {
            return this.getSourceTile((RasterDataNode)this.validPixelMask, region);
        }
        return null;
    }

    private Tile[] getTargetTiles(Map<Band, Tile> targetTileStack) {
        Tile[] targetTiles = new Tile[this.targetBands.length];
        for (int i = 0; i < targetTiles.length; ++i) {
            if (this.targetBands[i] == null) continue;
            Tile targetTile = targetTileStack.get(this.targetBands[i]);
            if (targetTile == null) {
                String msgPattern = "Could not find tile for defined target node '%s'.";
                throw new IllegalStateException(String.format("Could not find tile for defined target node '%s'.", this.targetBands[i].getName()));
            }
            targetTiles[i] = targetTile;
        }
        return targetTiles;
    }

    private static WritableSampleImpl[] createDefaultSamples(RasterDataNode[] nodes, Tile[] tiles, Point location) {
        WritableSampleImpl[] samples = new WritableSampleImpl[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            samples[i] = nodes[i] != null ? new WritableSampleImpl(i, tiles[i], location) : WritableSampleImpl.NULL;
        }
        return samples;
    }

    private static final class ProductConfigurerImpl
    implements ProductConfigurer {
        private Product sourceProduct;
        private final Product targetProduct;

        private ProductConfigurerImpl(Product sourceProduct, Product targetProduct) {
            this.sourceProduct = sourceProduct;
            this.targetProduct = targetProduct;
        }

        @Override
        public Product getSourceProduct() {
            return this.sourceProduct;
        }

        @Override
        public void setSourceProduct(Product sourceProduct) {
            this.sourceProduct = sourceProduct;
        }

        @Override
        public Product getTargetProduct() {
            return this.targetProduct;
        }

        @Override
        public void copyMetadata() {
            ProductUtils.copyMetadata((Product)this.getSourceProduct(), (Product)this.getTargetProduct());
        }

        @Override
        public void copyTimeCoding() {
            this.getTargetProduct().setStartTime(this.getSourceProduct().getStartTime());
            this.getTargetProduct().setEndTime(this.getSourceProduct().getEndTime());
        }

        @Override
        public void copyGeoCoding() {
            ProductUtils.copyGeoCoding((Product)this.getSourceProduct(), (Product)this.getTargetProduct());
        }

        @Override
        public void copyMasks() {
            ProductUtils.copyMasks((Product)this.getSourceProduct(), (Product)this.getTargetProduct());
        }

        @Override
        public void copyBands(String ... names) {
            if (names.length == 0) {
                names = this.getSourceProduct().getBandNames();
            }
            for (String name : names) {
                this.copyBand(name);
            }
        }

        @Override
        public void copyBands(ProductNodeFilter<Band> filter) {
            Band[] sourceBands;
            for (Band sourceBand : sourceBands = this.getSourceProduct().getBands()) {
                if (!filter.accept((ProductNode)sourceBand)) continue;
                this.copyBand(sourceBand.getName());
            }
        }

        @Override
        public void copyTiePointGrids(String ... names) {
            if (names.length == 0) {
                names = this.getSourceProduct().getTiePointGridNames();
            }
            for (String name : names) {
                ProductUtils.copyTiePointGrid((String)name, (Product)this.getSourceProduct(), (Product)this.getTargetProduct());
            }
        }

        @Override
        public void copyVectorData() {
            ProductUtils.copyVectorData((Product)this.getSourceProduct(), (Product)this.getTargetProduct());
        }

        @Override
        public Band addBand(String name, int dataType) {
            return this.getTargetProduct().addBand(name, dataType);
        }

        @Override
        public Band addBand(String name, int dataType, double noDataValue) {
            Band band = this.addBand(name, dataType);
            band.setNoDataValue(noDataValue);
            band.setNoDataValueUsed(true);
            return band;
        }

        @Override
        public Band addBand(String name, String expression) {
            return this.getTargetProduct().addBand(name, expression);
        }

        @Override
        public Band addBand(String name, String expression, double noDataValue) {
            Band band = this.addBand(name, expression);
            band.setNoDataValue(noDataValue);
            band.setNoDataValueUsed(true);
            return band;
        }

        private void copyBand(String name) {
            ProductUtils.copyBand((String)name, (Product)this.getSourceProduct(), (Product)this.getTargetProduct(), (boolean)true);
        }
    }

    private final class TargetSampleConfigurerImpl
    extends AbstractSampleConfigurer<Band>
    implements TargetSampleConfigurer {
        private TargetSampleConfigurerImpl() {
        }

        @Override
        public void defineSample(int index, String name) {
            this.addRaster(index, name, PointOperator.this.getTargetProduct(), true);
        }

        Band[] getRasters() {
            return this.rasters.toArray(new Band[this.rasters.size()]);
        }
    }

    private final class SourceSampleConfigurerImpl
    extends AbstractSampleConfigurer<RasterDataNode>
    implements SourceSampleConfigurer {
        final List<RasterDataNode> computedRasters = new ArrayList<RasterDataNode>();

        private SourceSampleConfigurerImpl() {
        }

        @Override
        public void defineSample(int index, String name) {
            this.addRaster(index, name, PointOperator.this.getSourceProduct(), false);
        }

        @Override
        public void defineSample(int index, String name, Product product) {
            super.addRaster(index, name, product, false);
        }

        @Override
        public void defineComputedSample(int index, int dataType, String expression, Product ... sourceProducts) {
            VirtualBand virtualBand = new VirtualBand("__virtual_band_" + index, dataType, PointOperator.this.getSourceProduct().getSceneRasterWidth(), PointOperator.this.getSourceProduct().getSceneRasterHeight(), expression);
            if (sourceProducts.length > 1) {
                virtualBand.setSourceImage(this.createVirtualImage(dataType, expression, sourceProducts));
            }
            this.defineComputedSample(index, (RasterDataNode)virtualBand);
        }

        private MultiLevelImage createVirtualImage(final int dataType, String expression, Product[] sourceProducts) {
            for (Product sourceProduct : sourceProducts) {
                if (sourceProduct.getRefNo() != 0) continue;
                throw new IllegalArgumentException(String.format("Product '%s' has no assigned reference number.", sourceProduct.getName()));
            }
            final Term term = VirtualBandOpImage.parseExpression((String)expression, (int)0, (Product[])sourceProducts);
            Product contextProduct = sourceProducts[0];
            final Dimension sourceSize = contextProduct.getSceneRasterSize();
            final Dimension tileSize = contextProduct.getPreferredTileSize();
            MultiLevelModel multiLevelModel = contextProduct.createMultiLevelModel();
            AbstractMultiLevelSource multiLevelSource = new AbstractMultiLevelSource(multiLevelModel){

                public RenderedImage createImage(int level) {
                    return VirtualBandOpImage.builder((Term)term).dataType(dataType).sourceSize(sourceSize).tileSize(tileSize).level(ResolutionLevel.create((MultiLevelModel)this.getModel(), (int)level)).create();
                }
            };
            return new DefaultMultiLevelImage((MultiLevelSource)multiLevelSource);
        }

        @Override
        public void defineComputedSample(int index, int sourceIndex, Kernel kernel) {
            RasterDataNode sourceNode = this.getSourceNode(sourceIndex);
            this.defineComputedSample(index, (RasterDataNode)new ConvolutionFilterBand("__convolution_filter_band_" + index, sourceNode, kernel, 1));
        }

        @Override
        public void defineComputedSample(int index, int sourceIndex, GeneralFilterBand.OpType opType, Kernel structuringElement) {
            RasterDataNode sourceNode = this.getSourceNode(sourceIndex);
            this.defineComputedSample(index, (RasterDataNode)new GeneralFilterBand("__general_filter_band_" + index, sourceNode, opType, structuringElement, 1));
        }

        @Override
        public void defineComputedSample(int index, RasterDataNode raster) {
            Assert.argument((raster != PointOperator.this.getTargetProduct().getRasterDataNode(raster.getName()) ? 1 : 0) != 0, (String)"raster must not be component of target product");
            if (raster.getOwner() == null) {
                raster.setOwner((ProductNode)PointOperator.this.getSourceProduct());
            }
            this.addRaster(index, raster);
            this.computedRasters.add(raster);
        }

        @Override
        public void setValidPixelMask(String maskExpression) {
            if (maskExpression == null || maskExpression.trim().isEmpty()) {
                return;
            }
            Assert.state((PointOperator.this.validPixelMask == null ? 1 : 0) != 0, (String)"valid pixel mask already defined");
            if (!PointOperator.this.getSourceProduct().isCompatibleBandArithmeticExpression(maskExpression)) {
                String msg = String.format("The valid-pixel mask expression '%s' can not be used with the source product.", maskExpression);
                throw new OperatorException(msg);
            }
            PointOperator.this.validPixelMask = Mask.BandMathsType.create((String)"__source_mask", null, (int)PointOperator.this.getSourceProduct().getSceneRasterWidth(), (int)PointOperator.this.getSourceProduct().getSceneRasterHeight(), (String)maskExpression, (Color)Color.GREEN, (double)0.0);
            PointOperator.this.validPixelMask.setOwner((ProductNode)PointOperator.this.getSourceProduct());
            this.computedRasters.add((RasterDataNode)PointOperator.this.validPixelMask);
        }

        RasterDataNode[] getComputeNodes() {
            return this.computedRasters.toArray(new RasterDataNode[this.computedRasters.size()]);
        }

        private RasterDataNode getSourceNode(int index) {
            Assert.argument((this.rasters.get(index) != null ? 1 : 0) != 0, (String)String.format("no source raster defined at index %s", index));
            return (RasterDataNode)this.rasters.get(index);
        }
    }

    private static abstract class AbstractSampleConfigurer<T extends RasterDataNode> {
        final List<T> rasters = new ArrayList<T>();

        private AbstractSampleConfigurer() {
        }

        void addRaster(int index, String name, Product product, boolean sourceless) throws OperatorException {
            RasterDataNode node = product.getRasterDataNode(name);
            if (node == null) {
                String message = String.format("Product '%s' does not contain a raster with name '%s'", product.getName(), name);
                throw new OperatorException(message);
            }
            this.addRaster(index, node, sourceless);
        }

        void addRaster(int index, T raster, boolean sourceless) throws OperatorException {
            String name = raster.getName();
            if (sourceless && raster.isSourceImageSet()) {
                String message = String.format("Raster '%s' must be sourceless, since it is a computed target", name);
                throw new OperatorException(message);
            }
            this.addRaster(index, raster);
        }

        void addRaster(int index, T raster) {
            Assert.notNull(raster, (String)"raster");
            Assert.argument((index >= 0 ? 1 : 0) != 0, (String)("index >= 0, was " + index));
            if (index < this.rasters.size()) {
                Assert.state((this.rasters.get(index) == null ? 1 : 0) != 0, (String)String.format("raster at index %d already defined", index));
                this.rasters.set(index, raster);
            } else if (index == this.rasters.size()) {
                this.rasters.add(raster);
            } else {
                while (index > this.rasters.size()) {
                    this.rasters.add(null);
                }
                this.rasters.add(raster);
            }
        }

        RasterDataNode[] getRasters() {
            return this.rasters.toArray(new RasterDataNode[this.rasters.size()]);
        }
    }

    private static final class WritableSampleImpl
    implements WritableSample {
        static final WritableSampleImpl NULL = new WritableSampleImpl();
        private final int index;
        private final RasterDataNode node;
        private final int dataType;
        private final Tile tile;
        private final Point location;

        private WritableSampleImpl(int index, Tile tile, Point location) {
            this.index = index;
            this.node = tile.getRasterDataNode();
            this.dataType = this.node.getGeophysicalDataType();
            this.tile = tile;
            this.location = location;
        }

        private WritableSampleImpl() {
            this.index = -1;
            this.node = null;
            this.dataType = -1;
            this.tile = null;
            this.location = null;
        }

        @Override
        public RasterDataNode getNode() {
            return this.node;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public int getDataType() {
            return this.dataType;
        }

        @Override
        public boolean getBit(int bitIndex) {
            return this.tile.getSampleBit(this.location.x, this.location.y, bitIndex);
        }

        @Override
        public boolean getBoolean() {
            return this.tile.getSampleBoolean(this.location.x, this.location.y);
        }

        @Override
        public int getInt() {
            return this.tile.getSampleInt(this.location.x, this.location.y);
        }

        @Override
        public float getFloat() {
            return this.tile.getSampleFloat(this.location.x, this.location.y);
        }

        @Override
        public double getDouble() {
            return this.tile.getSampleDouble(this.location.x, this.location.y);
        }

        @Override
        public void set(int bitIndex, boolean v) {
            this.tile.setSample(this.location.x, this.location.y, bitIndex, v);
        }

        @Override
        public void set(boolean v) {
            this.tile.setSample(this.location.x, this.location.y, v);
        }

        @Override
        public void set(int v) {
            this.tile.setSample(this.location.x, this.location.y, v);
        }

        @Override
        public void set(float v) {
            this.tile.setSample(this.location.x, this.location.y, v);
        }

        @Override
        public void set(double v) {
            this.tile.setSample(this.location.x, this.location.y, v);
        }
    }
}

