/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.internal;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.TargetProduct;

@OperatorMetadata(alias="MoreThenAnIntegerOp", category="Raster/Testing", internal=true, description="just for testing")
public class MoreThenAnIntegerOp
extends Operator {
    @TargetProduct
    private Product targetProduct;
    private static final String PRODUCT_TYPE = "Dummy";

    @Override
    public void initialize() throws OperatorException {
        try {
            int targetImageWidth = 53568;
            int targetImageHeight = 50000;
            this.targetProduct = new Product("MoreThenAnInteger", PRODUCT_TYPE, targetImageWidth, targetImageHeight);
            this.targetProduct.addBand("dummy", 10);
        }
        catch (Throwable e) {
            throw new OperatorException(e);
        }
    }

    @Override
    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        Rectangle tileRectangle = targetTile.getRectangle();
        int x0 = tileRectangle.x;
        int y0 = tileRectangle.y;
        int xMax = x0 + tileRectangle.width;
        int yMax = y0 + tileRectangle.height;
        ProductData targetBuffer = targetTile.getDataBuffer();
        TileIndex targetIndex = new TileIndex(targetTile);
        for (int y = y0; y < yMax; ++y) {
            targetIndex.calculateStride(y);
            for (int x = x0; x < xMax; ++x) {
                int targetIdx = targetIndex.getIndex(x);
                targetBuffer.setElemDoubleAt(targetIdx, (double)(x % 127));
            }
        }
    }

    private static final class TileIndex {
        private final int tileOffset;
        private final int tileStride;
        private final int tileMinX;
        private final int tileMinY;
        private int offset = 0;

        public TileIndex(Tile tile) {
            this.tileOffset = tile.getScanlineOffset();
            this.tileStride = tile.getScanlineStride();
            this.tileMinX = tile.getMinX();
            this.tileMinY = tile.getMinY();
        }

        public int calculateStride(int ty) {
            this.offset = this.tileMinX - ((ty - this.tileMinY) * this.tileStride + this.tileOffset);
            return this.offset;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getIndex(int tx) {
            return tx - this.offset;
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(MoreThenAnIntegerOp.class);
        }
    }
}

