/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.internal;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.util.ProductUtils;

public class JaiHelper {
    public static final Interpolation DEFAULT_INTERPOLATION = Interpolation.getInstance((int)0);

    public static Product createTargetProduct(Product sourceProduct, String[] bandNames, String operationName, HashMap<String, Object> operationParameters, RenderingHints renderingHints) throws OperatorException {
        if (operationName == null) {
            throw new OperatorException("Missing parameter 'operationName'.");
        }
        if (operationParameters == null) {
            operationParameters = new HashMap(0);
        }
        if (renderingHints == null) {
            renderingHints = new RenderingHints(JAI.KEY_INTERPOLATION, DEFAULT_INTERPOLATION);
        } else if (!renderingHints.containsKey(JAI.KEY_INTERPOLATION)) {
            renderingHints.put(JAI.KEY_INTERPOLATION, DEFAULT_INTERPOLATION);
        }
        Band[] sourceBands = JaiHelper.getBands(sourceProduct, bandNames);
        TiePointGrid[] tiePointGrids = JaiHelper.getTiePointGrids(sourceProduct, bandNames);
        if (sourceBands.length == 0 && tiePointGrids.length == 0) {
            return new Product("jai", "jai", 0, 0);
        }
        RenderedOp[] bandRenderedOps = new RenderedOp[sourceBands.length];
        int maxWidth = -1;
        int maxHeight = -1;
        for (int i = 0; i < sourceBands.length; ++i) {
            bandRenderedOps[i] = JaiHelper.createTargetImage((RasterDataNode)sourceBands[i], operationName, operationParameters, renderingHints);
            if (bandRenderedOps[i].getWidth() > maxWidth) {
                maxWidth = bandRenderedOps[i].getWidth();
            }
            if (bandRenderedOps[i].getHeight() <= maxHeight) continue;
            maxHeight = bandRenderedOps[i].getHeight();
        }
        Product targetProduct = new Product("jai", "jai", maxWidth, maxHeight);
        for (int i = 0; i < sourceBands.length; ++i) {
            Band sourceBand = sourceBands[i];
            Band targetBand = new Band(sourceBand.getName(), sourceBand.getDataType(), bandRenderedOps[i].getWidth(), bandRenderedOps[i].getHeight());
            ProductUtils.copyRasterDataNodeProperties((RasterDataNode)sourceBand, (RasterDataNode)targetBand);
            targetProduct.addBand(targetBand);
            targetBand.setSourceImage((RenderedImage)bandRenderedOps[i]);
        }
        for (TiePointGrid sourceGrid : tiePointGrids) {
            Band targetBand = new Band(sourceGrid.getName(), sourceGrid.getDataType(), maxWidth, maxHeight);
            ProductUtils.copyRasterDataNodeProperties((RasterDataNode)sourceGrid, (RasterDataNode)targetBand);
            targetBand.setSourceImage((RenderedImage)JaiHelper.createTargetImage((RasterDataNode)sourceGrid, operationName, operationParameters, renderingHints));
            targetProduct.addBand(targetBand);
        }
        return targetProduct;
    }

    private static TiePointGrid[] getTiePointGrids(Product sourceProduct, String[] names) {
        TiePointGrid[] tiePointGrids = sourceProduct.getTiePointGrids();
        if (names != null && names.length > 0) {
            ArrayList<TiePointGrid> tiePointGridList = new ArrayList<TiePointGrid>(sourceProduct.getNumBands());
            for (String name : names) {
                TiePointGrid tiePointGrid = sourceProduct.getTiePointGrid(name);
                if (tiePointGrid == null) continue;
                tiePointGridList.add(tiePointGrid);
            }
            tiePointGrids = tiePointGridList.toArray(new TiePointGrid[tiePointGridList.size()]);
        }
        return tiePointGrids;
    }

    private static Band[] getBands(Product product, String[] names) {
        Band[] bands = product.getBands();
        if (names != null && names.length > 0) {
            ArrayList<Band> sourceBandList = new ArrayList<Band>(product.getNumBands());
            for (String name : names) {
                Band band = product.getBand(name);
                if (band == null) continue;
                sourceBandList.add(band);
            }
            bands = sourceBandList.toArray(new Band[sourceBandList.size()]);
        }
        return bands;
    }

    public static RenderedOp createTargetImage(RasterDataNode sourceBand, String operationName, HashMap<String, Object> operationParameters, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlock = new ParameterBlockJAI(operationName);
        parameterBlock.addSource((Object)sourceBand.getSourceImage());
        for (Map.Entry<String, Object> parameter : operationParameters.entrySet()) {
            try {
                parameterBlock.setParameter(parameter.getKey(), parameter.getValue());
            }
            catch (IllegalArgumentException e) {
                throw new OperatorException(MessageFormat.format("Illegal parameter ''{0}'' for JAI operation ''{1}''.", parameter.getKey(), operationName), e);
            }
        }
        try {
            return JAI.create((String)operationName, (ParameterBlock)parameterBlock, (RenderingHints)renderingHints);
        }
        catch (Exception e) {
            throw new OperatorException(MessageFormat.format("Illegal source or parameters for JAI operation ''{0}''.", operationName), e);
        }
    }
}

