/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.graph;

import com.bc.ceres.core.Assert;
import java.io.File;
import java.lang.reflect.Field;
import javax.media.jai.PlanarImage;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.OperatorSpiRegistry;
import org.esa.snap.core.gpf.graph.GraphContext;
import org.esa.snap.core.gpf.graph.GraphException;
import org.esa.snap.core.gpf.graph.Node;
import org.esa.snap.core.gpf.internal.OperatorConfiguration;
import org.esa.snap.core.gpf.internal.OperatorContext;
import org.esa.snap.runtime.Config;

public class NodeContext {
    private final GraphContext graphContext;
    private final Node node;
    private Operator operator;
    private OperatorContext operatorContext;
    private int referenceCount;
    private Product targetProduct;

    NodeContext(GraphContext graphContext, Node node) throws GraphException {
        this.graphContext = graphContext;
        this.node = node;
        this.initOperator();
        this.initOperatorContext();
    }

    public GraphContext getGraphContext() {
        return this.graphContext;
    }

    public Node getNode() {
        return this.node;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public boolean isOutput() {
        return this.referenceCount == 0;
    }

    void incrementReferenceCount() {
        ++this.referenceCount;
    }

    public void initTargetProduct() throws GraphException {
        try {
            this.targetProduct = this.operator.getTargetProduct();
        }
        catch (OperatorException e) {
            throw new GraphException("[NodeId: " + this.node.getId() + "] " + e.getMessage(), e);
        }
    }

    public Product getTargetProduct() {
        Assert.notNull((Object)this.targetProduct, (String)"targetProduct");
        return this.targetProduct;
    }

    PlanarImage getTargetImage(Band band) {
        return this.operatorContext.getTargetImage(band);
    }

    public boolean canComputeTileStack() {
        return this.operatorContext.getOperator().canComputeTileStack();
    }

    public boolean isInitialized() {
        return this.operatorContext.isInitialized();
    }

    public void setComputingStack(boolean computingStack) {
        this.operatorContext.setComputingStack(computingStack);
    }

    public void addSourceProduct(String id, Product sourceProduct) {
        this.operator.setSourceProduct(id, sourceProduct);
    }

    public void setOperatorConfiguration(OperatorConfiguration opConfiguration) {
        this.operatorContext.setConfiguration(opConfiguration);
    }

    public Product getSourceProduct(String id) {
        return this.operator.getSourceProduct(id);
    }

    public Product[] getSourceProducts() {
        return this.operator.getSourceProducts();
    }

    private void initOperator() throws GraphException {
        OperatorSpiRegistry spiRegistry = GPF.getDefaultInstance().getOperatorSpiRegistry();
        OperatorSpi operatorSpi = spiRegistry.getOperatorSpi(this.node.getOperatorName());
        if (operatorSpi == null) {
            Object msg = Config.instance().preferences().get("snap.gpf.unsupported." + this.node.getOperatorName(), null);
            if (msg == null) {
                msg = "SPI not found for operator '" + this.node.getOperatorName() + "'";
            }
            throw new GraphException((String)msg);
        }
        try {
            this.operator = operatorSpi.createOperator();
            this.operator.setLogger(this.graphContext.getLogger());
        }
        catch (OperatorException e) {
            throw new GraphException("Failed to create instance of operator '" + this.node.getOperatorName() + "'", e);
        }
    }

    private void initOperatorContext() {
        try {
            Field field = Operator.class.getDeclaredField("context");
            field.setAccessible(true);
            this.operatorContext = (OperatorContext)field.get(this.operator);
            this.operatorContext.setId(this.node.getId());
            field.setAccessible(false);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    private static boolean isProductOpened(ProductManager productManager, Product targetProduct) {
        Product[] openedProducts;
        if (productManager.contains(targetProduct)) {
            return true;
        }
        File file = targetProduct.getFileLocation();
        if (file == null) {
            return false;
        }
        for (Product openedProduct : openedProducts = productManager.getProducts()) {
            if (!file.equals(openedProduct.getFileLocation())) continue;
            return true;
        }
        return false;
    }

    public synchronized void dispose() {
        if (!(this.targetProduct == null || this.operator != null && NodeContext.isProductOpened(this.operator.getProductManager(), this.targetProduct))) {
            this.targetProduct.dispose();
            this.targetProduct = null;
        }
        if (this.operatorContext != null && !this.operatorContext.isDisposed()) {
            this.operatorContext.dispose();
            this.operatorContext = null;
            this.operator = null;
        }
    }
}

