/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.graph;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.graph.Graph;
import org.esa.snap.core.gpf.graph.GraphContext;
import org.esa.snap.core.gpf.graph.GraphException;
import org.esa.snap.core.gpf.graph.Header;
import org.esa.snap.core.gpf.graph.HeaderParameter;
import org.esa.snap.core.gpf.graph.HeaderTarget;
import org.esa.snap.core.gpf.graph.Node;
import org.esa.snap.core.gpf.graph.NodeContext;
import org.esa.snap.core.gpf.internal.OperatorContext;

@OperatorMetadata(alias="Graph", description="Encapsulates a graph into an operator.", internal=true)
public class GraphOp
extends Operator {
    @Override
    public void initialize() throws OperatorException {
        try {
            Graph graph = ((Spi)this.getSpi()).graph;
            OperatorContext operatorContext = this.getOperatorContext();
            this.setOperatorParameters(graph, operatorContext);
            NodeContext targetNodeContext = this.getTargetNodeContext(graph);
            if (targetNodeContext == null) {
                throw new OperatorException("No target node found...");
            }
            this.setTargetProduct(targetNodeContext.getOperator().getTargetProduct());
        }
        catch (GraphException e) {
            throw new OperatorException(e);
        }
    }

    private void setOperatorParameters(Graph graph, OperatorContext operatorContext) {
        Map<String, Object> parameters = operatorContext.getParameterMap();
        if (parameters == null) {
            parameters = new HashMap<String, Object>();
        }
        List<HeaderParameter> parameters1 = graph.getHeader().getParameters();
        for (HeaderParameter headerParameter : parameters1) {
        }
        this.fillMapFromConfiguration(parameters);
        operatorContext.setParameterMap(parameters);
    }

    private void fillMapFromConfiguration(Map<String, Object> parameters) {
    }

    private NodeContext getTargetNodeContext(Graph graph) throws GraphException {
        GraphContext graphContext = new GraphContext(graph, this);
        NodeContext targetNodeContext = null;
        Header header = graph.getHeader();
        if (header != null) {
            HeaderTarget headerTarget = header.getTarget();
            Node targetNode = graph.getNode(headerTarget.getNodeId());
            for (Node node : graph.getNodes()) {
                if (node != targetNode) continue;
                targetNodeContext = graphContext.getNodeContext(node);
                break;
            }
        }
        return targetNodeContext;
    }

    private OperatorContext getOperatorContext() {
        OperatorContext operatorContext;
        try {
            Field field = Operator.class.getDeclaredField("context");
            field.setAccessible(true);
            operatorContext = (OperatorContext)field.get(this);
            field.setAccessible(false);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
        return operatorContext;
    }

    public static abstract class Spi
    extends OperatorSpi {
        private final Graph graph;

        public Spi(Graph graph) {
            super(GraphOp.class, graph.getId());
            this.graph = graph;
        }
    }
}

