/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.graph;

import com.bc.ceres.binding.dom.DomElement;
import com.bc.ceres.binding.dom.DomElementXStreamConverter;
import com.bc.ceres.util.TemplateReader;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import java.util.TreeMap;
import org.esa.snap.core.gpf.graph.Graph;
import org.esa.snap.core.gpf.graph.GraphException;
import org.esa.snap.core.gpf.graph.Header;
import org.esa.snap.core.gpf.graph.HeaderParameter;
import org.esa.snap.core.gpf.graph.HeaderSource;
import org.esa.snap.core.gpf.graph.HeaderTarget;
import org.esa.snap.core.gpf.graph.Node;
import org.esa.snap.core.gpf.graph.SourceList;
import org.esa.snap.core.gpf.internal.ApplicationData;
import org.esa.snap.core.util.StringUtils;

public class GraphIO {
    public static void write(Graph graph, Writer writer) {
        XStream xStream = GraphIO.initXstream();
        xStream.toXML((Object)graph, writer);
    }

    public static Graph read(Reader reader) throws GraphException {
        return GraphIO.read(reader, null);
    }

    public static Graph read(Reader reader, Map<String, String> variables) throws GraphException {
        Graph graph;
        XStream xStream = GraphIO.initXstream();
        Reader inputReader = reader;
        if (variables != null) {
            GraphIO.addSourceProductsVariable(variables);
            inputReader = new TemplateReader(reader, variables);
        }
        if ((graph = (Graph)xStream.fromXML(inputReader)).getVersion() == null) {
            throw new GraphException("No version is specified in the graph XML.");
        }
        if (!"1.0".equals(graph.getVersion())) {
            throw new GraphException("Wrong version given in the graph XML. Given version: " + graph.getVersion() + " Current version: 1.0");
        }
        return graph;
    }

    static void addSourceProductsVariable(Map<String, String> variables) {
        TreeMap<Integer, String> indexToEntry = new TreeMap<Integer, String>();
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            int index;
            String key = entry.getKey();
            if (!key.matches("sourceProduct[0-9]+") || indexToEntry.containsKey(index = Integer.parseInt(key.substring(13)))) continue;
            indexToEntry.put(index, entry.getValue());
        }
        variables.put("sourceProducts", StringUtils.arrayToCsv((Object)indexToEntry.values().toArray()));
    }

    private static XStream initXstream() {
        XStream xStream = new XStream();
        xStream.setClassLoader(GraphIO.class.getClassLoader());
        xStream.alias("graph", Graph.class);
        xStream.useAttributeFor(Graph.class, "id");
        xStream.addImplicitCollection(Graph.class, "nodeList", Node.class);
        xStream.alias("header", Header.class);
        xStream.alias("target", HeaderTarget.class);
        xStream.useAttributeFor(HeaderTarget.class, "nodeId");
        xStream.aliasAttribute(HeaderTarget.class, "nodeId", "refid");
        xStream.addImplicitCollection(Header.class, "sources", "source", HeaderSource.class);
        xStream.registerConverter((Converter)new HeaderSource.Converter());
        xStream.addImplicitCollection(Header.class, "parameters", "parameter", HeaderParameter.class);
        xStream.registerConverter((Converter)new HeaderParameter.Converter());
        xStream.alias("node", Node.class);
        xStream.aliasField("operator", Node.class, "operatorName");
        xStream.useAttributeFor(Node.class, "id");
        xStream.alias("sources", SourceList.class);
        xStream.aliasField("sources", Node.class, "sourceList");
        xStream.registerConverter((Converter)new SourceList.Converter());
        xStream.alias("parameters", DomElement.class);
        xStream.aliasField("parameters", Node.class, "configuration");
        xStream.registerConverter((Converter)new DomElementXStreamConverter());
        xStream.alias("applicationData", ApplicationData.class);
        xStream.addImplicitCollection(Graph.class, "applicationData", ApplicationData.class);
        xStream.registerConverter((Converter)new ApplicationData.AppConverter());
        xStream.allowTypesByWildcard(new String[]{"com.bc.ceres.**", "org.esa.snap.core.gpf.**"});
        return xStream;
    }

    private GraphIO() {
    }
}

