/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.descriptor;

import com.bc.ceres.core.Assert;
import org.esa.snap.core.gpf.annotations.TargetProperty;
import org.esa.snap.core.gpf.descriptor.TargetPropertyDescriptor;

public class AnnotationTargetPropertyDescriptor
implements TargetPropertyDescriptor {
    private final String name;
    private final Class<?> dataType;
    private final TargetProperty annotation;

    public AnnotationTargetPropertyDescriptor(String name, Class<?> dataType, TargetProperty annotation) {
        Assert.notNull((Object)name, (String)"name");
        Assert.notNull(dataType, (String)"dataType");
        Assert.notNull((Object)annotation, (String)"annotation");
        this.name = name;
        this.dataType = dataType;
        this.annotation = annotation;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getDataType() {
        return this.dataType;
    }

    public TargetProperty getAnnotation() {
        return this.annotation;
    }

    @Override
    public String getAlias() {
        return AnnotationTargetPropertyDescriptor.getNonEmptyStringOrNull(this.annotation.alias());
    }

    @Override
    public String getLabel() {
        return AnnotationTargetPropertyDescriptor.getNonEmptyStringOrNull(this.annotation.label());
    }

    @Override
    public String getDescription() {
        return AnnotationTargetPropertyDescriptor.getNonEmptyStringOrNull(this.annotation.description());
    }

    private static String getNonEmptyStringOrNull(String label) {
        return label == null || label.isEmpty() ? null : label;
    }
}

