/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common.support;

import org.esa.snap.core.dataio.ProductFlipper;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;

public class ProductFlipperExt
extends ProductFlipper {
    public ProductFlipperExt(int flipType, boolean sourceProductOwner) {
        super(flipType, sourceProductOwner);
    }

    protected void addMetadataToProduct(Product product) {
        super.addMetadataToProduct(product);
        this.updateTargetProductMetadata(product);
    }

    private void updateTargetProductMetadata(Product targetProduct) {
        try {
            int flipType = this.getFlipType();
            if (flipType == 2 || flipType == 3) {
                MetadataAttribute lineTimeIntervalAttr;
                ProductData.UTC lastLineTime;
                MetadataAttribute lastLineTimeAttr;
                ProductData.UTC firstLineTime;
                MetadataElement rootTgt = targetProduct.getMetadataRoot();
                if (rootTgt == null) {
                    return;
                }
                MetadataElement absTgt = rootTgt.getElement("Abstracted_Metadata");
                if (absTgt == null) {
                    return;
                }
                MetadataElement rootSrc = this.sourceProduct.getMetadataRoot();
                if (rootSrc == null) {
                    return;
                }
                MetadataElement absSrc = rootSrc.getElement("Abstracted_Metadata");
                if (absSrc == null) {
                    return;
                }
                MetadataAttribute firstLineTimeAttr = absSrc.getAttribute("first_line_time");
                if (firstLineTimeAttr != null && (firstLineTime = ProductData.UTC.parse((String)firstLineTimeAttr.getData().getElemString())) != null) {
                    absTgt.getAttribute("last_line_time").getData().setElems((Object)firstLineTime.getArray());
                }
                if ((lastLineTimeAttr = absSrc.getAttribute("last_line_time")) != null && (lastLineTime = ProductData.UTC.parse((String)lastLineTimeAttr.getData().getElemString())) != null) {
                    absTgt.getAttribute("first_line_time").getData().setElems((Object)lastLineTime.getArray());
                }
                if ((lineTimeIntervalAttr = absSrc.getAttribute("line_time_interval")) != null) {
                    double lineTimeInterval = lineTimeIntervalAttr.getData().getElemDouble();
                    absTgt.getAttribute("line_time_interval").getData().setElemDouble(-lineTimeInterval);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

