/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common.resample;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ServiceRegistry;
import com.bc.ceres.core.ServiceRegistryListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.esa.snap.core.gpf.common.resample.UpsamplerSpi;
import org.esa.snap.core.gpf.common.resample.UpsamplerSpiRegistry;
import org.esa.snap.core.util.ServiceLoader;
import org.esa.snap.core.util.SystemUtils;

public class UpsamplerSpiRegistryImpl
implements UpsamplerSpiRegistry {
    private final ServiceRegistry<UpsamplerSpi> serviceRegistry;
    private final Map<String, String> classNames;
    private final Map<String, UpsamplerSpi> extraUpsamplerSpis;

    public UpsamplerSpiRegistryImpl(ServiceRegistry<UpsamplerSpi> serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
        this.classNames = new ConcurrentHashMap<String, String>(20);
        this.serviceRegistry.addListener((ServiceRegistryListener)new ServiceRegistryListener<UpsamplerSpi>(){

            public void serviceAdded(ServiceRegistry<UpsamplerSpi> registry, UpsamplerSpi service) {
                UpsamplerSpiRegistryImpl.this.registerAlias(service);
            }

            public void serviceRemoved(ServiceRegistry<UpsamplerSpi> registry, UpsamplerSpi service) {
                UpsamplerSpiRegistryImpl.this.unregisterAlias(service);
            }
        });
        Set services = this.serviceRegistry.getServices();
        for (UpsamplerSpi upsamplerSpi : services) {
            this.registerAlias(upsamplerSpi);
        }
        this.extraUpsamplerSpis = new ConcurrentHashMap<String, UpsamplerSpi>();
    }

    @Override
    public void loadUpsamplerSpis() {
        ServiceLoader.loadServices(this.getServiceRegistry());
    }

    @Override
    public Set<UpsamplerSpi> getUpsamplerSpis() {
        HashSet<UpsamplerSpi> operatorSpis = new HashSet<UpsamplerSpi>(this.serviceRegistry.getServices());
        operatorSpis.addAll(this.extraUpsamplerSpis.values());
        return operatorSpis;
    }

    @Override
    public ServiceRegistry<UpsamplerSpi> getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Override
    public UpsamplerSpi getUpsamplerSpi(String alias) {
        UpsamplerSpi service = (UpsamplerSpi)this.serviceRegistry.getService(alias);
        if (service != null) {
            return service;
        }
        service = this.getName(this.extraUpsamplerSpis, alias);
        if (service != null) {
            return service;
        }
        String className = this.getName(this.classNames, alias);
        if (className != null && (service = (UpsamplerSpi)this.serviceRegistry.getService(className)) != null) {
            return service;
        }
        return null;
    }

    private <T> T getName(Map<String, T> tMap, String alias) {
        Optional<String> optional = tMap.keySet().stream().filter(p -> p.equalsIgnoreCase(alias)).findFirst();
        return optional.isPresent() ? (T)tMap.get(optional.get()) : null;
    }

    @Override
    public boolean addUpsamplerSpi(UpsamplerSpi upsamplerSpi) {
        String spiClassName = upsamplerSpi.getClass().getName();
        if (this.serviceRegistry.getService(spiClassName) == upsamplerSpi) {
            return false;
        }
        this.registerAlias(upsamplerSpi);
        return this.serviceRegistry.addService((Object)upsamplerSpi);
    }

    @Override
    public boolean addUpsamplerSpi(String alias, UpsamplerSpi upsamplerSpi) {
        if (alias.equals(upsamplerSpi.getClass().getName())) {
            return this.addUpsamplerSpi(upsamplerSpi);
        }
        if (this.extraUpsamplerSpis.get(alias) == upsamplerSpi) {
            return false;
        }
        this.registerAlias(upsamplerSpi.getClass().getName(), alias);
        this.extraUpsamplerSpis.put(alias, upsamplerSpi);
        return true;
    }

    @Override
    public boolean removeUpsamplerSpi(UpsamplerSpi upsamplerSpi) {
        if (!this.serviceRegistry.removeService((Object)upsamplerSpi)) {
            Stream extraSpiStream = this.extraUpsamplerSpis.entrySet().stream();
            Optional<Map.Entry> spiEntry = extraSpiStream.filter(entry -> entry.getValue() == upsamplerSpi).findFirst();
            if (spiEntry.isPresent() && this.extraUpsamplerSpis.remove(spiEntry.get().getKey(), spiEntry.get().getValue())) {
                this.unregisterAlias((UpsamplerSpi)spiEntry.get().getValue());
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public Set<String> getAliases() {
        return this.classNames.keySet();
    }

    private void registerAlias(String spiClassName, String aliasName) {
        Assert.notNull((Object)aliasName, (String)"aliasName");
        Assert.notNull((Object)spiClassName, (String)"spiClassName");
        if (this.classNames.get(aliasName) != null) {
            SystemUtils.LOG.severe(spiClassName + ":" + aliasName + " conflicts with " + this.classNames.get(aliasName) + ":" + aliasName);
        }
        this.classNames.put(aliasName, spiClassName);
    }

    private void registerAlias(UpsamplerSpi upsamplerSpi) {
        String alias = upsamplerSpi.getAlias();
        if (alias != null) {
            this.registerAlias(upsamplerSpi.getClass().getName(), alias);
        }
    }

    private void unregisterAlias(UpsamplerSpi upsamplerSpi) {
        String alias = upsamplerSpi.getAlias();
        if (this.classNames.remove(alias) == null) {
            String spiClassName = upsamplerSpi.getClass().getName();
            Stream stream = new HashSet<String>(this.classNames.keySet()).stream();
            stream.filter(key -> this.classNames.get(key).equals(spiClassName)).forEach(this.classNames::remove);
        }
    }
}

