/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common.resample;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.esa.snap.core.gpf.common.resample.ResamplingPreset;
import org.esa.snap.core.util.SystemUtils;

public class ResamplingPresetManager {
    private final List<ResamplingPreset> _resamplingPresets = new ArrayList<ResamplingPreset>();
    private static final File resamplingPresetsDir = SystemUtils.getAuxDataPath().resolve("resampling_presets").toFile();

    private ResamplingPresetManager() {
        this.loadDefaultResamplingPresets();
    }

    public static File getResamplingPresetsDir() {
        return resamplingPresetsDir;
    }

    public static ResamplingPresetManager getInstance() {
        return Holder.instance;
    }

    public void addResamplingPreset(ResamplingPreset preset) {
        if (preset != null && !this._resamplingPresets.contains(preset)) {
            this._resamplingPresets.add(preset);
        }
    }

    public void removeResamplingPreset(ResamplingPreset preset) {
        if (preset != null) {
            this._resamplingPresets.remove(preset);
        }
    }

    public int getResamplingPresetCount() {
        return this._resamplingPresets.size();
    }

    public ResamplingPreset getResamplingPreset(int i) {
        return this._resamplingPresets.get(i);
    }

    public ResamplingPreset getResamplingPreset(String resamplingName) {
        for (ResamplingPreset resamplingPreset : this._resamplingPresets) {
            if (!resamplingPreset.getResamplingPresetName().equals(resamplingName)) continue;
            return resamplingPreset;
        }
        return null;
    }

    public ResamplingPreset[] getAllResamplingPresets() {
        return this._resamplingPresets.toArray(new ResamplingPreset[this._resamplingPresets.size()]);
    }

    private void loadDefaultResamplingPresets() {
        File[] files;
        if (!ResamplingPresetManager.getResamplingPresetsDir().exists()) {
            resamplingPresetsDir.mkdirs();
            SystemUtils.LOG.log(Level.INFO, "Directory for Resampling presets not found: " + ResamplingPresetManager.getResamplingPresetsDir());
        }
        if ((files = ResamplingPresetManager.getResamplingPresetsDir().listFiles((dir, name) -> name.endsWith(".res") || name.endsWith(".res".toUpperCase()))) != null) {
            for (File file : files) {
                try {
                    this.addResamplingPreset(ResamplingPreset.loadResamplingPreset(file));
                }
                catch (IOException e) {
                    SystemUtils.LOG.log(Level.SEVERE, "Failed to load Resampling preset from " + file, e);
                }
            }
        } else {
            SystemUtils.LOG.log(Level.INFO, "No Resampling presets found in " + ResamplingPresetManager.getResamplingPresetsDir());
        }
    }

    static {
        if (!resamplingPresetsDir.exists()) {
            resamplingPresetsDir.mkdirs();
        }
    }

    private static class Holder {
        private static final ResamplingPresetManager instance = new ResamplingPresetManager();

        private Holder() {
        }
    }
}

