/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common.resample;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.BorderExtender;
import javax.media.jai.BorderExtenderConstant;
import javax.media.jai.GeometricOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.common.resample.Interpolator;
import org.esa.snap.core.gpf.common.resample.Upsampling;

class InterpolatedOpImage
extends GeometricOpImage {
    private final double scaleX;
    private final double scaleY;
    private final float offsetX;
    private final float offsetY;
    private final double noDataValue;
    private final int dataBufferType;
    private Upsampling upsampling;
    private RasterDataNode rasterDataNode;

    InterpolatedOpImage(RasterDataNode rasterDataNode, RenderedImage sourceImage, ImageLayout layout, double noDataValue, int dataBufferType, Upsampling upsampling, AffineTransform sourceImageToModelTransform, AffineTransform referenceImageToModelTransform) throws NoninvertibleTransformException {
        super(InterpolatedOpImage.vectorize((RenderedImage)sourceImage), layout, null, true, InterpolatedOpImage.createBorderExtender(noDataValue), null, InterpolatedOpImage.createBackground(noDataValue));
        this.rasterDataNode = rasterDataNode;
        this.noDataValue = noDataValue;
        AffineTransform transform = new AffineTransform(referenceImageToModelTransform);
        transform.concatenate(sourceImageToModelTransform.createInverse());
        this.scaleX = transform.getScaleX();
        this.scaleY = transform.getScaleY();
        this.offsetX = (float)(referenceImageToModelTransform.getTranslateX() / sourceImageToModelTransform.getScaleX()) - (float)(sourceImageToModelTransform.getTranslateX() / sourceImageToModelTransform.getScaleX());
        this.offsetY = (float)(referenceImageToModelTransform.getTranslateY() / sourceImageToModelTransform.getScaleY()) - (float)(sourceImageToModelTransform.getTranslateY() / sourceImageToModelTransform.getScaleY());
        this.upsampling = upsampling;
        this.dataBufferType = dataBufferType;
    }

    private static BorderExtender createBorderExtender(double value) {
        return new BorderExtenderConstant(new double[]{value});
    }

    private static double[] createBackground(double value) {
        return new double[]{value};
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Raster source = sources[0];
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        RasterAccessor srcAccessor = new RasterAccessor(source, srcRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor dstAccessor = new RasterAccessor((Raster)dest, destRect, formatTags[1], this.getColorModel());
        Interpolator interpolator = this.upsampling.createUpsampler(this.rasterDataNode, this.dataBufferType);
        interpolator.init(this.rasterDataNode, srcAccessor, dstAccessor, this.noDataValue);
        interpolator.interpolate(destRect, srcRect, this.scaleX, this.scaleY, this.offsetX, this.offsetY);
        if (dstAccessor.isDataCopy()) {
            dstAccessor.clampDataArrays();
            dstAccessor.copyDataToRaster();
        }
    }

    protected Rectangle forwardMapRect(Rectangle rectangle, int i) {
        int x = (int)(rectangle.getX() * (1.0 / this.scaleX) - (double)this.offsetX);
        int y = (int)(rectangle.getY() * (1.0 / this.scaleY) - (double)this.offsetY);
        int width = (int)Math.ceil((rectangle.getWidth() - 1.0) * (1.0 / this.scaleX));
        int height = (int)Math.ceil((rectangle.getHeight() - 1.0) * (1.0 / this.scaleY));
        return new Rectangle(x, y, width, height);
    }

    public Rectangle mapDestRect(Rectangle destRect, int sourceIndex) {
        if (destRect == null) {
            throw new IllegalArgumentException("destRect must not be null");
        }
        if (sourceIndex >= 0 && sourceIndex < this.getNumSources()) {
            return this.backwardMapRect(destRect, sourceIndex);
        }
        throw new IllegalArgumentException("Invalid source index");
    }

    protected Rectangle backwardMapRect(Rectangle rectangle, int i) {
        int x = (int)((double)this.offsetX + rectangle.getX() * this.scaleX);
        int y = (int)((double)this.offsetY + rectangle.getY() * this.scaleY);
        int width = (int)Math.ceil(rectangle.getWidth() * this.scaleX) + 1;
        int height = (int)Math.ceil(rectangle.getHeight() * this.scaleY) + 1;
        return new Rectangle(x, y, width, height);
    }
}

