/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common.resample;

import javax.media.jai.RasterAccessor;
import org.esa.snap.core.gpf.common.resample.DataAccessor;

abstract class DoubleDataAccessor
implements DataAccessor {
    DoubleDataAccessor() {
    }

    abstract double getSrcData(int var1);

    abstract void setDstData(int var1, double var2);

    abstract double getNoDataValue();

    static class Float
    extends DoubleDataAccessor {
        private final double noDataValue;
        private final float[] dstArray;
        private final float[] srcArray;
        private final int srcScanlineStride;
        private final int dstScanlineStride;
        private final int srcOffset;
        private final int dstOffset;

        Float(RasterAccessor srcAccessor, RasterAccessor dstAccessor, double noDataValue) {
            this.srcArray = srcAccessor.getFloatDataArray(0);
            this.dstArray = dstAccessor.getFloatDataArray(0);
            this.srcScanlineStride = srcAccessor.getScanlineStride();
            this.dstScanlineStride = dstAccessor.getScanlineStride();
            this.srcOffset = srcAccessor.getBandOffset(0);
            this.dstOffset = dstAccessor.getBandOffset(0);
            this.noDataValue = noDataValue;
        }

        @Override
        double getSrcData(int index) {
            return this.srcArray[index];
        }

        @Override
        void setDstData(int index, double value) {
            this.dstArray[index] = (float)value;
        }

        @Override
        double getNoDataValue() {
            return this.noDataValue;
        }

        @Override
        public int getSrcScalineStride() {
            return this.srcScanlineStride;
        }

        @Override
        public int getDstScalineStride() {
            return this.dstScanlineStride;
        }

        @Override
        public int getSrcOffset() {
            return this.srcOffset;
        }

        @Override
        public int getDstOffset() {
            return this.dstOffset;
        }
    }

    static class Double
    extends DoubleDataAccessor {
        private final double noDataValue;
        private final double[] dstArray;
        private final double[] srcArray;
        private final int srcScanlineStride;
        private final int dstScanlineStride;
        private final int srcOffset;
        private final int dstOffset;

        Double(RasterAccessor srcAccessor, RasterAccessor dstAccessor, double noDataValue) {
            this.srcArray = srcAccessor.getDoubleDataArray(0);
            this.dstArray = dstAccessor.getDoubleDataArray(0);
            this.srcScanlineStride = srcAccessor.getScanlineStride();
            this.dstScanlineStride = dstAccessor.getScanlineStride();
            this.srcOffset = srcAccessor.getBandOffset(0);
            this.dstOffset = dstAccessor.getBandOffset(0);
            this.noDataValue = noDataValue;
        }

        @Override
        double getSrcData(int index) {
            return this.srcArray[index];
        }

        @Override
        void setDstData(int index, double value) {
            this.dstArray[index] = value;
        }

        @Override
        double getNoDataValue() {
            return this.noDataValue;
        }

        @Override
        public int getSrcScalineStride() {
            return this.srcScanlineStride;
        }

        @Override
        public int getDstScalineStride() {
            return this.dstScanlineStride;
        }

        @Override
        public int getSrcOffset() {
            return this.srcOffset;
        }

        @Override
        public int getDstOffset() {
            return this.dstOffset;
        }
    }
}

