/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common.resample;

import javax.media.jai.RasterAccessor;
import org.esa.snap.core.gpf.common.resample.DoubleDataAccessor;
import org.esa.snap.core.gpf.common.resample.LongDataAccessor;

public class DataAccessorFactory {
    public static LongDataAccessor createLongDataAccessor(RasterAccessor srcAccessor, RasterAccessor dstAccessor, double noDataValue) {
        switch (dstAccessor.getDataType()) {
            case 0: {
                return new LongDataAccessor.Byte(srcAccessor, dstAccessor, noDataValue);
            }
            case 2: {
                return new LongDataAccessor.Short(srcAccessor, dstAccessor, noDataValue);
            }
            case 1: {
                return new LongDataAccessor.UShort(srcAccessor, dstAccessor, noDataValue);
            }
            case 3: {
                return new LongDataAccessor.Int(srcAccessor, dstAccessor, noDataValue);
            }
        }
        throw new IllegalArgumentException("Datatype not supported");
    }

    public static DoubleDataAccessor createDoubleDataAccessor(RasterAccessor srcAccessor, RasterAccessor dstAccessor, double noDataValue) {
        switch (dstAccessor.getDataType()) {
            case 4: {
                return new DoubleDataAccessor.Float(srcAccessor, dstAccessor, noDataValue);
            }
            case 5: {
                return new DoubleDataAccessor.Double(srcAccessor, dstAccessor, noDataValue);
            }
        }
        throw new IllegalArgumentException("Datatype not supported");
    }
}

