/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common.resample;

import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.common.resample.InterpolationType;
import org.esa.snap.core.gpf.common.resample.Interpolator;
import org.esa.snap.core.gpf.common.resample.InterpolatorFactory;
import org.esa.snap.core.gpf.common.resample.UpsamplerSpi;
import org.esa.snap.core.gpf.common.resample.Upsampling;

public class CubicConvolutionUpsampler
implements Upsampling {
    @Override
    public String getName() {
        return "Cubic_Convolution";
    }

    @Override
    public boolean isCompatible(RasterDataNode rasterDataNode, int dataBufferType) {
        return true;
    }

    @Override
    public Interpolator createUpsampler(RasterDataNode rasterDataNode, int dataBufferType) {
        return InterpolatorFactory.createInterpolator(InterpolationType.Cubic_Convolution, dataBufferType);
    }

    public static class Spi
    extends UpsamplerSpi {
        public Spi() {
            super(CubicConvolutionUpsampler.class, "Cubic_Convolution");
        }
    }
}

