/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.media.jai.JAI;
import javax.media.jai.TileCache;
import org.esa.snap.core.dataio.EncodeQualification;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.dataio.ProductWriter;
import org.esa.snap.core.dataio.dimap.DimapProductWriter;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.gpf.internal.OperatorExecutor;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.jai.JAIUtils;
import org.esa.snap.core.util.math.MathUtils;

@OperatorMetadata(alias="Write", category="Input-Output", version="1.3", authors="Marco Zuehlke, Norman Fomferra", copyright="(c) 2010 by Brockmann Consult", description="Writes a data product to a file.", autoWriteDisabled=true)
public class WriteOp
extends Operator {
    @TargetProduct
    private Product targetProduct;
    @SourceProduct(alias="source", description="The source product to be written.")
    private Product sourceProduct;
    @Parameter(description="The output file to which the data product is written.")
    private File file;
    @Parameter(defaultValue="BEAM-DIMAP", description="The name of the output file format.")
    private String formatName;
    @Parameter(defaultValue="true", description="If true, all output files are deleted after a failed write operation.")
    private boolean deleteOutputOnFailure = true;
    @Parameter(defaultValue="false", description="If true, the write operation waits until an entire tile row is computed.")
    private boolean writeEntireTileRows;
    @Parameter(defaultValue="false", description="If true, the internal tile cache is cleared after a tile row has been written. Ignored if writeEntireTileRows=false.")
    private boolean clearCacheAfterRowWrite;
    private boolean[][][] tilesWritten;
    private final Map<Row, Tile[]> writeCache = new HashMap<Row, Tile[]>();
    private Dimension[] tileSizes;
    private int[] tileCountsX;
    private ProductWriter productWriter;
    private List<Band> writableBands;
    private boolean outputFileExists = false;
    private boolean incremental = false;

    public WriteOp() {
        this.setParameterDefaultValues();
        this.setRequiresAllBands(true);
    }

    public WriteOp(Product sourceProduct, File file, String formatName) {
        this();
        Guardian.assertNotNull((String)"file", (Object)file);
        this.sourceProduct = sourceProduct;
        this.file = file;
        this.formatName = formatName;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getFormatName() {
        return this.formatName;
    }

    public void setIncremental(boolean incremental) {
        this.incremental = incremental;
    }

    public void setFormatName(String formatName) {
        this.formatName = formatName;
    }

    public boolean isDeleteOutputOnFailure() {
        return this.deleteOutputOnFailure;
    }

    public void setDeleteOutputOnFailure(boolean deleteOutputOnFailure) {
        this.deleteOutputOnFailure = deleteOutputOnFailure;
    }

    public boolean isWriteEntireTileRows() {
        return this.writeEntireTileRows;
    }

    public void setWriteEntireTileRows(boolean writeEntireTileRows) {
        this.writeEntireTileRows = writeEntireTileRows;
    }

    public boolean isClearCacheAfterRowWrite() {
        return this.clearCacheAfterRowWrite;
    }

    public void setClearCacheAfterRowWrite(boolean clearCacheAfterRowWrite) {
        this.clearCacheAfterRowWrite = clearCacheAfterRowWrite;
    }

    @Override
    public boolean canComputeTile() {
        return true;
    }

    @Override
    public boolean canComputeTileStack() {
        return true;
    }

    public void writeProduct(ProgressMonitor pm) {
        long startNanos = System.nanoTime();
        this.getLogger().info("Start writing product " + this.getTargetProduct().getName() + " to " + this.getFile());
        OperatorExecutor operatorExecutor = OperatorExecutor.create(this);
        try {
            if (this.clearCacheAfterRowWrite && this.writeEntireTileRows) {
                operatorExecutor.setScheduleRowsSeparate(true);
            }
            operatorExecutor.execute(OperatorExecutor.ExecutionOrder.SCHEDULE_ROW_COLUMN_BAND, "Writing...", pm);
            this.getLogger().info("End writing product " + this.getTargetProduct().getName() + " to " + this.getFile());
            double millis = (double)(System.nanoTime() - startNanos) / 1000000.0;
            double seconds = millis / 1000.0;
            int w = this.getTargetProduct().getSceneRasterWidth();
            int h = this.getTargetProduct().getSceneRasterHeight();
            this.getLogger().info(String.format("Time: %6.3f s total, %6.3f ms per line, %3.6f ms per pixel", seconds, millis / (double)h, millis / (double)h / (double)w));
            this.stopTileComputationObservation();
        }
        catch (OperatorException e) {
            if (this.deleteOutputOnFailure && !this.outputFileExists) {
                try {
                    this.productWriter.deleteOutput();
                }
                catch (Exception e2) {
                    this.getLogger().warning("Failed to delete output after failure: " + e2.getMessage());
                }
            }
            throw e;
        }
        finally {
            this.dispose();
        }
    }

    @Override
    public void initialize() throws OperatorException {
        this.targetProduct = this.sourceProduct;
        this.outputFileExists = this.targetProduct.getFileLocation() != null && this.targetProduct.getFileLocation().exists();
        this.productWriter = ProductIO.getProductWriter((String)this.formatName);
        if (this.productWriter == null) {
            throw new OperatorException("No data product writer for the '" + this.formatName + "' format available");
        }
        EncodeQualification encodeQualification = this.productWriter.getWriterPlugIn().getEncodeQualification(this.sourceProduct);
        if (encodeQualification.getPreservation() == EncodeQualification.Preservation.UNABLE) {
            throw new OperatorException("Product writer is unable to write this product as '" + this.formatName + "': " + encodeQualification.getInfoString());
        }
        this.productWriter.setIncrementalMode(this.incremental);
        this.productWriter.setFormatName(this.formatName);
        this.targetProduct.setProductWriter(this.productWriter);
    }

    private Dimension determineTileSize(Band band) {
        Dimension tileSize = null;
        if (band.getRasterWidth() == this.targetProduct.getSceneRasterWidth() && band.getRasterHeight() == this.targetProduct.getSceneRasterHeight()) {
            tileSize = this.targetProduct.getPreferredTileSize();
        }
        if (tileSize == null) {
            tileSize = JAIUtils.computePreferredTileSize((int)band.getRasterWidth(), (int)band.getRasterHeight(), (int)1);
        }
        return tileSize;
    }

    @Override
    public void doExecute(ProgressMonitor pm) {
        Band[] bands = this.targetProduct.getBands();
        this.writableBands = new ArrayList<Band>(bands.length);
        for (Band band : bands) {
            band.getSourceImage();
            if (!this.productWriter.shouldWrite((ProductNode)band)) continue;
            this.writableBands.add(band);
        }
        pm.beginTask("Preparing writing", this.writableBands.size() + 1);
        try {
            this.tileSizes = new Dimension[this.writableBands.size()];
            this.tileCountsX = new int[this.writableBands.size()];
            this.tilesWritten = new boolean[this.writableBands.size()][][];
            for (int i = 0; i < this.writableBands.size(); ++i) {
                int tileCountX;
                Dimension tileSize;
                Band writableBand = this.writableBands.get(i);
                this.tileSizes[i] = tileSize = this.determineTileSize(writableBand);
                this.tileCountsX[i] = tileCountX = MathUtils.ceilInt((double)((double)writableBand.getRasterWidth() / (double)tileSize.width));
                int tileCountY = MathUtils.ceilInt((double)((double)writableBand.getRasterHeight() / (double)tileSize.height));
                this.tilesWritten[i] = new boolean[tileCountY][tileCountX];
                if (this.writeEntireTileRows && i > 0 && !tileSize.equals(this.tileSizes[0])) {
                    this.writeEntireTileRows = false;
                }
                pm.worked(1);
            }
            if (this.writableBands.size() > 0) {
                if (this.writeEntireTileRows) {
                    this.targetProduct.setPreferredTileSize(this.tileSizes[0]);
                }
                if (this.file != null && this.file.getParentFile() != null) {
                    this.file.getParentFile().mkdirs();
                }
                this.productWriter.writeProductNodes(this.targetProduct, (Object)this.file);
            }
            pm.worked(1);
        }
        catch (IOException e) {
            throw new OperatorException("Not able to write product file: '" + this.file.getAbsolutePath() + "'", e);
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        block17: {
            int bandIndex = this.writableBands.indexOf(targetBand);
            if (bandIndex == -1) {
                return;
            }
            try {
                Rectangle rect = targetTile.getRectangle();
                Dimension tileSize = this.tileSizes[bandIndex];
                int tileCountX = this.tileCountsX[bandIndex];
                int tileX = MathUtils.floorInt((double)((double)targetTile.getMinX() / (double)tileSize.width));
                int tileY = MathUtils.floorInt((double)((double)targetTile.getMinY() / (double)tileSize.height));
                if (this.writeEntireTileRows) {
                    TileCache tileCache;
                    Row row = new Row(targetBand, tileY);
                    Tile[] tileRowToWrite = this.updateTileRow(row, tileX, targetTile, tileCountX);
                    if (tileRowToWrite != null) {
                        this.writeTileRow(targetBand, tileRowToWrite);
                    }
                    this.markTileAsHandled(targetBand, tileX, tileY);
                    if (this.clearCacheAfterRowWrite && tileRowToWrite != null && this.isRowWrittenCompletely(tileY) && (tileCache = JAI.getDefaultInstance().getTileCache()) != null) {
                        tileCache.flush();
                    }
                } else {
                    ProductData rawSamples = targetTile.getRawSamples();
                    ProductWriter productWriter = this.productWriter;
                    synchronized (productWriter) {
                        this.productWriter.writeBandRasterData(targetBand, rect.x, rect.y, rect.width, rect.height, rawSamples, pm);
                    }
                    this.markTileAsHandled(targetBand, tileX, tileY);
                }
                if (!(this.productWriter instanceof DimapProductWriter) || !this.isProductWrittenCompletely()) break block17;
                ProductWriter productWriter = this.productWriter;
                synchronized (productWriter) {
                    this.productWriter.writeProductNodes(this.targetProduct, (Object)this.file);
                }
            }
            catch (Exception e) {
                if (this.deleteOutputOnFailure && !this.outputFileExists) {
                    try {
                        this.productWriter.deleteOutput();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (e instanceof OperatorException) {
                    throw (OperatorException)e;
                }
                throw new OperatorException("Not able to write product file: '" + this.file.getAbsolutePath() + "'", e);
            }
        }
    }

    @Override
    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        Set<Map.Entry<Band, Tile>> entrySet = targetTiles.entrySet();
        for (Map.Entry<Band, Tile> tileEntry : entrySet) {
            Band band = tileEntry.getKey();
            Tile tile = tileEntry.getValue();
            this.computeTile(band, tile, pm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tile[] updateTileRow(Row key, int tileX, Tile currentTile, int tileCountX) {
        Map<Row, Tile[]> map = this.writeCache;
        synchronized (map) {
            Tile[] tileRow;
            if (this.writeCache.containsKey(key)) {
                tileRow = this.writeCache.get(key);
            } else {
                tileRow = new Tile[tileCountX];
                this.writeCache.put(key, tileRow);
            }
            tileRow[tileX] = currentTile;
            for (Tile tile : tileRow) {
                if (tile != null) continue;
                return null;
            }
            this.writeCache.remove(key);
            return tileRow;
        }
    }

    private void writeTileRow(Band band, Tile[] cacheLine) throws IOException {
        int lineWidth = 0;
        for (Tile tile : cacheLine) {
            lineWidth += tile.getWidth();
        }
        ProductData productData = ProductData.createInstance((int)band.getDataType(), (int)(lineWidth * cacheLine[0].getHeight()));
        Object writeBuffer = productData.getElems();
        for (Tile tile : cacheLine) {
            Object tileBuffer = tile.getRawSamples().getElems();
            int tileWidth = tile.getWidth();
            int minX = tile.getMinX();
            for (int line = 0; line < tile.getHeight(); ++line) {
                int srcPos = line * tileWidth;
                int destPos = minX + line * lineWidth;
                System.arraycopy(tileBuffer, srcPos, writeBuffer, destPos, tileWidth);
            }
        }
        this.productWriter.writeBandRasterData(band, 0, cacheLine[0].getMinY(), lineWidth, cacheLine[0].getHeight(), productData, ProgressMonitor.NULL);
    }

    private void markTileAsHandled(Band targetBand, int tileX, int tileY) {
        int bandIndex = this.writableBands.indexOf(targetBand);
        this.tilesWritten[bandIndex][tileY][tileX] = true;
    }

    private boolean isRowWrittenCompletely(int rowNumber) {
        for (int bandIndex = 0; bandIndex < this.writableBands.size(); ++bandIndex) {
            for (boolean aYTileWritten : this.tilesWritten[bandIndex][rowNumber]) {
                if (aYTileWritten) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isProductWrittenCompletely() {
        for (int bandIndex = 0; bandIndex < this.writableBands.size(); ++bandIndex) {
            boolean[][] blArray = this.tilesWritten[bandIndex];
            int n = blArray.length;
            for (int i = 0; i < n; ++i) {
                boolean[] aXTileWritten;
                for (boolean aYTileWritten : aXTileWritten = blArray[i]) {
                    if (aYTileWritten) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void dispose() {
        try {
            this.productWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.writableBands != null) {
            this.writableBands.clear();
        }
        this.writeCache.clear();
        super.dispose();
    }

    private static class Row {
        private final Band band;
        private final int tileY;

        private Row(Band band, int tileY) {
            this.band = band;
            this.tileY = tileY;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.band.hashCode();
            result = 31 * result + this.tileY;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            Row other = (Row)obj;
            if (!this.band.equals(other.band)) {
                return false;
            }
            return this.tileY == other.tileY;
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(WriteOp.class);
        }
    }
}

