/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductSubsetBuilder;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.dataop.barithm.BandArithmetic;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.jexp.ParseException;
import org.esa.snap.core.jexp.Term;
import org.esa.snap.core.subset.AbstractSubsetRegion;
import org.esa.snap.core.subset.PixelSubsetRegion;
import org.esa.snap.core.util.GeoUtils;
import org.esa.snap.core.util.converters.JtsGeometryConverter;
import org.esa.snap.core.util.converters.RectangleConverter;
import org.locationtech.jts.geom.Geometry;

@OperatorMetadata(alias="Subset", category="Raster", authors="SNAP Developers", version="1.3", copyright="(c) 2011 by Brockmann Consult", description="Create a spatial and/or spectral subset of a data product.")
public class SubsetOp
extends Operator {
    @SourceProduct(alias="source", description="The source product to create the subset from.")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The list of source bands.", alias="sourceBands", rasterDataNodeType=Band.class, label="Source Bands")
    private String[] bandNames;
    @Parameter(description="The list of tie-point grid names.", alias="tiePointGrids", rasterDataNodeType=TiePointGrid.class, label="Tie-Point Grids")
    private String[] tiePointGridNames;
    @Parameter(converter=RectangleConverter.class, description="The subset region in pixel coordinates.\nUse the following format: {x},{y},{width},{height}\nIf not given, the entire scene is used. The 'geoRegion' parameter has precedence over this parameter.")
    private Rectangle region = null;
    @Parameter(description="The band used to indicate the pixel coordinates.", alias="referenceBand", rasterDataNodeType=Band.class, label="Reference Band")
    private String referenceBand = null;
    @Parameter(converter=JtsGeometryConverter.class, description="The subset region in geographical coordinates using WKT-format,\ne.g. POLYGON(({lon1} {lat1}, {lon2} {lat2}, ..., {lon1} {lat1}))\n(make sure to quote the option due to spaces in {geometry}).\nIf not given, the entire scene is used.")
    private Geometry geoRegion;
    @Parameter(defaultValue="1", description="The pixel sub-sampling step in X (horizontal image direction)")
    private int subSamplingX = 1;
    @Parameter(defaultValue="1", description="The pixel sub-sampling step in Y (vertical image direction)")
    private int subSamplingY = 1;
    @Parameter(defaultValue="false", description="Forces the operator to extend the subset region to the full swath.")
    private boolean fullSwath = false;
    @Parameter(defaultValue="false", description="Whether to copy the metadata of the source product.")
    private boolean copyMetadata = false;
    private transient ProductReader subsetReader;

    public String[] getTiePointGridNames() {
        return this.tiePointGridNames != null ? (String[])this.tiePointGridNames.clone() : null;
    }

    public void setTiePointGridNames(String[] tiePointGridNames) {
        this.tiePointGridNames = tiePointGridNames != null ? (String[])tiePointGridNames.clone() : null;
    }

    public String[] getBandNames() {
        return this.bandNames != null ? (String[])this.bandNames.clone() : null;
    }

    public void setBandNames(String[] bandNames) {
        this.bandNames = bandNames != null ? (String[])bandNames.clone() : null;
    }

    public void setCopyMetadata(boolean copyMetadata) {
        this.copyMetadata = copyMetadata;
    }

    public Rectangle getRegion() {
        return this.region != null ? new Rectangle(this.region) : null;
    }

    public void setRegion(Rectangle region) {
        this.region = region != null ? new Rectangle(region) : null;
    }

    public void setSubSamplingX(int subSamplingX) {
        this.subSamplingX = subSamplingX;
    }

    public void setSubSamplingY(int subSamplingY) {
        this.subSamplingY = subSamplingY;
    }

    public Geometry getGeoRegion() {
        return this.geoRegion;
    }

    public void setGeoRegion(Geometry geoRegion) {
        this.geoRegion = geoRegion;
    }

    @Override
    public void initialize() throws OperatorException {
        boolean isMultisize = this.sourceProduct.isMultiSize();
        this.subsetReader = new ProductSubsetBuilder();
        ProductSubsetDef subsetDef = new ProductSubsetDef();
        if (this.tiePointGridNames != null) {
            subsetDef.addNodeNames(this.tiePointGridNames);
        } else {
            subsetDef.addNodeNames(this.sourceProduct.getTiePointGridNames());
        }
        if (this.bandNames != null && this.bandNames.length > 0) {
            subsetDef.addNodeNames(this.bandNames);
        } else {
            subsetDef.addNodeNames(this.sourceProduct.getBandNames());
        }
        String[] nodeNames = subsetDef.getNodeNames();
        if (nodeNames != null) {
            ArrayList<String> referencedNodeNames = new ArrayList<String>();
            for (String nodeName : nodeNames) {
                this.collectReferencedRasters(nodeName, referencedNodeNames);
            }
            subsetDef.addNodeNames(referencedNodeNames.toArray(new String[0]));
        }
        if (this.geoRegion != null) {
            if (isMultisize) {
                subsetDef.setRegionMap(SubsetOp.computeRegionMap(this.geoRegion, this.sourceProduct, subsetDef.getNodeNames()));
                this.region = null;
            } else {
                this.region = SubsetOp.computePixelRegion(this.sourceProduct, this.geoRegion, 0);
            }
            if (this.region != null && this.region.isEmpty()) {
                this.targetProduct = new Product("Empty_" + this.sourceProduct.getName(), "EMPTY", 0, 0);
                String msg = "No intersection with source product boundary " + this.sourceProduct.getName();
                this.targetProduct.setDescription(msg);
                this.getLogger().log(Level.WARNING, msg);
                return;
            }
        }
        if (this.fullSwath && this.region != null) {
            this.region = new Rectangle(0, this.region.y, this.sourceProduct.getSceneRasterWidth(), this.region.height);
        }
        if (this.region != null && !this.region.isEmpty()) {
            if (!isMultisize || this.referenceBand == null) {
                if (this.region.width == 0 || this.region.x + this.region.width > this.sourceProduct.getSceneRasterWidth()) {
                    this.region.width = this.sourceProduct.getSceneRasterWidth() - this.region.x;
                }
                if (this.region.height == 0 || this.region.y + this.region.height > this.sourceProduct.getSceneRasterHeight()) {
                    this.region.height = this.sourceProduct.getSceneRasterHeight() - this.region.y;
                }
                subsetDef.setSubsetRegion((AbstractSubsetRegion)new PixelSubsetRegion(this.region, 0));
            } else {
                subsetDef.setRegionMap(SubsetOp.computeRegionMap(this.region, this.referenceBand, this.sourceProduct, subsetDef.getNodeNames()));
            }
        }
        if (this.region == null && this.geoRegion == null && subsetDef.getNodeNames() != null) {
            HashMap<String, Rectangle> regionMap = new HashMap<String, Rectangle>();
            for (String nodeName : subsetDef.getNodeNames()) {
                RasterDataNode rdn = this.sourceProduct.getRasterDataNode(nodeName);
                if (rdn == null || rdn.getRasterWidth() == 0 || rdn.getRasterHeight() == 0) continue;
                regionMap.put(nodeName, new Rectangle(rdn.getRasterWidth(), rdn.getRasterHeight()));
            }
            if (regionMap.size() > 0) {
                subsetDef.setRegionMap(regionMap);
            }
        }
        subsetDef.setSubSampling(this.subSamplingX, this.subSamplingY);
        subsetDef.setIgnoreMetadata(!this.copyMetadata);
        try {
            this.targetProduct = this.subsetReader.readProductNodes((Object)this.sourceProduct, subsetDef);
            this.targetProduct.setName("Subset_" + this.targetProduct.getName());
        }
        catch (Throwable t) {
            throw new OperatorException(t);
        }
    }

    private void collectReferencedRasters(String nodeName, ArrayList<String> referencedNodeNames) {
        RasterDataNode rasterDataNode = this.sourceProduct.getRasterDataNode(nodeName);
        if (rasterDataNode == null) {
            throw new OperatorException(String.format("Source product does not contain a raster named '%s'.", nodeName));
        }
        String validPixelExpression = rasterDataNode.getValidPixelExpression();
        this.collectReferencedRastersInExpression(validPixelExpression, referencedNodeNames);
        if (rasterDataNode instanceof VirtualBand) {
            VirtualBand vBand = (VirtualBand)rasterDataNode;
            this.collectReferencedRastersInExpression(vBand.getExpression(), referencedNodeNames);
        }
    }

    private void collectReferencedRastersInExpression(String expression, ArrayList<String> referencedNodeNames) {
        if (expression == null || expression.trim().isEmpty()) {
            return;
        }
        try {
            RasterDataNode[] refRasters;
            Term term = this.sourceProduct.parseExpression(expression);
            for (RasterDataNode refRaster : refRasters = BandArithmetic.getRefRasters((Term[])new Term[]{term})) {
                String refNodeName = refRaster.getName();
                if (referencedNodeNames.contains(refNodeName)) continue;
                referencedNodeNames.add(refNodeName);
                this.collectReferencedRastersInExpression(refNodeName, referencedNodeNames);
            }
        }
        catch (ParseException e) {
            this.getLogger().log(Level.WARNING, e.getMessage(), e);
        }
    }

    @Override
    public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        ProductData destBuffer = targetTile.getRawSamples();
        Rectangle rectangle = targetTile.getRectangle();
        try {
            this.subsetReader.readBandRasterData(band, rectangle.x, rectangle.y, rectangle.width, rectangle.height, destBuffer, pm);
            targetTile.setRawSamples(destBuffer);
        }
        catch (IOException e) {
            throw new OperatorException(e);
        }
    }

    public static Rectangle computePixelRegion(Product product, Geometry geometryRegion, int numBorderPixels) {
        return GeoUtils.computePixelRegionUsingGeometry((GeoCoding)product.getSceneGeoCoding(), (int)product.getSceneRasterWidth(), (int)product.getSceneRasterHeight(), (Geometry)geometryRegion, (int)numBorderPixels, (boolean)false, (boolean)false);
    }

    public static HashMap<String, Rectangle> computeRegionMap(Rectangle region, Product product, String[] rasterNames) {
        Rectangle rect;
        RasterDataNode rasterDataNode;
        if (rasterNames == null || rasterNames.length == 0) {
            List rasterDataNodes = product.getRasterDataNodes();
            rasterNames = new String[rasterDataNodes.size()];
            for (int i = 0; i < rasterDataNodes.size(); ++i) {
                rasterNames[i] = ((RasterDataNode)rasterDataNodes.get(i)).getName();
            }
        }
        HashMap<String, Rectangle> regionMap = new HashMap<String, Rectangle>();
        HashMap<String, Geometry> geometryMap = new HashMap<String, Geometry>();
        HashMap<String, Rectangle> finalRegionMap = new HashMap<String, Rectangle>();
        GeoCoding productGeoCoding = product.getSceneGeoCoding();
        int productWidth = product.getSceneRasterWidth();
        int productHeight = product.getSceneRasterHeight();
        Rectangle pixelRegion = region;
        if (pixelRegion == null) {
            pixelRegion = new Rectangle(productWidth, productHeight);
        }
        Geometry geoRegion = GeoUtils.computeGeometryUsingPixelRegion((GeoCoding)productGeoCoding, (Rectangle)pixelRegion);
        Geometry finalGeometry = null;
        for (String rasterName : rasterNames) {
            rasterDataNode = product.getRasterDataNode(rasterName);
            if (rasterDataNode == null) continue;
            rect = GeoUtils.computePixelRegionUsingGeometry((GeoCoding)rasterDataNode.getGeoCoding(), (int)rasterDataNode.getRasterWidth(), (int)rasterDataNode.getRasterHeight(), (Geometry)geoRegion, (int)0, (boolean)true, (boolean)false);
            regionMap.put(rasterDataNode.getName(), rect);
            GeoCoding rasterGeoCoding = rasterDataNode.getGeoCoding();
            Geometry geom = GeoUtils.computeGeometryUsingPixelRegion((GeoCoding)rasterGeoCoding, (Rectangle)rect);
            geometryMap.put(rasterDataNode.getName(), geom);
            if (finalGeometry == null) {
                finalGeometry = geom;
                continue;
            }
            if (!geom.covers(finalGeometry)) continue;
            finalGeometry = geom;
        }
        for (String rasterName : rasterNames) {
            rasterDataNode = product.getRasterDataNode(rasterName);
            if (rasterDataNode == null) continue;
            rect = GeoUtils.computePixelRegionUsingGeometry((GeoCoding)rasterDataNode.getGeoCoding(), (int)rasterDataNode.getRasterWidth(), (int)rasterDataNode.getRasterHeight(), finalGeometry, (int)0, (boolean)true, (boolean)false);
            finalRegionMap.put(rasterDataNode.getName(), rect);
        }
        return finalRegionMap;
    }

    public static HashMap<String, Rectangle> computeRegionMap(Rectangle region, String referenceBandName, Product product, String[] rasterNames) {
        if (rasterNames == null || rasterNames.length == 0) {
            List rasterDataNodes = product.getRasterDataNodes();
            rasterNames = new String[rasterDataNodes.size()];
            for (int i = 0; i < rasterDataNodes.size(); ++i) {
                rasterNames[i] = ((RasterDataNode)rasterDataNodes.get(i)).getName();
            }
        }
        HashMap<String, Rectangle> regionMap = new HashMap<String, Rectangle>();
        Band referenceNode = product.getBand(referenceBandName);
        GeoCoding referenceRasterGeoCoding = referenceNode.getGeoCoding();
        int referenceRasterWidth = referenceNode.getRasterWidth();
        int referenceRasterHeight = referenceNode.getRasterHeight();
        Rectangle pixelRegion = region;
        if (pixelRegion == null) {
            pixelRegion = new Rectangle(referenceRasterWidth, referenceRasterHeight);
        }
        Geometry geometryRegion = GeoUtils.computeGeometryUsingPixelRegion((GeoCoding)referenceRasterGeoCoding, (Rectangle)pixelRegion);
        for (String rasterName : rasterNames) {
            RasterDataNode rasterDataNode = product.getRasterDataNode(rasterName);
            if (rasterDataNode == null) continue;
            if (rasterDataNode.getGeoCoding().equals(referenceNode.getGeoCoding())) {
                regionMap.put(rasterDataNode.getName(), region);
                continue;
            }
            boolean usePixelCenter = true;
            boolean multiSize = false;
            if (product.isMultiSize()) {
                multiSize = true;
                usePixelCenter = false;
            }
            Rectangle rasterPixelRegion = GeoUtils.computePixelRegionUsingGeometry((GeoCoding)rasterDataNode.getGeoCoding(), (int)rasterDataNode.getRasterWidth(), (int)rasterDataNode.getRasterHeight(), (Geometry)geometryRegion, (int)0, (boolean)usePixelCenter, (boolean)multiSize);
            regionMap.put(rasterDataNode.getName(), rasterPixelRegion);
        }
        return regionMap;
    }

    public static HashMap<String, Rectangle> computeRegionMap(Geometry geoRegion, Product product, String[] rasterNames) {
        if (rasterNames == null || rasterNames.length == 0) {
            List rasterDataNodes = product.getRasterDataNodes();
            rasterNames = new String[rasterDataNodes.size()];
            for (int i = 0; i < rasterDataNodes.size(); ++i) {
                rasterNames[i] = ((RasterDataNode)rasterDataNodes.get(i)).getName();
            }
        }
        HashMap<String, Rectangle> regionMap = new HashMap<String, Rectangle>();
        for (String rasterName : rasterNames) {
            RasterDataNode rasterDataNode = product.getRasterDataNode(rasterName);
            if (rasterDataNode == null) continue;
            Rectangle rect = GeoUtils.computePixelRegionUsingGeometry((GeoCoding)rasterDataNode.getGeoCoding(), (int)rasterDataNode.getRasterWidth(), (int)rasterDataNode.getRasterHeight(), (Geometry)geoRegion, (int)0, (boolean)true, (boolean)false);
            regionMap.put(rasterDataNode.getName(), rect);
        }
        return regionMap;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(SubsetOp.class);
        }
    }
}

