/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.subset.GeometrySubsetRegion;
import org.esa.snap.core.subset.PixelSubsetRegion;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.converters.JtsGeometryConverter;
import org.esa.snap.core.util.converters.RectangleConverter;
import org.locationtech.jts.geom.Geometry;

@OperatorMetadata(alias="Read", category="Input-Output", version="1.2", authors="Marco Zuehlke, Norman Fomferra", copyright="(c) 2010 by Brockmann Consult", description="Reads a data product from a given file location.")
public class ReadOp
extends Operator {
    @Parameter(description="The file from which the data product is read.", notNull=true, notEmpty=true)
    private File file;
    @Parameter(description="An (optional) format name.", notNull=false, notEmpty=true)
    private String formatName;
    @Parameter(description="The list of source bands.", alias="sourceBands", label="Source Bands")
    private String[] bandNames;
    @Parameter(description="The list of source masks.", alias="sourceMasks", label="Source Masks")
    private String[] maskNames;
    @Parameter(converter=RectangleConverter.class, description="The subset region in pixel coordinates.\nUse the following format: {x>,{y>,{width>,{height>\nIf not given, the entire scene is used. The 'geoRegion' parameter has precedence over this parameter.")
    private Rectangle pixelRegion;
    @Parameter(converter=JtsGeometryConverter.class, description="The subset region in geographical coordinates using WKT-format,\ne.g. POLYGON(({lon1} {lat1}, {lon2} {lat2}, ..., {lon1} {lat1}))\n(make sure to quote the option due to spaces in {geometry}).\nIf not given, the entire scene is used.")
    private Geometry geometryRegion;
    @Parameter(defaultValue="false", description="Whether to use advanced options for reading of the source product.")
    private boolean useAdvancedOptions;
    @Parameter(defaultValue="true", description="Whether to copy the metadata of the source product.")
    private boolean copyMetadata;
    @TargetProduct
    private Product targetProduct;

    @Override
    public void initialize() throws OperatorException {
        if (this.file == null) {
            throw new OperatorException("The 'file' parameter is not set");
        }
        if (!this.file.exists()) {
            throw new OperatorException(String.format("Specified 'file' [%s] does not exist.", this.file));
        }
        if (this.pixelRegion != null && this.geometryRegion != null) {
            throw new OperatorException("Both types of region are specified: pixel and geometry. At most one must be specified.");
        }
        boolean hasBandNames = this.bandNames != null && this.bandNames.length > 0;
        boolean hasMaskNames = this.maskNames != null && this.maskNames.length > 0;
        ProductSubsetDef subsetDef = null;
        if (this.useAdvancedOptions && (hasBandNames || hasMaskNames || this.pixelRegion != null || this.geometryRegion != null || !this.copyMetadata)) {
            subsetDef = new ProductSubsetDef();
            subsetDef.setIgnoreMetadata(!this.copyMetadata);
            GeometrySubsetRegion subsetRegion = null;
            if (this.geometryRegion != null) {
                subsetRegion = new GeometrySubsetRegion(this.geometryRegion, 0);
            } else if (this.pixelRegion != null) {
                subsetRegion = new PixelSubsetRegion(this.pixelRegion, 0);
            }
            subsetDef.setSubsetRegion(subsetRegion);
        }
        try {
            Product openedProduct = this.getOpenedProduct();
            if (openedProduct != null && subsetDef == null) {
                ProductReader productReader;
                this.targetProduct = new Product(openedProduct.getName(), openedProduct.getProductType(), openedProduct.getSceneRasterWidth(), openedProduct.getSceneRasterHeight());
                for (Band srcband : openedProduct.getBands()) {
                    if (this.targetProduct.getBand(srcband.getName()) != null) continue;
                    if (srcband instanceof VirtualBand) {
                        ProductUtils.copyVirtualBand((Product)this.targetProduct, (VirtualBand)((VirtualBand)srcband), (String)srcband.getName());
                        continue;
                    }
                    ProductUtils.copyBand((String)srcband.getName(), (Product)openedProduct, (Product)this.targetProduct, (boolean)true);
                }
                ProductUtils.copyProductNodes((Product)openedProduct, (Product)this.targetProduct);
                this.targetProduct.setFileLocation(openedProduct.getFileLocation());
                if (this.formatName != null && !this.formatName.trim().isEmpty()) {
                    productReader = ProductIO.getProductReader((String)this.formatName);
                    if (productReader == null) {
                        throw new OperatorException("No product reader found for format '" + this.formatName + "'.");
                    }
                } else {
                    productReader = openedProduct.getProductReader();
                }
                this.targetProduct.setProductReader(productReader);
            } else {
                ProductReader productReader;
                if (this.formatName != null && !this.formatName.trim().isEmpty()) {
                    productReader = ProductIO.getProductReader((String)this.formatName);
                    if (productReader == null) {
                        throw new OperatorException("No product reader found for format '" + this.formatName + "'.");
                    }
                } else {
                    productReader = ProductIO.getProductReaderForInput((Object)this.file);
                    if (productReader == null) {
                        throw new OperatorException("No product reader found for file '" + this.file.getAbsolutePath() + "'.");
                    }
                }
                this.targetProduct = productReader.readProductNodes((Object)this.file, subsetDef);
                if (subsetDef != null) {
                    Band[] currentBands;
                    if (this.bandNames != null && this.bandNames.length > 0) {
                        List<String> targetBandNames = Arrays.asList(this.bandNames);
                        currentBands = (Band[])this.targetProduct.getBandGroup().toArray((ProductNode[])new Band[0]);
                        this.targetProduct.getBandGroup().removeAll();
                        for (Band band : currentBands) {
                            if (!targetBandNames.contains(band.getName())) continue;
                            this.targetProduct.getBandGroup().add((ProductNode)band);
                        }
                    }
                    if (this.maskNames != null && this.maskNames.length > 0) {
                        List<String> targetMaskNames = Arrays.asList(this.maskNames);
                        currentBands = (Mask[])this.targetProduct.getMaskGroup().toArray((ProductNode[])new Mask[0]);
                        this.targetProduct.getMaskGroup().removeAll();
                        for (Band mask : currentBands) {
                            if (!targetMaskNames.contains(mask.getName())) continue;
                            this.targetProduct.getMaskGroup().add((ProductNode)mask);
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            throw new OperatorException(e);
        }
    }

    @Override
    public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        ProductData dataBuffer = targetTile.getRawSamples();
        Rectangle rectangle = targetTile.getRectangle();
        try {
            this.targetProduct.getProductReader().readBandRasterData(band, rectangle.x, rectangle.y, rectangle.width, rectangle.height, dataBuffer, pm);
            targetTile.setRawSamples(dataBuffer);
        }
        catch (IOException e) {
            throw new OperatorException(e);
        }
    }

    private Product getOpenedProduct() {
        Product[] openedProducts;
        for (Product openedProduct : openedProducts = this.getProductManager().getProducts()) {
            if (!this.file.equals(openedProduct.getFileLocation())) continue;
            return openedProduct;
        }
        return null;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(ReadOp.class);
        }
    }
}

