/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.RenderingHints;
import java.text.MessageFormat;
import java.util.HashMap;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.internal.JaiHelper;

@OperatorMetadata(alias="JAI", description="Performs a JAI (Java Advanced Imaging) operation on bands of a data product.", internal=true)
public class JaiOp
extends Operator {
    @SourceProduct
    private Product sourceProduct;
    @Parameter
    private String[] bandNames;
    @Parameter
    private String operationName;
    private HashMap<String, Object> operationParameters;
    private RenderingHints renderingHints;

    public JaiOp() {
    }

    public JaiOp(Product sourceProduct, String operationName, HashMap<String, Object> operationParameters, RenderingHints renderingHints) {
        this.sourceProduct = sourceProduct;
        this.operationName = operationName;
        this.operationParameters = operationParameters;
        this.renderingHints = renderingHints;
    }

    @Override
    public void initialize() throws OperatorException {
        Product targetProduct = JaiHelper.createTargetProduct(this.sourceProduct, this.bandNames, this.operationName, this.operationParameters, this.renderingHints);
        this.setTargetProduct(targetProduct);
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public HashMap<String, Object> getOperationParameters() {
        return this.operationParameters;
    }

    public void setOperationParameters(HashMap<String, Object> operationParameters) {
        this.operationParameters = operationParameters;
    }

    @Override
    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        throw new IllegalStateException(MessageFormat.format("Operator ''{0}'' cannot compute tiles on its own.", this.getClass().getName()));
    }
}

