/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StreamTokenizer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.SwingUtilities;
import org.esa.snap.core.dataio.geometry.VectorDataNodeIO;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.PlainFeatureFactory;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.FeatureUtils;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

@OperatorMetadata(alias="Import-Vector", category="Vector", authors="Jun Lu, Luis Veci", version="1.1", copyright="Copyright (C) 2015 by Array Systems Computing Inc.", description="Imports a shape file into a product")
public class ImportVectorOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct = null;
    @Parameter(label="Vector File")
    private File vectorFile = null;
    @Parameter(label="Separate Shapes", defaultValue="true")
    private boolean separateShapes = true;

    @Override
    public void initialize() throws OperatorException {
        try {
            this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
            ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
            for (String bandName : this.sourceProduct.getBandNames()) {
                if (this.targetProduct.containsBand(bandName)) continue;
                ProductUtils.copyBand((String)bandName, (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)true);
            }
            if (this.vectorFile != null) {
                this.importGeometry(this.targetProduct, this.vectorFile);
            }
        }
        catch (Throwable e) {
            throw new OperatorException(e);
        }
    }

    private void importGeometry(Product product, File file) {
        VectorDataNode[] vectorDataNodes;
        VectorDataNode vectorDataNode;
        GeoCoding geoCoding = product.getSceneGeoCoding();
        if (ImportVectorOp.isShapefile(file) && (geoCoding == null || !geoCoding.canGetPixelPos())) {
            throw new OperatorException("Current geo-coding cannot convert from geographic to pixel coordinates.");
        }
        VectorDataNodeReader reader = ImportVectorOp.isShapefile(file) ? new VdnShapefileReader() : new VdnTextReader();
        try {
            vectorDataNode = reader.readVectorDataNode(file, product, null, ProgressMonitor.NULL);
        }
        catch (Exception e) {
            throw new OperatorException("Failed to import geometry.\nAn I/O Error occurred:\n" + e.getMessage());
        }
        for (VectorDataNode vectorDataNode1 : vectorDataNodes = VectorDataNodeIO.getVectorDataNodes((VectorDataNode)vectorDataNode, (boolean)this.separateShapes, (String)"importedVector")) {
            product.getVectorDataGroup().add((ProductNode)vectorDataNode1);
        }
    }

    private static String findUniqueVectorDataNodeName(String suggestedName, ProductNodeGroup<VectorDataNode> vectorDataGroup) {
        Object name = suggestedName;
        int index = 1;
        while (vectorDataGroup.contains((String)name)) {
            name = suggestedName + "_" + index;
            ++index;
        }
        return name;
    }

    private static boolean isShapefile(File file) {
        return file.getName().toLowerCase().endsWith(".shp");
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(ImportVectorOp.class);
        }
    }

    static class VdnTextReader
    implements VectorDataNodeReader {
        VdnTextReader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public VectorDataNode readVectorDataNode(File file, Product product, String helpId, ProgressMonitor pm) throws IOException {
            ArrayList<PixelPos> pixelPositions = new ArrayList<PixelPos>(256);
            GeoCoding geoCoding = product.getSceneGeoCoding();
            FileReader fileReader = new FileReader(file);
            LineNumberReader reader = new LineNumberReader(fileReader);
            try {
                StreamTokenizer st = VdnTextReader.createConfiguredTokenizer(reader);
                float[] values = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                boolean[] valid = new boolean[]{false, false, false, false};
                int[] indices = new int[]{0, 1, 2, 3};
                boolean headerAvailable = false;
                int column = 0;
                while (true) {
                    int tt;
                    if ((tt = st.nextToken()) == -1 || tt == 10) {
                        boolean latLonAvailable;
                        boolean xyAvailable = valid[0] && valid[1];
                        boolean bl = latLonAvailable = valid[2] && valid[3] && geoCoding != null && geoCoding.canGetPixelPos();
                        if (xyAvailable || latLonAvailable) {
                            PixelPos pixelPos = latLonAvailable ? geoCoding.getPixelPos(new GeoPos((double)values[2], (double)values[3]), null) : new PixelPos((double)values[0], (double)values[1]);
                            if (pixelPos.x != -1.0 && pixelPos.y != -1.0) {
                                pixelPositions.add(pixelPos);
                            }
                        }
                        Arrays.fill(values, 0.0f);
                        Arrays.fill(valid, false);
                        if (tt == -1) {
                            break;
                        }
                        if (tt != 10) continue;
                        column = 0;
                        continue;
                    }
                    if (tt == -3) {
                        String token = st.sval;
                        int headerText = -1;
                        if ("x".equalsIgnoreCase(token) || "pixel-x".equalsIgnoreCase(token) || "pixel_x".equalsIgnoreCase(token)) {
                            indices[0] = column;
                            headerText = 0;
                        } else if ("y".equalsIgnoreCase(token) || "pixel-y".equalsIgnoreCase(token) || "pixel_y".equalsIgnoreCase(token)) {
                            indices[1] = column;
                            headerText = 1;
                        } else if ("lat".equalsIgnoreCase(token) || "latitude".equalsIgnoreCase(token)) {
                            indices[2] = column;
                            headerText = 2;
                        } else if ("lon".equalsIgnoreCase(token) || "long".equalsIgnoreCase(token) || "longitude".equalsIgnoreCase(token)) {
                            indices[3] = column;
                            headerText = 3;
                        } else {
                            for (int i = 0; i < 4; ++i) {
                                if (column != indices[i]) continue;
                                try {
                                    values[i] = Float.parseFloat(token);
                                    valid[i] = true;
                                    break;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                        }
                        if (!headerAvailable && headerText >= 0) {
                            for (int i = 0; i < indices.length; ++i) {
                                if (headerText == i) continue;
                                indices[i] = -1;
                            }
                            headerAvailable = true;
                        }
                        ++column;
                        continue;
                    }
                    Debug.assertTrue((boolean)false);
                }
            }
            finally {
                reader.close();
                fileReader.close();
            }
            Geometry geometry = null;
            if (!pixelPositions.isEmpty()) {
                geometry = VdnTextReader.createGeometry(pixelPositions);
            }
            if (geometry == null) {
                return null;
            }
            CoordinateReferenceSystem modelCrs = product.getSceneCRS();
            AffineTransform imageToModelTransform = Product.findImageToModelTransform((GeoCoding)geoCoding);
            GeometryCoordinateSequenceTransformer transformer = new GeometryCoordinateSequenceTransformer();
            transformer.setMathTransform((MathTransform)new AffineTransform2D(imageToModelTransform));
            transformer.setCoordinateReferenceSystem(modelCrs);
            try {
                geometry = transformer.transform(geometry);
            }
            catch (TransformException ignored) {
                return null;
            }
            String name = FileUtils.getFilenameWithoutExtension((File)file);
            ImportVectorOp.findUniqueVectorDataNodeName(name, (ProductNodeGroup<VectorDataNode>)product.getVectorDataGroup());
            SimpleFeatureType simpleFeatureType = PlainFeatureFactory.createDefaultFeatureType((CoordinateReferenceSystem)modelCrs);
            DefaultFeatureCollection featureCollection = new DefaultFeatureCollection(name, simpleFeatureType);
            VectorDataNode vectorDataNode = new VectorDataNode(name, (FeatureCollection)featureCollection);
            String style = vectorDataNode.getDefaultStyleCss();
            SimpleFeature simpleFeature = PlainFeatureFactory.createPlainFeature((SimpleFeatureType)simpleFeatureType, (String)name, (Geometry)geometry, (String)style);
            featureCollection.add(simpleFeature);
            return vectorDataNode;
        }

        private static Geometry createGeometry(ArrayList<PixelPos> pixelPositions) {
            GeometryFactory geometryFactory = new GeometryFactory();
            ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
            PixelPos pixelPos0 = pixelPositions.get(0);
            coordinates.add(new Coordinate(pixelPos0.x, pixelPos0.y));
            PixelPos pixelPos1 = null;
            for (int i = 1; i < pixelPositions.size(); ++i) {
                pixelPos1 = pixelPositions.get(i);
                coordinates.add(new Coordinate(pixelPos1.x, pixelPos1.y));
            }
            if (pixelPos1 != null && pixelPos1.distanceSq((Point2D)pixelPos0) < 1.0E-5) {
                coordinates.add((Coordinate)coordinates.get(0));
            }
            if (((Coordinate)coordinates.get(0)).equals(coordinates.get(coordinates.size() - 1))) {
                return geometryFactory.createLinearRing(coordinates.toArray(new Coordinate[coordinates.size()]));
            }
            return geometryFactory.createLineString(coordinates.toArray(new Coordinate[coordinates.size()]));
        }

        private static StreamTokenizer createConfiguredTokenizer(LineNumberReader reader) {
            StreamTokenizer st = new StreamTokenizer(reader);
            st.resetSyntax();
            st.eolIsSignificant(true);
            st.lowerCaseMode(true);
            st.commentChar(35);
            st.whitespaceChars(32, 32);
            st.whitespaceChars(9, 9);
            st.wordChars(33, 255);
            return st;
        }
    }

    static class VdnShapefileReader
    implements VectorDataNodeReader {
        VdnShapefileReader() {
        }

        @Override
        public VectorDataNode readVectorDataNode(File file, Product product, String helpId, ProgressMonitor pm) throws IOException {
            MyFeatureCrsProvider crsProvider = new MyFeatureCrsProvider(helpId);
            DefaultFeatureCollection featureCollection = FeatureUtils.loadShapefileForProduct((File)file, (Product)product, (FeatureUtils.FeatureCrsProvider)crsProvider, (ProgressMonitor)pm);
            ProductNodeGroup vectorDataGroup = product.getVectorDataGroup();
            String name = ImportVectorOp.findUniqueVectorDataNodeName(((SimpleFeatureType)featureCollection.getSchema()).getName().getLocalPart(), (ProductNodeGroup<VectorDataNode>)vectorDataGroup);
            return new VectorDataNode(name, (FeatureCollection)featureCollection);
        }

        private static class MyFeatureCrsProvider
        implements FeatureUtils.FeatureCrsProvider {
            private final String helpId;

            public MyFeatureCrsProvider(String helpId) {
                this.helpId = helpId;
            }

            public CoordinateReferenceSystem getFeatureCrs(Product product) {
                CoordinateReferenceSystem[] featureCrsBuffer = new CoordinateReferenceSystem[1];
                Runnable runnable = () -> {
                    featureCrsBuffer[0] = product.getSceneGeoCoding().getMapCRS();
                };
                if (!SwingUtilities.isEventDispatchThread()) {
                    try {
                        SwingUtilities.invokeAndWait(runnable);
                    }
                    catch (InterruptedException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    runnable.run();
                }
                CoordinateReferenceSystem featureCrs = featureCrsBuffer[0];
                return featureCrs != null ? featureCrs : DefaultGeographicCRS.WGS84;
            }

            public boolean clipToProductBounds() {
                return true;
            }
        }
    }

    static interface VectorDataNodeReader {
        public VectorDataNode readVectorDataNode(File var1, Product var2, String var3, ProgressMonitor var4) throws IOException;
    }
}

