/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.annotations;

import com.bc.ceres.binding.BindingException;
import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptorFactory;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.dom.DefaultDomConverter;
import com.bc.ceres.binding.dom.DomElement;
import com.bc.ceres.binding.dom.XppDomElement;
import com.bc.ceres.core.Assert;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.copy.HierarchicalStreamCopier;
import com.thoughtworks.xstream.io.xml.XppDomWriter;
import com.thoughtworks.xstream.io.xml.XppReader;
import com.thoughtworks.xstream.io.xml.xppdom.XppDom;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.esa.snap.core.gpf.annotations.ParameterDescriptorFactory;

public class ParameterBlockConverter {
    private final ParameterDescriptorFactory parameterDescriptorFactory;
    private String parameterElementName;

    public ParameterBlockConverter() {
        this(new ParameterDescriptorFactory(), "parameters");
    }

    public ParameterBlockConverter(ParameterDescriptorFactory parameterDescriptorFactory) {
        this(parameterDescriptorFactory, "parameters");
    }

    public ParameterBlockConverter(ParameterDescriptorFactory parameterDescriptorFactory, String parameterElementName) {
        Assert.notNull((Object)parameterDescriptorFactory, (String)"parameterDescriptorFactory");
        Assert.notNull((Object)parameterElementName, (String)"parameterElementName");
        this.parameterDescriptorFactory = parameterDescriptorFactory;
        this.parameterElementName = parameterElementName;
    }

    public DomElement convertXmlToDomElement(String xml) {
        XppDomWriter domWriter = new XppDomWriter();
        new HierarchicalStreamCopier().copy((HierarchicalStreamReader)new XppReader((Reader)new StringReader(xml)), (HierarchicalStreamWriter)domWriter);
        XppDom xppDom = domWriter.getConfiguration();
        return new XppDomElement(xppDom);
    }

    public <T> T convertXmlToObject(String xml, T object) throws BindingException {
        this.convertXmlToPropertySet(xml, object.getClass(), (PropertySet)PropertyContainer.createObjectBacked(object, (PropertyDescriptorFactory)this.parameterDescriptorFactory));
        return object;
    }

    public Map<String, Object> convertXmlToMap(String xml, Class<?> schema) throws ValidationException, ConversionException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.convertXmlToPropertySet(xml, schema, (PropertySet)PropertyContainer.createMapBacked(map, schema, (PropertyDescriptorFactory)this.parameterDescriptorFactory));
        return map;
    }

    public String convertObjectToXml(Object object) throws ConversionException {
        DefaultDomConverter domConverter = new DefaultDomConverter(object.getClass(), (PropertyDescriptorFactory)this.parameterDescriptorFactory);
        XppDomElement parametersDom = new XppDomElement(this.parameterElementName);
        domConverter.convertValueToDom(object, (DomElement)parametersDom);
        return parametersDom.toXml();
    }

    private void convertXmlToPropertySet(String xml, Class<? extends Object> schema, PropertySet propertySet) throws ValidationException, ConversionException {
        propertySet.setDefaultValues();
        DefaultDomConverter domConverter = new DefaultDomConverter(schema, (PropertyDescriptorFactory)this.parameterDescriptorFactory);
        DomElement domElement = this.convertXmlToDomElement(xml);
        domConverter.convertDomToValue(domElement, (Object)propertySet);
    }
}

