/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.util;

import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.IOHandler;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public class ImageIOHandler
implements IOHandler {
    private final ImageInputStream imageInputStream;
    private final ImageOutputStream imageOutputStream;

    public ImageIOHandler(ImageInputStream imageInputStream) {
        this.imageInputStream = imageInputStream;
        this.imageOutputStream = null;
    }

    public ImageIOHandler(ImageOutputStream imageOutputStream) {
        this.imageInputStream = imageOutputStream;
        this.imageOutputStream = imageOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(DataContext context, byte[] data, long position) throws IOException {
        ImageInputStream imageInputStream = this.imageInputStream;
        synchronized (imageInputStream) {
            this.imageInputStream.seek(position);
            this.imageInputStream.readFully(data, 0, data.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(DataContext context, byte[] data, long position) throws IOException {
        if (this.imageOutputStream == null) {
            throw new IOException("Read only.");
        }
        ImageOutputStream imageOutputStream = this.imageOutputStream;
        synchronized (imageOutputStream) {
            this.imageOutputStream.seek(position);
            this.imageOutputStream.write(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMaxPosition() throws IOException {
        ImageOutputStream imageOutputStream = this.imageOutputStream;
        synchronized (imageOutputStream) {
            return this.imageInputStream.length();
        }
    }
}

