/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.util;

import com.bc.ceres.binio.CollectionData;
import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.CompoundMember;
import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.SequenceData;
import com.bc.ceres.binio.SequenceType;
import com.bc.ceres.binio.SimpleType;
import com.bc.ceres.binio.Type;
import java.io.IOException;
import java.io.PrintStream;

public class DataPrinter {
    private static final String INDENT = "    ";
    private final PrintStream stream;
    private final boolean debug;

    public DataPrinter() {
        this(System.out, false);
    }

    public DataPrinter(PrintStream stream, boolean debug) {
        this.stream = stream;
        this.debug = debug;
    }

    public void print(CollectionData data) throws IOException {
        if (data instanceof CompoundData) {
            CompoundData compoundData = (CompoundData)data;
            this.printCompound(compoundData);
        } else if (data instanceof SequenceData) {
            SequenceData sequenceData = (SequenceData)data;
            this.printSequence(sequenceData);
        }
    }

    private void printCompound(CompoundData compoundData) throws IOException {
        this.printCompound("", "", compoundData);
    }

    private void printSequence(SequenceData sequenceData) throws IOException {
        this.printSequence("", "", sequenceData);
    }

    private void printCompound(String prefix, String name, CompoundData compoundData) throws IOException {
        CompoundType compoundType = compoundData.getType();
        this.printComplexTypeName(prefix, name, compoundType, compoundData);
        int memberCount = compoundType.getMemberCount();
        for (int i = 0; i < memberCount; ++i) {
            CompoundMember member = compoundType.getMember(i);
            Type type = member.getType();
            if (type.isCompoundType()) {
                this.printCompound(prefix + INDENT, member.getName(), compoundData.getCompound(i));
                continue;
            }
            if (type.isSequenceType()) {
                this.printSequence(prefix + INDENT, member.getName(), compoundData.getSequence(i));
                continue;
            }
            if (!type.isSimpleType()) continue;
            this.stream.print(prefix + INDENT + member.getName() + ":" + type.getName() + " = ");
            this.printSimple(compoundData, type, i);
            this.stream.println();
        }
        this.stream.println(prefix + "}");
    }

    private void printSequence(String prefix, String name, SequenceData sequenceData) throws IOException {
        SequenceType sequenceType = sequenceData.getType();
        this.printComplexTypeName(prefix, name, sequenceType, sequenceData);
        Type type = sequenceType.getElementType();
        int elementCount = sequenceType.getElementCount();
        for (int i = 0; i < elementCount; ++i) {
            if (type.isCompoundType()) {
                this.printCompound(prefix + INDENT, i + " = " + sequenceType.getName(), sequenceData.getCompound(i));
                continue;
            }
            if (type.isSequenceType()) {
                this.printSequence(prefix + INDENT, i + " = " + type.getName(), sequenceData.getSequence(i));
                continue;
            }
            if (!type.isSimpleType()) continue;
            if (i % 10 == 0) {
                this.stream.print(prefix + INDENT + i + " = ");
            }
            this.printSimple(sequenceData, type, i);
            if (i % 10 == 9 || i == elementCount - 1) {
                this.stream.println();
                continue;
            }
            this.stream.print(", ");
        }
        this.stream.println(prefix + "}");
    }

    private void printComplexTypeName(String prefix, String name, Type type, CollectionData data) {
        Object namePart = name.isEmpty() ? "" : name + ":";
        this.stream.print(prefix + (String)namePart + type.getName());
        if (this.debug) {
            this.stream.print(" (position=" + data.getPosition());
            this.stream.print(", size=" + data.getSize());
            this.stream.print(", type=" + data.getClass().getSimpleName() + ")");
        }
        this.stream.println(" {");
    }

    private void printSimple(CollectionData collectionData, Type type, int index) throws IOException {
        if (type.equals(SimpleType.BYTE)) {
            this.stream.print(collectionData.getByte(index));
        } else if (type.equals(SimpleType.UBYTE)) {
            this.stream.print(collectionData.getUByte(index));
        } else if (type.equals(SimpleType.SHORT)) {
            this.stream.print(collectionData.getShort(index));
        } else if (type.equals(SimpleType.USHORT)) {
            this.stream.print(collectionData.getUShort(index));
        } else if (type.equals(SimpleType.INT)) {
            this.stream.print(collectionData.getInt(index));
        } else if (type.equals(SimpleType.UINT)) {
            this.stream.print(collectionData.getUInt(index));
        } else if (type.equals(SimpleType.LONG)) {
            this.stream.print(collectionData.getLong(index));
        } else if (type.equals(SimpleType.ULONG)) {
            this.stream.print(collectionData.getLong(index));
        } else if (type.equals(SimpleType.FLOAT)) {
            this.stream.print(collectionData.getFloat(index));
        } else if (type.equals(SimpleType.DOUBLE)) {
            this.stream.print(collectionData.getDouble(index));
        }
    }
}

