/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.util;

import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.IOHandler;
import java.io.IOException;

public class ByteArrayIOHandler
implements IOHandler {
    private byte[] byteArray;
    private int size;

    public ByteArrayIOHandler() {
        this(new byte[0]);
    }

    public ByteArrayIOHandler(byte[] byteArray) {
        this.byteArray = byteArray;
        this.size = byteArray.length;
    }

    public byte[] toByteArray() {
        return this.copyByteArray(this.size);
    }

    @Override
    public void read(DataContext context, byte[] data, long position) throws IOException {
        int r = data.length;
        if (position + (long)r > Integer.MAX_VALUE) {
            throw new IOException();
        }
        if (position >= (long)this.size) {
            return;
        }
        int pos = (int)position;
        int n = Math.min(this.size - pos, r);
        if (n == 0) {
            return;
        }
        System.arraycopy(this.byteArray, pos, data, 0, n);
    }

    @Override
    public void write(DataContext context, byte[] data, long position) throws IOException {
        int n = data.length;
        if (position + (long)n > Integer.MAX_VALUE) {
            throw new IOException();
        }
        int pos = (int)position;
        this.ensureCapacity(pos + n);
        System.arraycopy(data, 0, this.byteArray, pos, n);
        this.size = pos + n;
    }

    @Override
    public long getMaxPosition() {
        return this.size;
    }

    private void ensureCapacity(int newSize) {
        if (this.byteArray.length < newSize) {
            int blockSize = 262144;
            this.byteArray = this.copyByteArray(262144 * ((newSize + 262144 - 1) / 262144));
        }
    }

    private byte[] copyByteArray(int newCapacity) {
        byte[] newBytes = new byte[newCapacity];
        System.arraycopy(this.byteArray, 0, newBytes, 0, Math.min(this.byteArray.length, newCapacity));
        return newBytes;
    }
}

