/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.internal;

import com.bc.ceres.binio.CollectionData;
import com.bc.ceres.binio.DataAccessException;
import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.SequenceType;
import com.bc.ceres.binio.internal.AbstractSequenceOfSimples;
import com.bc.ceres.binio.internal.Segment;
import java.io.IOException;

final class VarSequenceOfSimples
extends AbstractSequenceOfSimples {
    private SequenceType resolvedSequenceType;
    private Segment segment;
    private final long position;

    public VarSequenceOfSimples(DataContext context, CollectionData parent, SequenceType sequenceType, long position) {
        super(context, parent, sequenceType);
        this.position = position;
    }

    @Override
    protected Segment getSegment() {
        return this.segment;
    }

    @Override
    protected int getSegmentOffset() {
        return 0;
    }

    @Override
    public SequenceType getType() {
        return this.resolvedSequenceType;
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Override
    public long getSize() {
        return this.resolvedSequenceType != null ? (long)this.resolvedSequenceType.getSize() : -1L;
    }

    @Override
    public int getElementCount() {
        return this.resolvedSequenceType != null ? this.resolvedSequenceType.getElementCount() : -1;
    }

    @Override
    public boolean isSizeResolved(int index) {
        return this.resolvedSequenceType != null;
    }

    @Override
    public void resolveSize(int index) throws IOException {
        this.resolveSize();
    }

    @Override
    public void resolveSize() throws IOException {
        if (this.resolvedSequenceType == null) {
            this.resolvedSequenceType = this.resolveSequenceType();
            if (!this.resolvedSequenceType.isSizeKnown()) {
                throw new DataAccessException(this.toString());
            }
        }
    }

    @Override
    public boolean isDataAccessible() {
        return this.segment != null && this.segment.isDataAccessible();
    }

    @Override
    public void makeDataAccessible() throws IOException {
        if (!this.isDataAccessible()) {
            this.segment = new Segment(this.position, this.resolvedSequenceType.getSize());
            this.segment.makeDataAccessible(this.getContext());
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.isDataAccessible()) {
            this.segment.flushData(this.getContext());
        }
    }

    @Override
    public void dispose() throws IOException {
        this.segment.dispose();
    }
}

