/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.internal;

import com.bc.ceres.binio.CollectionData;
import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.DataAccessException;
import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.SequenceData;
import com.bc.ceres.binio.SequenceType;
import com.bc.ceres.binio.Type;
import com.bc.ceres.binio.internal.AbstractSequenceOfCollections;
import com.bc.ceres.binio.internal.InstanceFactory;
import java.io.IOException;

final class VarSequenceOfFixCollections
extends AbstractSequenceOfCollections {
    private SequenceType resolvedSequenceType;

    public VarSequenceOfFixCollections(DataContext context, CollectionData parent, SequenceType sequenceType, long position) {
        super(context, parent, sequenceType, position);
    }

    @Override
    public boolean isSizeResolved(int index) {
        return this.resolvedSequenceType != null && this.resolvedSequenceType.isSizeKnown();
    }

    @Override
    public void resolveSize(int index) throws IOException {
        this.resolveSize();
    }

    @Override
    public void resolveSize() throws IOException {
        if (this.resolvedSequenceType == null) {
            this.resolvedSequenceType = this.resolveSequenceType();
            if (!this.resolvedSequenceType.isSizeKnown()) {
                throw new DataAccessException(this.toString());
            }
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void dispose() throws IOException {
    }

    @Override
    public long getSize() {
        SequenceType type = this.resolvedSequenceType;
        return type != null ? (long)type.getSize() : -1L;
    }

    @Override
    public int getElementCount() {
        SequenceType type = this.resolvedSequenceType;
        return type != null ? type.getElementCount() : -1;
    }

    @Override
    public SequenceType getType() {
        return this.resolvedSequenceType;
    }

    @Override
    public SequenceData getSequence(int index) throws IOException {
        this.ensureSizeResolved(index);
        Type elementType = this.resolvedSequenceType.getElementType();
        if (elementType instanceof SequenceType) {
            SequenceType sequenceElementType = (SequenceType)elementType;
            return InstanceFactory.createSequence(this.getContext(), this, sequenceElementType, this.getPosition() + (long)(index * sequenceElementType.getSize()), this.getContext().getFormat().getByteOrder());
        }
        throw new DataAccessException(this.getTypeErrorMsg());
    }

    @Override
    public CompoundData getCompound(int index) throws IOException {
        this.ensureSizeResolved(index);
        Type elementType = this.resolvedSequenceType.getElementType();
        if (elementType instanceof CompoundType) {
            CompoundType compoundElementType = (CompoundType)elementType;
            return InstanceFactory.createCompound(this.getContext(), this, compoundElementType, this.getPosition() + (long)(index * compoundElementType.getSize()), this.getContext().getFormat().getByteOrder());
        }
        throw new DataAccessException(this.getTypeErrorMsg());
    }
}

