/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.internal;

import com.bc.ceres.binio.CollectionData;
import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.Type;
import com.bc.ceres.binio.internal.AbstractCompound;
import com.bc.ceres.binio.internal.FixCompound;
import com.bc.ceres.binio.internal.InstanceFactory;
import com.bc.ceres.binio.internal.MemberInstance;
import com.bc.ceres.binio.internal.Segment;
import java.io.IOException;

final class VarCompound
extends AbstractCompound {
    private int maxResolvedIndex = -1;
    private long size;

    public VarCompound(DataContext context, CollectionData parent, CompoundType compoundType, long position) {
        super(context, parent, compoundType, position);
        int maxMemberIndex = FixCompound.getMemberIndexWithinSizeLimit(compoundType, Segment.getSegmentSizeLimit());
        if (maxMemberIndex >= 0) {
            int segmentSize = 0;
            for (int i = 0; i <= maxMemberIndex; ++i) {
                segmentSize += compoundType.getMember(i).getType().getSize();
            }
            Segment segment = new Segment(position, segmentSize);
            int segmentOffset = 0;
            for (int i = 0; i <= maxMemberIndex; ++i) {
                Type memberType = compoundType.getMember(i).getType();
                MemberInstance fixMember = InstanceFactory.createFixMember(context, this, memberType, segment, segmentOffset);
                this.setMemberInstance(i, fixMember);
                this.size += fixMember.getSize();
                segmentOffset += memberType.getSize();
            }
        }
        this.maxResolvedIndex = maxMemberIndex;
    }

    @Override
    public long getSize() {
        return this.isSizeResolved() ? this.size : -1L;
    }

    @Override
    public boolean isSizeResolved() {
        return this.isSizeResolved(this.getMemberCount() - 1);
    }

    @Override
    public boolean isSizeResolved(int index) {
        return index <= this.maxResolvedIndex;
    }

    @Override
    public void resolveSize() throws IOException {
        this.resolveSize(this.getElementCount() - 1);
    }

    @Override
    public void resolveSize(int index) throws IOException {
        if (this.isSizeResolved(index)) {
            return;
        }
        int i = this.maxResolvedIndex + 1;
        while (i <= index) {
            MemberInstance memberInstance = this.getMemberInstance(i);
            if (!memberInstance.isSizeResolved()) {
                memberInstance.resolveSize();
            }
            this.size += memberInstance.getSize();
            this.maxResolvedIndex = i++;
        }
    }

    @Override
    protected MemberInstance getMemberInstance(int i) throws IOException {
        MemberInstance memberInstance = super.getMemberInstance(i);
        if (memberInstance == null) {
            memberInstance = this.createMemberInstance(i);
            this.setMemberInstance(i, memberInstance);
        }
        return memberInstance;
    }

    private MemberInstance createMemberInstance(int index) throws IOException {
        long position;
        DataContext context = this.getContext();
        Type memberType = this.getType().getMemberType(index);
        if (index > 0) {
            MemberInstance prevMember = this.getMemberInstance(index - 1);
            if (!prevMember.isSizeResolved()) {
                prevMember.resolveSize();
            }
            position = prevMember.getPosition() + prevMember.getSize();
        } else {
            position = this.getPosition();
        }
        return InstanceFactory.createMember(context, this, memberType, position, this.getContext().getFormat().getByteOrder());
    }
}

