/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.internal;

import com.bc.ceres.binio.CollectionData;
import com.bc.ceres.binio.DataAccessException;
import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.SimpleType;
import com.bc.ceres.binio.internal.CompoundInstance;
import com.bc.ceres.binio.internal.DataAccessor;
import com.bc.ceres.binio.internal.MemberInstance;
import com.bc.ceres.binio.internal.Segment;
import com.bc.ceres.binio.internal.SequenceInstance;
import java.io.IOException;

final class SimpleMember
implements MemberInstance {
    private final DataContext context;
    private final CollectionData parent;
    private final SimpleType simpleType;
    private final Segment segment;
    private final int segmentOffset;
    private DataAccessor dataAccessor;

    protected SimpleMember(DataContext context, CollectionData parent, SimpleType simpleType, Segment segment, int segmentOffset) {
        this.context = context;
        this.parent = parent;
        this.simpleType = simpleType;
        this.segment = segment;
        this.segmentOffset = segmentOffset;
    }

    public CollectionData getParent() {
        return this.parent;
    }

    public Segment getSegment() {
        return this.segment;
    }

    public int getSegmentOffset() {
        return this.segmentOffset;
    }

    @Override
    public long getPosition() {
        return this.segment.getPosition() + (long)this.segmentOffset;
    }

    @Override
    public long getSize() {
        return this.simpleType.getSize();
    }

    @Override
    public boolean isSizeResolved() {
        return true;
    }

    @Override
    public void resolveSize() {
    }

    @Override
    public byte getByte() throws IOException {
        this.ensureDataAccessible();
        return this.dataAccessor.getByte(this.segment.getData(), this.segmentOffset);
    }

    @Override
    public void setByte(byte value) throws IOException {
        this.ensureDataAccessible();
        this.dataAccessor.setByte(this.segment.getData(), this.segmentOffset, value);
        this.segment.setDirty(true);
    }

    @Override
    public short getShort() throws IOException {
        this.ensureDataAccessible();
        return this.dataAccessor.getShort(this.segment.getData(), this.segmentOffset);
    }

    @Override
    public void setShort(short value) throws IOException {
        this.ensureDataAccessible();
        this.dataAccessor.setShort(this.segment.getData(), this.segmentOffset, value);
        this.segment.setDirty(true);
    }

    @Override
    public int getInt() throws IOException {
        this.ensureDataAccessible();
        return this.dataAccessor.getInt(this.segment.getData(), this.segmentOffset);
    }

    @Override
    public void setInt(int value) throws IOException {
        this.ensureDataAccessible();
        this.dataAccessor.setInt(this.segment.getData(), this.segmentOffset, value);
        this.segment.setDirty(true);
    }

    @Override
    public long getLong() throws IOException {
        this.ensureDataAccessible();
        return this.dataAccessor.getLong(this.segment.getData(), this.segmentOffset);
    }

    @Override
    public void setLong(long value) throws IOException {
        this.ensureDataAccessible();
        this.dataAccessor.setLong(this.segment.getData(), this.segmentOffset, value);
        this.segment.setDirty(true);
    }

    @Override
    public float getFloat() throws IOException {
        this.ensureDataAccessible();
        return this.dataAccessor.getFloat(this.segment.getData(), this.segmentOffset);
    }

    @Override
    public void setFloat(float value) throws IOException {
        this.ensureDataAccessible();
        this.dataAccessor.setFloat(this.segment.getData(), this.segmentOffset, value);
        this.segment.setDirty(true);
    }

    @Override
    public double getDouble() throws IOException {
        this.ensureDataAccessible();
        return this.dataAccessor.getDouble(this.segment.getData(), this.segmentOffset);
    }

    @Override
    public void setDouble(double value) throws IOException {
        this.ensureDataAccessible();
        this.dataAccessor.setDouble(this.segment.getData(), this.segmentOffset, value);
        this.segment.setDirty(true);
    }

    @Override
    public SequenceInstance getSequence() {
        throw new DataAccessException();
    }

    @Override
    public CompoundInstance getCompound() {
        throw new DataAccessException();
    }

    @Override
    public void flush() throws IOException {
        this.segment.flushData(this.context);
    }

    @Override
    public void dispose() throws IOException {
        this.segment.dispose();
    }

    private void ensureDataAccessible() throws IOException {
        if (this.dataAccessor == null) {
            this.dataAccessor = DataAccessor.getInstance(this.simpleType, this.context.getFormat().getByteOrder());
            if (!this.segment.isDataAccessible()) {
                this.segment.makeDataAccessible(this.context);
            }
        }
    }
}

