/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.internal;

import com.bc.ceres.binio.DataContext;
import java.io.IOException;

final class Segment {
    private final long position;
    private final int size;
    private byte[] data;
    private boolean dirty;
    static final String SEGMENT_SIZE_LIMIT_PROPERTY = "ceres.binio.segmentSizeLimit";
    private static long segmentSizeLimit = 16384L;

    static long getSegmentSizeLimit() {
        return segmentSizeLimit;
    }

    public Segment(long position, int size) {
        this.position = position;
        this.size = size;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public long getPosition() {
        return this.position;
    }

    public int getSize() {
        return this.size;
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean isDataAccessible() {
        return this.data != null;
    }

    public void makeDataAccessible(DataContext context) throws IOException {
        if (this.data == null) {
            this.data = new byte[this.size];
            this.setDirty(false);
            context.getHandler().read(context, this.data, this.position);
        }
    }

    public synchronized void flushData(DataContext context) throws IOException {
        if (this.isDirty()) {
            context.getHandler().write(context, this.data, this.position);
            this.setDirty(false);
        }
    }

    public void dispose() {
        this.data = null;
    }

    static {
        String value = System.getProperty(SEGMENT_SIZE_LIMIT_PROPERTY);
        if (value != null) {
            try {
                segmentSizeLimit = Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

