/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.internal;

import com.bc.ceres.binio.CollectionData;
import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.DataAccessException;
import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.SequenceData;
import com.bc.ceres.binio.SequenceType;
import com.bc.ceres.binio.Type;
import com.bc.ceres.binio.internal.AbstractSequenceOfCollections;
import com.bc.ceres.binio.internal.InstanceFactory;
import com.bc.ceres.binio.internal.Segment;
import java.io.IOException;
import java.text.MessageFormat;

final class FixSequenceOfFixCollections
extends AbstractSequenceOfCollections {
    private final Segment segment;

    public FixSequenceOfFixCollections(DataContext context, CollectionData parent, SequenceType sequenceType, long position) {
        super(context, parent, sequenceType, position);
        if (!sequenceType.isCollectionType() || !sequenceType.isSizeKnown()) {
            throw new IllegalArgumentException("sequenceType");
        }
        this.segment = (long)sequenceType.getSize() <= Segment.getSegmentSizeLimit() ? new Segment(position, sequenceType.getSize()) : null;
    }

    public FixSequenceOfFixCollections(DataContext context, CollectionData parent, SequenceType sequenceType, Segment segment, int segmentOffset) {
        super(context, parent, sequenceType, segment.getPosition() + (long)segmentOffset);
        this.segment = null;
    }

    @Override
    public long getSize() {
        return this.getType().getSize();
    }

    @Override
    public boolean isSizeResolved() {
        return true;
    }

    @Override
    public int getElementCount() {
        return this.getType().getElementCount();
    }

    @Override
    public boolean isSizeResolved(int index) {
        return true;
    }

    @Override
    public void resolveSize(int index) throws IOException {
    }

    @Override
    public void resolveSize() throws IOException {
    }

    @Override
    public SequenceData getSequence(int index) throws IOException {
        Type elementType = this.getType().getElementType();
        if (elementType instanceof SequenceType) {
            SequenceType sequenceElementType = (SequenceType)elementType;
            if (this.segment != null) {
                return InstanceFactory.createFixSequence(this.getContext(), this, sequenceElementType, this.segment, index * sequenceElementType.getSize());
            }
            return InstanceFactory.createSequence(this.getContext(), this, sequenceElementType, this.getPosition() + (long)(index * sequenceElementType.getSize()), this.getContext().getFormat().getByteOrder());
        }
        throw new DataAccessException(MessageFormat.format("Sequence expected at index = {0}", index));
    }

    @Override
    public CompoundData getCompound(int index) throws IOException {
        Type elementType = this.getType().getElementType();
        if (elementType instanceof CompoundType) {
            CompoundType compoundElementType = (CompoundType)elementType;
            if (this.segment != null) {
                return InstanceFactory.createFixCompound(this.getContext(), this, compoundElementType, this.segment, index * compoundElementType.getSize());
            }
            return InstanceFactory.createCompound(this.getContext(), this, compoundElementType, this.getPosition() + (long)(index * compoundElementType.getSize()), this.getContext().getFormat().getByteOrder());
        }
        throw new DataAccessException(MessageFormat.format("Compound expected at index = {0}", index));
    }

    @Override
    public void flush() throws IOException {
        if (this.segment != null) {
            this.segment.flushData(this.getContext());
        }
    }

    @Override
    public void dispose() throws IOException {
        if (this.segment != null) {
            this.segment.dispose();
        }
    }
}

