/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.internal;

import com.bc.ceres.binio.CollectionData;
import com.bc.ceres.binio.DataAccessException;
import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.SequenceType;
import com.bc.ceres.binio.internal.AbstractSequence;
import com.bc.ceres.binio.internal.CompoundInstance;
import com.bc.ceres.binio.internal.DataAccessor;
import com.bc.ceres.binio.internal.Segment;
import com.bc.ceres.binio.internal.SequenceInstance;
import java.io.IOException;

abstract class AbstractSequenceOfSimples
extends AbstractSequence {
    private final int elementSize;
    private DataAccessor dataAccessor;

    protected AbstractSequenceOfSimples(DataContext context, CollectionData parent, SequenceType sequenceType) {
        super(context, parent, sequenceType);
        this.elementSize = sequenceType.getElementType().getSize();
    }

    protected abstract Segment getSegment();

    protected abstract int getSegmentOffset();

    @Override
    public byte getByte(int index) throws IOException {
        this.ensureDataAccessible();
        return this.dataAccessor.getByte(this.getSegment().getData(), this.getSegmentOffset(index));
    }

    @Override
    public short getShort(int index) throws IOException {
        this.ensureDataAccessible();
        return this.dataAccessor.getShort(this.getSegment().getData(), this.getSegmentOffset(index));
    }

    @Override
    public int getInt(int index) throws IOException {
        this.ensureDataAccessible();
        return this.dataAccessor.getInt(this.getSegment().getData(), this.getSegmentOffset(index));
    }

    @Override
    public long getLong(int index) throws IOException {
        this.ensureDataAccessible();
        return this.dataAccessor.getLong(this.getSegment().getData(), this.getSegmentOffset(index));
    }

    @Override
    public float getFloat(int index) throws IOException {
        this.ensureDataAccessible();
        return this.dataAccessor.getFloat(this.getSegment().getData(), this.getSegmentOffset(index));
    }

    @Override
    public double getDouble(int index) throws IOException {
        this.ensureDataAccessible();
        return this.dataAccessor.getDouble(this.getSegment().getData(), this.getSegmentOffset(index));
    }

    @Override
    public void setByte(int index, byte value) throws IOException {
        this.ensureDataAccessible();
        this.dataAccessor.setByte(this.getSegment().getData(), this.getSegmentOffset(index), value);
        this.getSegment().setDirty(true);
    }

    @Override
    public void setShort(int index, short value) throws IOException {
        this.ensureDataAccessible();
        this.dataAccessor.setShort(this.getSegment().getData(), this.getSegmentOffset(index), value);
        this.getSegment().setDirty(true);
    }

    @Override
    public void setInt(int index, int value) throws IOException {
        this.ensureDataAccessible();
        this.dataAccessor.setInt(this.getSegment().getData(), this.getSegmentOffset(index), value);
        this.getSegment().setDirty(true);
    }

    @Override
    public void setLong(int index, long value) throws IOException {
        this.ensureDataAccessible();
        this.dataAccessor.setLong(this.getSegment().getData(), this.getSegmentOffset(index), value);
        this.getSegment().setDirty(true);
    }

    @Override
    public void setFloat(int index, float value) throws IOException {
        this.ensureDataAccessible();
        this.dataAccessor.setFloat(this.getSegment().getData(), this.getSegmentOffset(index), value);
        this.getSegment().setDirty(true);
    }

    @Override
    public void setDouble(int index, double value) throws IOException {
        this.ensureDataAccessible();
        this.dataAccessor.setDouble(this.getSegment().getData(), this.getSegmentOffset(index), value);
        this.getSegment().setDirty(true);
    }

    @Override
    public SequenceInstance getSequence(int index) {
        throw new DataAccessException(this.getTypeErrorMsg());
    }

    @Override
    public CompoundInstance getCompound(int index) {
        throw new DataAccessException(this.getTypeErrorMsg());
    }

    protected int getSegmentOffset(int index) {
        return this.getSegmentOffset() + index * this.elementSize;
    }

    private void ensureDataAccessible() throws IOException {
        if (this.dataAccessor == null) {
            this.dataAccessor = DataAccessor.getInstance(this.getType().getElementType(), this.getContext().getFormat().getByteOrder());
        }
        if (!this.isDataAccessible()) {
            if (!this.isSizeResolved()) {
                this.resolveSize();
            }
            this.makeDataAccessible();
        }
    }

    protected abstract boolean isDataAccessible();

    protected abstract void makeDataAccessible() throws IOException;
}

