/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.internal;

import com.bc.ceres.binio.CollectionData;
import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.DataAccessException;
import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.SequenceData;
import com.bc.ceres.binio.internal.AbstractCollection;
import com.bc.ceres.binio.internal.CompoundInstance;
import com.bc.ceres.binio.internal.MemberInstance;
import com.bc.ceres.binio.internal.SequenceInstance;
import java.io.IOException;

abstract class AbstractCompound
extends AbstractCollection
implements CompoundInstance {
    private final CompoundType compoundType;
    private final long position;
    private final MemberInstance[] members;

    protected AbstractCompound(DataContext context, CollectionData parent, CompoundType compoundType, long position) {
        super(context, parent);
        this.compoundType = compoundType;
        this.position = position;
        this.members = new MemberInstance[compoundType.getMemberCount()];
    }

    @Override
    public CompoundType getType() {
        return this.compoundType;
    }

    @Override
    public final int getElementCount() {
        return this.compoundType.getMemberCount();
    }

    @Override
    public final int getMemberCount() {
        return this.compoundType.getMemberCount();
    }

    @Override
    public final long getPosition() {
        return this.position;
    }

    protected MemberInstance getMemberInstance(int index) throws IOException {
        this.ensureSizeResolved(index - 1);
        return this.members[index];
    }

    protected void setMemberInstance(int index, MemberInstance memberInstance) {
        this.members[index] = memberInstance;
    }

    @Override
    public SequenceInstance getSequence() {
        throw new DataAccessException(this.getTypeErrorMsg());
    }

    @Override
    public CompoundInstance getCompound() {
        return this;
    }

    @Override
    public byte getByte(int index) throws IOException {
        MemberInstance memberInstance = this.getMemberInstance(index);
        return memberInstance.getByte();
    }

    @Override
    public short getShort(int index) throws IOException {
        MemberInstance memberInstance = this.getMemberInstance(index);
        return memberInstance.getShort();
    }

    @Override
    public int getInt(int index) throws IOException {
        MemberInstance memberInstance = this.getMemberInstance(index);
        return memberInstance.getInt();
    }

    @Override
    public long getLong(int index) throws IOException {
        MemberInstance memberInstance = this.getMemberInstance(index);
        return memberInstance.getLong();
    }

    @Override
    public float getFloat(int index) throws IOException {
        MemberInstance memberInstance = this.getMemberInstance(index);
        return memberInstance.getFloat();
    }

    @Override
    public double getDouble(int index) throws IOException {
        MemberInstance memberInstance = this.getMemberInstance(index);
        return memberInstance.getDouble();
    }

    @Override
    public void setByte(int index, byte value) throws IOException {
        MemberInstance memberInstance = this.getMemberInstance(index);
        memberInstance.setByte(value);
    }

    @Override
    public void setShort(int index, short value) throws IOException {
        MemberInstance memberInstance = this.getMemberInstance(index);
        memberInstance.setShort(value);
    }

    @Override
    public void setInt(int index, int value) throws IOException {
        MemberInstance memberInstance = this.getMemberInstance(index);
        memberInstance.setInt(value);
    }

    @Override
    public void setLong(int index, long value) throws IOException {
        MemberInstance memberInstance = this.getMemberInstance(index);
        memberInstance.setLong(value);
    }

    @Override
    public void setFloat(int index, float value) throws IOException {
        MemberInstance memberInstance = this.getMemberInstance(index);
        memberInstance.setFloat(value);
    }

    @Override
    public void setDouble(int index, double value) throws IOException {
        MemberInstance memberInstance = this.getMemberInstance(index);
        memberInstance.setDouble(value);
    }

    @Override
    public SequenceData getSequence(int index) throws IOException {
        MemberInstance memberInstance = this.getMemberInstance(index);
        return memberInstance.getSequence();
    }

    @Override
    public CompoundData getCompound(int index) throws IOException {
        MemberInstance memberInstance = this.getMemberInstance(index);
        return memberInstance.getCompound();
    }

    @Override
    public int getMemberIndex(String name) {
        return this.getType().getMemberIndex(name);
    }

    @Override
    public byte getByte(String name) throws IOException {
        return this.getByte(this.getMemberIndexSafe(name));
    }

    @Override
    public int getUByte(String name) throws IOException {
        return this.getUByte(this.getMemberIndexSafe(name));
    }

    @Override
    public short getShort(String name) throws IOException {
        return this.getShort(this.getMemberIndexSafe(name));
    }

    @Override
    public int getUShort(String name) throws IOException {
        return this.getUShort(this.getMemberIndexSafe(name));
    }

    @Override
    public int getInt(String name) throws IOException {
        return this.getInt(this.getMemberIndexSafe(name));
    }

    @Override
    public long getUInt(String name) throws IOException {
        return this.getUInt(this.getMemberIndexSafe(name));
    }

    @Override
    public long getLong(String name) throws IOException {
        return this.getLong(this.getMemberIndexSafe(name));
    }

    @Override
    public float getFloat(String name) throws IOException {
        return this.getFloat(this.getMemberIndexSafe(name));
    }

    @Override
    public double getDouble(String name) throws IOException {
        return this.getDouble(this.getMemberIndexSafe(name));
    }

    @Override
    public void setByte(String name, byte value) throws IOException {
        this.setByte(this.getMemberIndexSafe(name), value);
    }

    @Override
    public void setUByte(String name, int value) throws IOException {
        this.setUByte(this.getMemberIndexSafe(name), value);
    }

    @Override
    public void setShort(String name, short value) throws IOException {
        this.setShort(this.getMemberIndexSafe(name), value);
    }

    @Override
    public void setUShort(String name, int value) throws IOException {
        this.setUShort(this.getMemberIndexSafe(name), value);
    }

    @Override
    public void setInt(String name, int value) throws IOException {
        this.setInt(this.getMemberIndexSafe(name), value);
    }

    @Override
    public void setUInt(String name, long value) throws IOException {
        this.setUInt(this.getMemberIndexSafe(name), value);
    }

    @Override
    public void setLong(String name, long value) throws IOException {
        this.setLong(this.getMemberIndexSafe(name), value);
    }

    @Override
    public void setFloat(String name, float value) throws IOException {
        this.setFloat(this.getMemberIndexSafe(name), value);
    }

    @Override
    public void setDouble(String name, double value) throws IOException {
        this.setDouble(this.getMemberIndexSafe(name), value);
    }

    @Override
    public SequenceData getSequence(String name) throws IOException {
        int index = this.getMemberIndexSafe(name);
        return this.getSequence(index);
    }

    @Override
    public CompoundData getCompound(String name) throws IOException {
        int index = this.getMemberIndexSafe(name);
        return this.getCompound(index);
    }

    private int getMemberIndexSafe(String name) {
        int index = this.getMemberIndex(name);
        if (index == -1) {
            throw new DataAccessException("'" + name + "' is not a member of compound '" + this.getType().getName() + "'.");
        }
        return index;
    }

    @Override
    public void flush() throws IOException {
        for (MemberInstance member : this.members) {
            if (member == null) continue;
            member.flush();
        }
    }

    @Override
    public void dispose() throws IOException {
        for (MemberInstance member : this.members) {
            member.dispose();
        }
        super.dispose();
    }
}

