/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.internal;

import com.bc.ceres.binio.CollectionData;
import com.bc.ceres.binio.DataAccessException;
import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.internal.CollectionInstance;
import java.io.IOException;
import java.text.MessageFormat;

abstract class AbstractCollection
implements CollectionInstance {
    private final DataContext context;
    private final CollectionData parent;

    protected AbstractCollection(DataContext context, CollectionData parent) {
        this.context = context;
        this.parent = parent;
    }

    @Override
    public DataContext getContext() {
        return this.context;
    }

    @Override
    public CollectionData getParent() {
        return this.parent;
    }

    @Override
    public boolean isSizeResolved() {
        return this.getSize() >= 0L;
    }

    @Override
    public void dispose() throws IOException {
        this.context.dispose();
    }

    @Override
    public byte getByte() {
        throw new DataAccessException(this.getTypeErrorMsg());
    }

    @Override
    public void setByte(byte value) throws IOException {
        throw new DataAccessException(this.getTypeErrorMsg());
    }

    @Override
    public short getShort() {
        throw new DataAccessException(this.getTypeErrorMsg());
    }

    @Override
    public void setShort(short value) throws IOException {
        throw new DataAccessException(this.getTypeErrorMsg());
    }

    @Override
    public int getInt() {
        throw new DataAccessException(this.getTypeErrorMsg());
    }

    @Override
    public void setInt(int value) throws IOException {
        throw new DataAccessException(this.getTypeErrorMsg());
    }

    @Override
    public long getLong() {
        throw new DataAccessException(this.getTypeErrorMsg());
    }

    @Override
    public void setLong(long value) throws IOException {
        throw new DataAccessException(this.getTypeErrorMsg());
    }

    @Override
    public float getFloat() {
        throw new DataAccessException(this.getTypeErrorMsg());
    }

    @Override
    public void setFloat(float value) throws IOException {
        throw new DataAccessException(this.getTypeErrorMsg());
    }

    @Override
    public double getDouble() {
        throw new DataAccessException(this.getTypeErrorMsg());
    }

    @Override
    public void setDouble(double value) throws IOException {
        throw new DataAccessException(this.getTypeErrorMsg());
    }

    @Override
    public int getUByte(int index) throws IOException {
        return this.getByte(index) & 0xFF;
    }

    @Override
    public int getUShort(int index) throws IOException {
        return this.getShort(index) & 0xFFFF;
    }

    @Override
    public long getUInt(int index) throws IOException {
        return (long)this.getInt(index) & 0xFFFFFFFFL;
    }

    @Override
    public void setUByte(int index, int value) throws IOException {
        this.setInt(index, value);
    }

    @Override
    public void setUShort(int index, int value) throws IOException {
        this.setInt(index, value);
    }

    @Override
    public void setUInt(int index, long value) throws IOException {
        this.setLong(index, value);
    }

    protected final void ensureSizeResolved(int index) throws IOException {
        if (!this.isSizeResolved(index)) {
            this.resolveSize(index);
            this.assertSizeResolved(index);
        }
    }

    protected void assertSizeResolved(int index) {
        if (!this.isSizeResolved(index)) {
            throw new DataAccessException(this + " at index " + index);
        }
    }

    String getTypeErrorMsg() {
        return MessageFormat.format("Illegal data access, actual type is ''{0}''", this.getType());
    }
}

