/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.expr;

import com.bc.ceres.binio.SimpleType;
import com.bc.ceres.binio.Type;
import com.bc.ceres.binio.expr.ChoiceExpr;
import com.bc.ceres.binio.expr.CompoundExpr;
import com.bc.ceres.binio.expr.ConstantExpr;
import com.bc.ceres.binio.expr.Expression;
import com.bc.ceres.binio.expr.IntReferenceExpr;
import com.bc.ceres.binio.expr.SelectionExpr;
import com.bc.ceres.binio.expr.SequenceExpr;

public class ExpressionBuilder {
    public static final SimpleType BYTE = SimpleType.BYTE;
    public static final SimpleType UBYTE = SimpleType.UBYTE;
    public static final SimpleType SHORT = SimpleType.SHORT;
    public static final SimpleType USHORT = SimpleType.USHORT;
    public static final SimpleType INT = SimpleType.INT;
    public static final SimpleType UINT = SimpleType.UINT;
    public static final SimpleType LONG = SimpleType.LONG;
    public static final SimpleType ULONG = SimpleType.ULONG;
    public static final SimpleType FLOAT = SimpleType.FLOAT;
    public static final SimpleType DOUBLE = SimpleType.DOUBLE;

    public static ConstantExpr CONSTANT(Object value) {
        return new ConstantExpr(value);
    }

    public static ConstantExpr INV(Expression value) {
        return new ConstantExpr(value);
    }

    public static SequenceExpr SEQ(Type elementType, Expression elementCount) {
        return ExpressionBuilder.SEQ((Expression)ExpressionBuilder.CONSTANT(elementType), elementCount);
    }

    public static SequenceExpr SEQ(Expression elementType, int elementCount) {
        return ExpressionBuilder.SEQ(elementType, (Expression)ExpressionBuilder.CONSTANT(elementCount));
    }

    public static SequenceExpr SEQ(Type elementType, int elementCount) {
        return ExpressionBuilder.SEQ((Expression)ExpressionBuilder.CONSTANT(elementType), (Expression)ExpressionBuilder.CONSTANT(elementCount));
    }

    public static SequenceExpr SEQ(Expression elementType, Expression elementCount) {
        return new SequenceExpr(elementType, elementCount);
    }

    public static CompoundExpr COMP(String name, CompoundExpr.Member ... members) {
        return new CompoundExpr(name, members);
    }

    public static CompoundExpr.Member MEMBER(String name, Type type) {
        return new CompoundExpr.Member(name, ExpressionBuilder.CONSTANT(type));
    }

    public static CompoundExpr.Member MEMBER(String name, Expression expression) {
        return new CompoundExpr.Member(name, expression);
    }

    public static ChoiceExpr IF(Expression condition, Type type1, Type type2) {
        return ExpressionBuilder.IF(condition, ExpressionBuilder.CONSTANT(type1), ExpressionBuilder.CONSTANT(type2));
    }

    public static ChoiceExpr IF(Expression condition, Expression expression1, Expression expression2) {
        return new ChoiceExpr(condition, expression1, expression2);
    }

    public static SelectionExpr SELECT(Expression condition, SelectionExpr.Case ... cases) {
        return new SelectionExpr(condition, cases);
    }

    public static SelectionExpr.Case CASE(Object value, Type type) {
        return new SelectionExpr.Case(value, ExpressionBuilder.CONSTANT(type));
    }

    public static SelectionExpr.Case CASE(Object value, Expression expression) {
        return new SelectionExpr.Case(value, expression);
    }

    public static SelectionExpr.Default DEFAULT(Type type) {
        return ExpressionBuilder.DEFAULT(ExpressionBuilder.CONSTANT(type));
    }

    public static SelectionExpr.Default DEFAULT(Expression expression) {
        return new SelectionExpr.Default(expression);
    }

    public static IntReferenceExpr IREF(String name) {
        return new IntReferenceExpr(name);
    }

    private ExpressionBuilder() {
    }
}

