/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.binx;

import com.bc.ceres.binio.CompoundMember;
import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.DataFormat;
import com.bc.ceres.binio.SimpleType;
import com.bc.ceres.binio.Type;
import com.bc.ceres.binio.TypeBuilder;
import com.bc.ceres.binio.VarSequenceType;
import com.bc.ceres.binio.binx.BinXException;
import com.bc.ceres.core.Assert;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;

public class BinX {
    static final String ANONYMOUS_COMPOUND_PREFIX = "AnonymousCompound@";
    static final String ARRAY_VARIABLE_PREFIX = "ArrayVariable@";
    static final String DEFAULT_ELEMENT_COUNT_POSTFIX = "_Counter";
    private final Map<String, String> parameters = new HashMap<String, String>();
    private final Map<String, Type> definitions = new HashMap<String, Type>();
    private final Map<String, String> varNameMap = new HashMap<String, String>();
    private final Set<String> inlinedStructs = new HashSet<String>();
    private String elementCountPostfix;
    private boolean singleDatasetStructInlined;
    private boolean arrayVariableInlined;
    private Map<String, SimpleType> primitiveTypes = new HashMap<String, SimpleType>();
    private Namespace namespace;
    private static int anonymousCompoundId = 0;

    public BinX() {
        this.primitiveTypes.put("byte-8", SimpleType.BYTE);
        this.primitiveTypes.put("unsignedByte-8", SimpleType.UBYTE);
        this.primitiveTypes.put("short-16", SimpleType.SHORT);
        this.primitiveTypes.put("unsignedShort-16", SimpleType.USHORT);
        this.primitiveTypes.put("integer-32", SimpleType.INT);
        this.primitiveTypes.put("unsignedInteger-32", SimpleType.UINT);
        this.primitiveTypes.put("long-64", SimpleType.LONG);
        this.primitiveTypes.put("unsignedLong-64", SimpleType.ULONG);
        this.primitiveTypes.put("float-32", SimpleType.FLOAT);
        this.primitiveTypes.put("double-64", SimpleType.DOUBLE);
        this.elementCountPostfix = DEFAULT_ELEMENT_COUNT_POSTFIX;
        this.singleDatasetStructInlined = false;
        this.arrayVariableInlined = false;
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public String setParameter(String name, String value) {
        if (value == null) {
            return this.parameters.remove(name);
        }
        return this.parameters.put(name, value);
    }

    public Type getDefinition(String name) {
        return this.definitions.get(name);
    }

    public Type setDefinition(String name, Type value) {
        if (value == null) {
            return this.definitions.remove(name);
        }
        return this.definitions.put(name, value);
    }

    public String setVarNameMapping(String sourceName, String targetName) {
        if (targetName == null) {
            return this.varNameMap.remove(sourceName);
        }
        return this.varNameMap.put(sourceName, targetName);
    }

    public void setVarNameMappings(Properties properties) {
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
                String sourceName = (String)entry.getKey();
                String targetName = (String)entry.getValue();
                this.setVarNameMapping(sourceName, targetName);
            }
        }
    }

    public boolean setTypeMembersInlined(String typeName, boolean b) {
        if (!b) {
            return this.inlinedStructs.remove(typeName);
        }
        return this.inlinedStructs.add(typeName);
    }

    public void setTypeMembersInlined(Properties properties) {
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                if (!(entry.getKey() instanceof String)) continue;
                String typeName = (String)entry.getKey();
                this.setTypeMembersInlined(typeName, "true".equals(entry.getValue()));
            }
        }
    }

    public String getElementCountPostfix() {
        return this.elementCountPostfix;
    }

    public void setElementCountPostfix(String elementCountPostfix) {
        Assert.notNull((Object)elementCountPostfix, (String)"elementCountPostfix");
        this.elementCountPostfix = elementCountPostfix;
    }

    public boolean isSingleDatasetStructInlined() {
        return this.singleDatasetStructInlined;
    }

    public void setSingleDatasetStructInlined(boolean singleDatasetStructInlined) {
        this.singleDatasetStructInlined = singleDatasetStructInlined;
    }

    public boolean isArrayVariableInlined() {
        return this.arrayVariableInlined;
    }

    public void setArrayVariableInlined(boolean arrayVariableInlined) {
        this.arrayVariableInlined = arrayVariableInlined;
    }

    public DataFormat readDataFormat(URI uri) throws BinXException, IOException {
        return this.readDataFormat(uri, uri.toString());
    }

    public DataFormat readDataFormat(URI uri, String formatName) throws BinXException, IOException {
        DataFormat format = new DataFormat(this.parseDocument(uri));
        format.setName(formatName);
        for (Map.Entry<String, Type> entry : this.definitions.entrySet()) {
            format.addTypeDef(entry.getKey(), entry.getValue());
        }
        return format;
    }

    private CompoundType parseDocument(URI uri) throws IOException, BinXException {
        Document document;
        SAXBuilder builder = new SAXBuilder();
        try {
            document = builder.build(uri.toURL());
        }
        catch (JDOMException e) {
            throw new BinXException(MessageFormat.format("Failed to read ''{0}''", uri), e);
        }
        Element binxElement = document.getRootElement();
        this.namespace = binxElement.getNamespace();
        this.parseParameters(binxElement);
        this.parseDefinitions(binxElement);
        return this.parseDataset(binxElement);
    }

    private void parseParameters(Element binxElement) throws BinXException {
        Element parametersElement = this.getChild(binxElement, "parameters", false);
        if (parametersElement != null) {
            throw new BinXException(MessageFormat.format("Element ''{0}'': Not implemented", parametersElement.getName()));
        }
    }

    private void parseDefinitions(Element binxElement) throws IOException, BinXException {
        Element definitionsElement = this.getChild(binxElement, "definitions", false);
        if (definitionsElement != null) {
            List defineTypeElements = this.getChildren(definitionsElement, "defineType", false);
            for (int i = 0; i < defineTypeElements.size(); ++i) {
                Element defineTypeElement = (Element)defineTypeElements.get(i);
                String typeName = BinX.getTypeName(defineTypeElement, true);
                Element child = this.getChild(defineTypeElement, true);
                Type type = this.parseNonSimpleType(child);
                if (type == null) {
                    throw new BinXException(MessageFormat.format("Element ''{0}'': ''{1}'' not expected here", defineTypeElement.getName(), child.getName()));
                }
                if (this.definitions.containsKey(typeName)) {
                    throw new BinXException(MessageFormat.format("Element ''{0}'': Duplicate type definition ''{1}''", definitionsElement.getName(), typeName));
                }
                if (type instanceof CompoundType && type.getName().startsWith(ANONYMOUS_COMPOUND_PREFIX)) {
                    type = TypeBuilder.COMPOUND(typeName, ((CompoundType)type).getMembers());
                }
                this.definitions.put(typeName, type);
            }
        }
    }

    private CompoundType parseDataset(Element binxElement) throws BinXException, IOException {
        Element datasetElement = this.getChild(binxElement, "dataset", true);
        CompoundType compoundType = this.parseStruct(datasetElement);
        if (this.singleDatasetStructInlined && compoundType.getMemberCount() == 1 && compoundType.getMember(0).getType() instanceof CompoundType) {
            CompoundMember member = compoundType.getMember(0);
            return TypeBuilder.COMPOUND(member.getName(), ((CompoundType)member.getType()).getMembers());
        }
        return TypeBuilder.COMPOUND("Dataset", compoundType.getMembers());
    }

    private Type parseNonSimpleType(Element typeElement) throws BinXException {
        String childName = typeElement.getName();
        Type type = null;
        if (childName.equals("struct")) {
            type = this.parseStruct(typeElement);
        } else if (childName.equals("union")) {
            type = this.parseUnion(typeElement);
        } else if (childName.equals("arrayFixed")) {
            type = this.parseArrayFixed(typeElement);
        } else if (childName.equals("arrayStreamed")) {
            type = this.parseArrayStreamed(typeElement);
        } else if (childName.equals("arrayVariable")) {
            type = this.parseArrayVariable(typeElement);
        }
        return type;
    }

    private Type parseAnyType(Element typeElement) throws BinXException {
        Type type;
        String typeName = typeElement.getName();
        if (typeName.equals("useType")) {
            type = this.parseUseType(typeElement);
        } else {
            type = this.parseNonSimpleType(typeElement);
            if (type == null && (type = (Type)this.primitiveTypes.get(typeElement.getName())) == null) {
                throw new BinXException(MessageFormat.format("Element ''{0}'': Unknown type: {1}", typeElement.getName(), typeName));
            }
        }
        return type;
    }

    private Type parseUseType(Element typeElement) throws BinXException {
        String typeName = BinX.getTypeName(typeElement, true);
        Type type = this.definitions.get(typeName);
        if (type == null) {
            throw new BinXException(MessageFormat.format("Element ''{0}'': Unknown type definition: {1}", typeElement.getName(), typeName));
        }
        return type;
    }

    private CompoundType parseStruct(Element typeElement) throws BinXException {
        List memberElements = this.getChildren(typeElement, false);
        ArrayList<CompoundMember> members = new ArrayList<CompoundMember>();
        for (int i = 0; i < memberElements.size(); ++i) {
            Element memberElement = (Element)memberElements.get(i);
            Type memberType = this.parseAnyType(memberElement);
            if (memberType instanceof CompoundType) {
                CompoundType compoundType = (CompoundType)memberType;
                if (this.inlinedStructs.contains(memberType.getName())) {
                    for (CompoundMember compoundMember : compoundType.getMembers()) {
                        members.add(TypeBuilder.MEMBER(compoundMember.getName(), compoundMember.getType()));
                    }
                    continue;
                }
                if (this.isArrayVariableInlined() && memberType.getName().startsWith(ARRAY_VARIABLE_PREFIX)) {
                    members.add(TypeBuilder.MEMBER(compoundType.getMemberName(0), compoundType.getMemberType(0)));
                    members.add(TypeBuilder.MEMBER(compoundType.getMemberName(1), compoundType.getMemberType(1)));
                    continue;
                }
            }
            String memberName = this.getVarName(memberElement, true);
            members.add(TypeBuilder.MEMBER(memberName, memberType));
        }
        return TypeBuilder.COMPOUND(BinX.generateCompoundName(), members.toArray(new CompoundMember[members.size()]));
    }

    private CompoundType parseArrayVariable(Element typeElement) throws BinXException {
        Type sizeRefType;
        Element sizeRefElement = this.getChild(typeElement, "sizeRef", 0, true);
        Element arrayTypeElement = this.getChild(typeElement, 1, true);
        String sequenceName = this.getVarName(arrayTypeElement, false);
        if (sequenceName == null && (sequenceName = this.getVarName(typeElement, false)) == null) {
            throw new BinXException(MessageFormat.format("Element ''{0}'': Missing name", typeElement.getName()));
        }
        Element sizeRefTypeElement = this.getChild(sizeRefElement, true);
        Object sizeRefName = this.getVarName(sizeRefTypeElement, false);
        if (sizeRefName == null) {
            sizeRefName = sequenceName + this.elementCountPostfix;
        }
        if (!BinX.isIntegerType(sizeRefType = this.parseAnyType(sizeRefTypeElement))) {
            throw new BinXException(MessageFormat.format("Element ''{0}'': 'sizeRef' must be an integer type", typeElement.getName()));
        }
        Type arrayType = this.parseAnyType(arrayTypeElement);
        VarSequenceType sequenceType = TypeBuilder.VAR_SEQUENCE(arrayType, (String)sizeRefName);
        return TypeBuilder.COMPOUND(BinX.generateArrayVariableCompoundName(sequenceName), TypeBuilder.MEMBER((String)sizeRefName, sizeRefType), TypeBuilder.MEMBER(sequenceName, sequenceType));
    }

    private Type parseUnion(Element typeElement) throws BinXException {
        throw new BinXException(MessageFormat.format("Element ''{0}'': Type not implemented", typeElement.getName()));
    }

    private Type parseArrayFixed(Element typeElement) throws BinXException {
        Element arrayTypeElement = this.getChild(typeElement, 0, true);
        Element dimElement = this.getChild(typeElement, "dim", 1, true);
        if (!dimElement.getChildren().isEmpty()) {
            throw new BinXException(MessageFormat.format("Element ''{0}'': Multi-dimensional arrays not yet implemented", typeElement.getName()));
        }
        Type arrayType = this.parseAnyType(arrayTypeElement);
        int indexFrom = BinX.getAttributeIntValue(dimElement, "indexFrom", 0);
        if (indexFrom != 0) {
            throw new BinXException(MessageFormat.format("Element ''{0}'': Attribute 'indexFrom' other than zero not supported.", typeElement.getName()));
        }
        int indexTo = BinX.getAttributeIntValue(dimElement, "indexTo");
        return TypeBuilder.SEQUENCE(arrayType, indexTo + 1);
    }

    private Type parseArrayStreamed(Element typeElement) throws BinXException {
        throw new BinXException(MessageFormat.format("Element ''{0}'': Type not implemented", typeElement.getName()));
    }

    private String getVarName(Element element, boolean require) throws BinXException {
        String name = BinX.getAttributeValue(element, "varName", require);
        if (this.varNameMap.containsKey(name)) {
            return this.varNameMap.get(name);
        }
        return name;
    }

    private static String getTypeName(Element element, boolean require) throws BinXException {
        return BinX.getAttributeValue(element, "typeName", require);
    }

    private Element getChild(Element element, boolean require) throws BinXException {
        return this.getChild(element, 0, require);
    }

    private Element getChild(Element element, int index, boolean require) throws BinXException {
        return this.getChild(element, null, index, require);
    }

    private Element getChild(Element element, String name, boolean require) throws BinXException {
        Element child = element.getChild(name, this.namespace);
        if (require && child == null) {
            throw new BinXException(MessageFormat.format("Element ''{0}}': child ''{1}'' not found.", element.getName(), name));
        }
        return child;
    }

    private Element getChild(Element element, String name, int index, boolean require) throws BinXException {
        List children = this.getChildren(element, null, require);
        if (children.size() <= index) {
            if (require) {
                if (name != null) {
                    throw new BinXException(MessageFormat.format("Element ''{0}'': Expected to have a child ''{1}'' at index {2}", element.getName(), name, index));
                }
                throw new BinXException(MessageFormat.format("Element ''{0}'': Expected to have a child at index {1}", element.getName(), index));
            }
            return null;
        }
        Element child = (Element)children.get(index);
        if (name != null && !name.equals(child.getName())) {
            throw new BinXException(MessageFormat.format("Element ''{0}'': Expected child ''{1}'' at index {2}", element.getName(), name, index));
        }
        return child;
    }

    private List getChildren(Element element, boolean require) throws BinXException {
        return this.getChildren(element, null, require);
    }

    private List getChildren(Element element, String name, boolean require) throws BinXException {
        List children = element.getChildren(name, this.namespace);
        if (require && children.isEmpty()) {
            if (name != null) {
                throw new BinXException(MessageFormat.format("Element ''{0}'': Expected to have at least one child of ''{1}''", element.getName(), name));
            }
            throw new BinXException(MessageFormat.format("Element ''{0}'': Expected to have at least one child", element.getName()));
        }
        return children;
    }

    private static String getAttributeValue(Element element, String name, boolean require) throws BinXException {
        String value = element.getAttributeValue(name);
        if (require && value == null) {
            throw new BinXException(MessageFormat.format("Element ''{0}'': attribute ''{1}'' not found.", element.getName(), name));
        }
        return value != null ? value.trim() : value;
    }

    private static int getAttributeIntValue(Element element, String attributeName) throws BinXException {
        return BinX.getAttributeIntValue(element, attributeName, true);
    }

    private static int getAttributeIntValue(Element element, String attributeName, int defaultValue) throws BinXException {
        Integer value = BinX.getAttributeIntValue(element, attributeName, false);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    private static Integer getAttributeIntValue(Element element, String attributeName, boolean required) throws BinXException {
        String value = BinX.getAttributeValue(element, attributeName, required);
        if (value == null) {
            return null;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new BinXException(MessageFormat.format("Element ''{0}'': Attribute ''{1}'' must be an integer.", element.getName(), attributeName));
        }
    }

    private static String generateCompoundName() {
        return ANONYMOUS_COMPOUND_PREFIX + anonymousCompoundId++;
    }

    private static String generateArrayVariableCompoundName(String sequenceName) {
        return ARRAY_VARIABLE_PREFIX + sequenceName;
    }

    private static boolean isIntegerType(Type sizeRefType) {
        return sizeRefType == SimpleType.BYTE || sizeRefType == SimpleType.UBYTE || sizeRefType == SimpleType.SHORT || sizeRefType == SimpleType.USHORT || sizeRefType == SimpleType.INT || sizeRefType == SimpleType.UINT || sizeRefType == SimpleType.LONG || sizeRefType == SimpleType.ULONG;
    }
}

