/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.runtime;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.esa.snap.runtime.EngineConfig;

class InstallationScanner {
    private static final String JAR_EXT = ".jar";
    private final EngineConfig config;

    public InstallationScanner(EngineConfig config) {
        this.config = config;
    }

    ScanResult scanInstallationDir() {
        try {
            return this.scanInstallationDir0();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ScanResult scanInstallationDir0() throws IOException {
        ScanResult scanResult = new ScanResult();
        Path installationDir = this.config.installDir();
        Path clustersFile = installationDir.resolve(Paths.get("etc", "snap.clusters"));
        if (Files.exists(clustersFile, new LinkOption[0])) {
            return this.scanNetBeansInstallationStructure(installationDir, clustersFile, scanResult);
        }
        return this.scanEngineInstallationStructure(installationDir, scanResult);
    }

    private ScanResult scanEngineInstallationStructure(Path installationDir, ScanResult scanResult) throws IOException {
        Path libDir;
        Path modulesDir = installationDir.resolve("modules");
        if (Files.isDirectory(modulesDir, new LinkOption[0])) {
            this.scanDir(modulesDir, scanResult);
        }
        if (Files.isDirectory(libDir = installationDir.resolve("lib"), new LinkOption[0])) {
            this.scanDir(libDir, scanResult);
        }
        return scanResult;
    }

    /*
     * WARNING - void declaration
     */
    private ScanResult scanNetBeansInstallationStructure(Path installationDir, Path clustersFile, ScanResult scanResult) throws IOException {
        Path windowsNbUserDir;
        HashSet excludedClusterNames = new HashSet();
        Collections.addAll(excludedClusterNames, this.config.excludedClusterNames());
        ArrayList<Path> clusterPaths = new ArrayList<Path>();
        Path unixNbUserDir = this.config.userDir().resolve("system");
        if (Files.isDirectory(unixNbUserDir, new LinkOption[0])) {
            clusterPaths.add(unixNbUserDir);
        }
        if (Files.isDirectory(windowsNbUserDir = Paths.get(System.getProperty("user.home"), new String[0]).resolve("AppData").resolve("Roaming").resolve("SNAP"), new LinkOption[0])) {
            clusterPaths.add(windowsNbUserDir);
        }
        try {
            List<String> clusterNames = Files.readAllLines(clustersFile);
            clusterNames.stream().filter(clusterName -> !excludedClusterNames.contains(clusterName)).forEach(clusterName -> {
                Path clusterPath = installationDir.resolve((String)clusterName);
                if (Files.isDirectory(clusterPath, new LinkOption[0])) {
                    clusterPaths.add(clusterPath);
                }
            });
        }
        catch (IOException e) {
            this.fail(e);
        }
        for (String pathName : this.config.preferences().get("snap.extraClusters", "").split(File.pathSeparator)) {
            Path clusterPath;
            if (pathName.isEmpty() || !Files.isDirectory(clusterPath = Paths.get(pathName, new String[0]), new LinkOption[0])) continue;
            clusterPaths.add(clusterPath);
        }
        HashSet<String> excludedModuleNames = new HashSet<String>();
        String[] moduleNames = this.config.excludedModuleNames();
        for (String string : moduleNames) {
            void var13_19;
            if (string.indexOf(58) == -1) {
                String string2 = "org.esa.snap:" + string;
            }
            String netBeansName = var13_19.replace(':', '-').replace('.', '-');
            excludedModuleNames.add(netBeansName + JAR_EXT);
        }
        if (!clusterPaths.isEmpty()) {
            for (Path clusterPath : clusterPaths) {
                this.scanNetBeansCluster(clusterPath, excludedModuleNames, scanResult);
            }
        } else {
            this.fail("No classpath entries found");
        }
        return scanResult;
    }

    private void scanNetBeansCluster(Path clusterDir, Set<String> excludedModuleNames, ScanResult scanResult) throws IOException {
        Path modulesDir = clusterDir.resolve(Paths.get("modules", new String[0]));
        if (!Files.isDirectory(modulesDir, new LinkOption[0])) {
            return;
        }
        List moduleJarFiles = Files.list(modulesDir).filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(path -> {
            Path fileName = path.getFileName();
            String name = fileName.toString();
            return name.endsWith(JAR_EXT) && !excludedModuleNames.contains(name) && !scanResult.classPathEntries.stream().filter(path2 -> path2.endsWith(fileName)).findAny().isPresent();
        }).collect(Collectors.toList());
        for (Object moduleJarFile : moduleJarFiles) {
            scanResult.classPathEntries.add((Path)moduleJarFile);
        }
        HashSet<String> includedModuleNames = new HashSet<String>();
        for (Path moduleJarFile : moduleJarFiles) {
            String moduleJarName = moduleJarFile.getFileName().toString();
            String moduleName = moduleJarName.substring(0, moduleJarName.length() - JAR_EXT.length()).replace('.', '-');
            includedModuleNames.add(moduleName);
        }
        Path extDir = modulesDir.resolve(Paths.get("ext", new String[0]));
        if (Files.isDirectory(extDir, new LinkOption[0])) {
            List subDirs = Files.list(extDir).filter(p -> Files.isDirectory(p, new LinkOption[0])).collect(Collectors.toList());
            for (Path subDir : subDirs) {
                String moduleName = subDir.getFileName().toString().replace('.', '-');
                if (!includedModuleNames.contains(moduleName)) continue;
                this.scanDir(subDir, scanResult);
            }
        }
        this.scanNativeLibraryPaths(modulesDir, scanResult);
    }

    private void scanNativeLibraryPaths(Path modulesDir, ScanResult scanResult) {
        Path libDir = modulesDir.resolve(Paths.get("lib", new String[0]));
        if (Files.isDirectory(libDir, new LinkOption[0])) {
            scanResult.libraryPathEntries.add(libDir);
            Path libArchDir = libDir.resolve(System.getProperty("os.arch"));
            if (Files.isDirectory(libArchDir, new LinkOption[0])) {
                scanResult.libraryPathEntries.add(libArchDir);
                Path libArchOsDir = libArchDir.resolve(System.getProperty("os.name"));
                if (Files.isDirectory(libArchOsDir, new LinkOption[0])) {
                    scanResult.libraryPathEntries.add(libArchOsDir);
                }
            }
        }
    }

    private void scanDir(Path dir, ScanResult scanResult) throws IOException {
        List entries = Files.list(dir).collect(Collectors.toList());
        scanResult.classPathEntries.addAll(entries.stream().filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(path -> path.getFileName().toString().endsWith(JAR_EXT)).collect(Collectors.toList()));
        for (Path entry : entries) {
            if (!Files.isDirectory(entry, new LinkOption[0])) continue;
            this.scanDir(entry, scanResult);
        }
    }

    private void fail(String s) {
        throw new RuntimeException(s);
    }

    private void fail(Exception e) {
        throw new RuntimeException(e);
    }

    static class ScanResult {
        List<Path> classPathEntries = new ArrayList<Path>();
        List<Path> libraryPathEntries = new ArrayList<Path>();

        ScanResult() {
        }
    }
}

