/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.runtime;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.esa.snap.runtime.EngineConfig;
import org.esa.snap.runtime.EnginePreferences;

public class Config {
    static final String CONFIG_FILE_EXT = ".properties";
    static final String CONFIG_KEY_SUFFIX = ".config";
    private static final Map<String, Config> INSTANCES = new HashMap<String, Config>();
    private final String name;
    private final EnginePreferences preferences;
    private AtomicBoolean isLoaded = new AtomicBoolean(false);

    private Config(String name) {
        this(name, new EnginePreferences((EnginePreferences)EngineConfig.instance().preferences(), name));
    }

    protected Config(String name, EnginePreferences preferences) {
        this.name = name;
        this.preferences = preferences;
    }

    public static Config instance() {
        return EngineConfig.instance();
    }

    public static Config instance(String name) {
        Config config = INSTANCES.get(name);
        if (config == null) {
            config = new Config(name);
            Config.add(config);
        }
        return config;
    }

    static void add(Config config) {
        INSTANCES.put(config.name(), config);
    }

    void clear() {
        try {
            this.preferences.clear();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        this.isLoaded.set(false);
    }

    public String name() {
        return this.name;
    }

    public Logger logger() {
        return EngineConfig.instance().logger();
    }

    public boolean debug() {
        return EngineConfig.instance().debug();
    }

    public Path installDir() {
        return EngineConfig.instance().installDir();
    }

    public Path userDir() {
        return EngineConfig.instance().userDir();
    }

    public boolean ignoreDefaultConfig() {
        return EngineConfig.instance().ignoreDefaultConfig();
    }

    public boolean ignoreUserConfig() {
        return EngineConfig.instance().ignoreUserConfig();
    }

    public boolean loaded() {
        return this.isLoaded.get();
    }

    public Preferences preferences() {
        return this.preferences;
    }

    public String[] listKeys(String prefix) throws BackingStoreException {
        String[] keys;
        ArrayList<String> keyList = new ArrayList<String>();
        for (String key : keys = this.preferences.keys()) {
            if (!key.startsWith(prefix)) continue;
            keyList.add(key);
        }
        return keyList.toArray(new String[keyList.size()]);
    }

    public Path storagePath() {
        return this.preferences.getBackingStorePath();
    }

    public Config storagePath(Path propertiesFile) {
        this.preferences.setBackingStorePath(propertiesFile);
        return this;
    }

    public Config load(Path propertiesFile) {
        Properties customProperties = this.loadProperties(propertiesFile, true);
        if (customProperties != null) {
            this.preferences.getProperties().putAll((Map<?, ?>)customProperties);
        }
        return this;
    }

    public Config load() {
        if (this.isLoaded.compareAndSet(false, true)) {
            Properties additionalProperties;
            String configPath;
            Properties userProperties;
            Properties defaultProperties;
            if (!this.ignoreDefaultConfig() && (defaultProperties = this.loadProperties(this.installDir().resolve("etc").resolve(this.name() + CONFIG_FILE_EXT), false)) != null) {
                Properties newProperties = new Properties(defaultProperties);
                newProperties.putAll((Map<?, ?>)this.preferences.getProperties());
                this.preferences.setProperties(newProperties);
            }
            if (!this.ignoreUserConfig() && (userProperties = this.loadProperties(this.userDir().resolve("etc").resolve(this.name() + CONFIG_FILE_EXT), false)) != null) {
                this.preferences.getProperties().putAll((Map<?, ?>)userProperties);
            }
            if ((configPath = this.preferences.get(this.name() + CONFIG_KEY_SUFFIX, null)) != null && (additionalProperties = this.loadProperties(Paths.get(configPath, new String[0]), true)) != null) {
                this.preferences.getProperties().putAll((Map<?, ?>)additionalProperties);
            }
        }
        return this;
    }

    protected Properties loadProperties(Path propertiesFile, boolean mustExist) {
        if (!Files.isRegularFile(propertiesFile, new LinkOption[0])) {
            String msg = String.format("Can't find configuration file '%s'", propertiesFile);
            if (mustExist) {
                throw new RuntimeException(msg);
            }
            if (this.debug()) {
                this.logger().info(msg);
            }
            return null;
        }
        Properties properties = new Properties();
        try (BufferedReader reader = Files.newBufferedReader(propertiesFile);){
            properties.load(reader);
        }
        catch (IOException e) {
            this.logger().log(Level.SEVERE, String.format("Can't load system properties from file '%s'", propertiesFile), e);
            return null;
        }
        return properties;
    }

    boolean setSystemProperty(String name, String value) {
        try {
            System.setProperty(name, value);
        }
        catch (Throwable t) {
            String msg = String.format("Can't set system property '%s'", name);
            this.logger().log(Level.SEVERE, msg, t);
            return false;
        }
        if (this.debug()) {
            String msg = String.format("System property '%s' set to value '%s'", name, System.getProperty(name));
            this.logger().info(msg);
        }
        return true;
    }
}

